/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.wiki;

import java.util.ArrayList;
import java.util.List;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistent.ApplicationMetaDataImpl;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.wiki.IssueLinkProcessorMarkup;
import jetbrains.charisma.wiki.IssueLinkProcessorRemoveMarkup;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.wiki.processor.runtime.IWikiProcessor;
import jetbrains.mps.webr.wiki.processor.runtime.WikiBlockHelp;
import jetbrains.mps.webr.wiki.processor.runtime.WikiProcessor;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.security.Permissions;

public class IssueLinkProcessor
implements WikiProcessor {
    private static List<WikiBlockHelp> HELP;
    private static boolean HELP_READY;
    private static IssueLinkProcessor INSTANCE;

    private IssueLinkProcessor() {
    }

    public String clean(String arg) {
        if (arg == null) {
            return null;
        }
        int s = 0;
        for (int i = 0; i < arg.length(); ++i) {
            s += arg.charAt(i) == '\r' ? 0 : 1;
        }
        char[] ar = new char[s];
        s = 0;
        for (int i = 0; i < arg.length(); ++i) {
            if (arg.charAt(i) == '\r') continue;
            ar[s++] = arg.charAt(i);
        }
        return new String(ar);
    }

    public IWikiProcessor createProcessor(String s) {
        IssueLinkProcessorMarkup result = IssueLinkProcessorMarkup.create(this.clean(s));
        result.setWrapWithDiv(true);
        return result;
    }

    public IWikiProcessor createRemoveMarkupProcessor(String s) {
        IssueLinkProcessorRemoveMarkup result = IssueLinkProcessorRemoveMarkup.create(this.clean(s));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WikiBlockHelp> getHelp() {
        if (!HELP_READY) {
            IssueLinkProcessor issueLinkProcessor = this;
            synchronized (issueLinkProcessor) {
                if (!HELP_READY) {
                    HELP = ListSequence.fromList(new ArrayList());
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueLink.Link_to_issue_", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return IssueLinkProcessor.concat(new String[]{((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)QueryOperations.getFirst((Iterable)((Permissions)ServiceLocator.getBean((String)"permissions")).apply(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (Iterable)QueryOperations.queryGetAll((String)"Issue"))), (String)"Issue")).getId(QueryOperations.getFirst((Iterable)((Permissions)ServiceLocator.getBean((String)"permissions")).apply(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (Iterable)QueryOperations.queryGetAll((String)"Issue"))))});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueLink.Link_to_issue_attachment", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return IssueLinkProcessor.concat(new String[]{"[file:attachment.png]"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueLink.Draw_picture", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return IssueLinkProcessor.concat(new String[]{"!" + ((ApplicationMetaDataImpl)DnqUtils.getPersistentClassInstance((Entity)((Entity)ServiceLocator.getBean((String)"applicationMetaData")), (String)"ApplicationMetaData")).getLogoUrl((Entity)ServiceLocator.getBean((String)"applicationMetaData")).substring(((ApplicationMetaDataImpl)DnqUtils.getPersistentClassInstance((Entity)((Entity)ServiceLocator.getBean((String)"applicationMetaData")), (String)"ApplicationMetaData")).getLogoUrl((Entity)ServiceLocator.getBean((String)"applicationMetaData")).lastIndexOf(47) + 1) + "!"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueLink.User_login", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return IssueLinkProcessor.concat(new String[]{"@root"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TextColorer.You_can_color_your_text_use_keyword_or_#RRGGBB", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return IssueLinkProcessor.concat(new String[]{"{color:green}" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TextColorer.green", new Object[0]) + "{color} " + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TextColorer.and", new Object[0]) + " {color:#E6E6FA}" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TextColorer.another_color", new Object[0]) + "{color}"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Level_4_header", new Object[]{4});
                        }
                    }, (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return IssueLinkProcessor.concat(new String[]{"====" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Level_4_header_sample", new Object[]{4}) + "====\r\n"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Level_3_header", new Object[]{3});
                        }
                    }, (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return IssueLinkProcessor.concat(new String[]{"===" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Level_3_header_sample", new Object[]{3}) + "===\r\n"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Level_2_header", new Object[]{2});
                        }
                    }, (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return IssueLinkProcessor.concat(new String[]{"==" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Level_2_header_sample", new Object[]{2}) + "==\r\n"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Level_1_header", new Object[]{1});
                        }
                    }, (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return IssueLinkProcessor.concat(new String[]{"=" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Level_1_header_sample", new Object[]{1}) + "=\r\n"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Bold_italic", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return IssueLinkProcessor.concat(new String[]{"'''''" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Bold_italic_sample", new Object[0]) + "'''''"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Bold", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return IssueLinkProcessor.concat(new String[]{"'''" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Bold_sample", new Object[0]) + "'''"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Italic", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return IssueLinkProcessor.concat(new String[]{"''" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Italic_sample", new Object[0]) + "''"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Strike", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return IssueLinkProcessor.concat(new String[]{"--" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.deleted", new Object[0]) + "--"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Line_break", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return IssueLinkProcessor.concat(new String[]{((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.first_line", new Object[0]), "-----", ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.second_line", new Object[0])});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Adds_text_on_mouseover", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return IssueLinkProcessor.concat(new String[]{"~~" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Text", new Object[0]) + "|" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Text_on_mouseover", new Object[0]) + "~~"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Underline", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return IssueLinkProcessor.concat(new String[]{"+" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Underline_sample", new Object[0]) + "+"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Bold_a", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return IssueLinkProcessor.concat(new String[]{"*" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Bold_a_sample", new Object[0]) + "*"});
                        }
                    }, true));
                    HELP_READY = true;
                }
            }
        }
        return HELP;
    }

    public static IssueLinkProcessor getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new IssueLinkProcessor();
        }
        return INSTANCE;
    }

    private static String concat(String ... strings) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            sb.append(strings[i]);
            if (i >= strings.length - 1) continue;
            sb.append('\n');
        }
        return sb.toString();
    }
}

