/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import java.util.Collection;
import java.util.Iterator;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.SingleEntityIterable;
import jetbrains.exodus.query.AddNullStaticTypedEntityIterable;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.Concat;
import jetbrains.exodus.query.ExcludeNullStaticTypedEntityIterable;
import jetbrains.exodus.query.GetAll;
import jetbrains.exodus.query.MetaDataAwareUniqueKeyIndicesEngine;
import jetbrains.exodus.query.Minus;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.NodeFactory;
import jetbrains.exodus.query.Or;
import jetbrains.exodus.query.SortEngine;
import jetbrains.exodus.query.StaticTypedEntityIterable;
import jetbrains.exodus.query.StaticTypedIterableDecorator;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.exodus.query.UniqueKeyIndicesEngine;
import jetbrains.exodus.query.Utils;
import jetbrains.exodus.query.metadata.AssociationEndMetaData;
import jetbrains.exodus.query.metadata.EntityMetaData;
import jetbrains.exodus.query.metadata.ModelMetaData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QueryEngine {
    private final ModelMetaData mmd;
    private final PersistentEntityStoreImpl persistentStore;
    private final UniqueKeyIndicesEngine ukiEngine;
    private SortEngine sortEngine;

    public QueryEngine(ModelMetaData mmd, PersistentEntityStoreImpl persistentStore) {
        this.mmd = mmd;
        this.persistentStore = persistentStore;
        this.ukiEngine = new MetaDataAwareUniqueKeyIndicesEngine(persistentStore, mmd);
    }

    protected Iterable<Entity> inMemorySelectDistinct(Iterable<Entity> it, String linkName) {
        throw new UnsupportedOperationException("NOT IMPLEMENTED YET");
    }

    protected Iterable<Entity> inMemorySelectManyDistinct(Iterable<Entity> it, String linkName) {
        throw new UnsupportedOperationException("NOT IMPLEMENTED YET");
    }

    protected Iterable<Entity> inMemoryIntersect(Iterable<Entity> left, Iterable<Entity> right) {
        throw new UnsupportedOperationException("NOT IMPLEMENTED YET");
    }

    protected Iterable<Entity> inMemoryUnion(Iterable<Entity> left, Iterable<Entity> right) {
        throw new UnsupportedOperationException("NOT IMPLEMENTED YET");
    }

    protected Iterable<Entity> inMemoryConcat(Iterable<Entity> left, Iterable<Entity> right) {
        throw new UnsupportedOperationException("NOT IMPLEMENTED YET");
    }

    protected Iterable<Entity> inMemoryExclude(Iterable<Entity> left, Iterable<Entity> right) {
        throw new UnsupportedOperationException("NOT IMPLEMENTED YET");
    }

    public ModelMetaData getModelMetaData() {
        return this.mmd;
    }

    public PersistentEntityStoreImpl getPersistentStore() {
        return this.persistentStore;
    }

    public UniqueKeyIndicesEngine getUniqueKeyIndicesEngine() {
        return this.ukiEngine;
    }

    public SortEngine getSortEngine() {
        return this.sortEngine;
    }

    public void setSortEngine(SortEngine sortEngine) {
        this.sortEngine = sortEngine;
    }

    protected void assertOperational() {
    }

    protected boolean isWrapped(@Nullable Iterable<Entity> it) {
        return true;
    }

    @NotNull
    protected EntityIterable wrap(@NotNull EntityIterable it) {
        return it;
    }

    @Nullable
    protected Iterable<Entity> wrap(@NotNull Entity entity) {
        return new SingleEntityIterable(this.persistentStore.getAndCheckCurrentTransaction(), entity.getId());
    }

    public boolean isPersistentIterable(Iterable<Entity> it) {
        return it instanceof EntityIterableBase;
    }

    public TreeKeepingEntityIterable queryGetAll(String entityType) {
        return this.query(null, entityType, NodeFactory.all());
    }

    public TreeKeepingEntityIterable query(@NotNull String entityType, @NotNull NodeBase tree) {
        return this.query(null, entityType, tree);
    }

    public TreeKeepingEntityIterable query(@Nullable Iterable<Entity> instance, @NotNull String entityType, @NotNull NodeBase tree) {
        return new TreeKeepingEntityIterable(instance, entityType, tree, this);
    }

    public Iterable<Entity> intersect(Iterable<Entity> left, Iterable<Entity> right) {
        if (left == right) {
            return left;
        }
        if (QueryEngine.isEmptyIterable(left) || QueryEngine.isEmptyIterable(right)) {
            return EntityIterableBase.EMPTY;
        }
        if (left instanceof TreeKeepingEntityIterable) {
            TreeKeepingEntityIterable l = (TreeKeepingEntityIterable)left;
            String leftType = l.getEntityType();
            if (right instanceof TreeKeepingEntityIterable) {
                TreeKeepingEntityIterable r = (TreeKeepingEntityIterable)right;
                if (l.getInstance() == r.getInstance()) {
                    String rightType = r.getEntityType();
                    if (Utils.isTypeOf(leftType, rightType, this.mmd)) {
                        return new TreeKeepingEntityIterable(r.getInstance(), leftType, new And(l.getTree(), r.getTree()), l.annotatedTree, r.annotatedTree, this);
                    }
                    if (Utils.isTypeOf(rightType, leftType, this.mmd)) {
                        return new TreeKeepingEntityIterable(r.getInstance(), rightType, new And(l.getTree(), r.getTree()), l.annotatedTree, r.annotatedTree, this);
                    }
                }
            }
        }
        String staticType = null;
        if (left instanceof StaticTypedEntityIterable) {
            StaticTypedEntityIterable l = (StaticTypedEntityIterable)left;
            String leftType = l.getEntityType();
            if (right instanceof StaticTypedEntityIterable) {
                StaticTypedEntityIterable r = (StaticTypedEntityIterable)right;
                String rightType = r.getEntityType();
                if (Utils.isTypeOf(rightType, leftType, this.mmd)) {
                    staticType = rightType;
                } else if (Utils.isTypeOf(leftType, rightType, this.mmd)) {
                    staticType = leftType;
                }
                if (leftType.equals(rightType)) {
                    if (QueryEngine.isGetAllTree(l)) {
                        return new ExcludeNullStaticTypedEntityIterable(rightType, r, this);
                    }
                    if (QueryEngine.isGetAllTree(r)) {
                        return new ExcludeNullStaticTypedEntityIterable(leftType, l, this);
                    }
                }
            }
        }
        right = this.instantiateAndAdjust(right);
        left = this.instantiateAndAdjust(left);
        StaticTypedIterableDecorator result = this.intersectNonTrees(left, right);
        return staticType != null ? new StaticTypedIterableDecorator(staticType, result, this) : result;
    }

    public Iterable<Entity> union(Iterable<Entity> left, Iterable<Entity> right) {
        if (left == right) {
            return left;
        }
        if (QueryEngine.isEmptyIterable(left)) {
            return right;
        }
        if (QueryEngine.isEmptyIterable(right)) {
            return left;
        }
        if (left instanceof TreeKeepingEntityIterable) {
            TreeKeepingEntityIterable l = (TreeKeepingEntityIterable)left;
            String leftType = l.getEntityType();
            if (right instanceof TreeKeepingEntityIterable) {
                TreeKeepingEntityIterable r = (TreeKeepingEntityIterable)right;
                if (l.getInstance() == r.getInstance() && leftType.equals(r.getEntityType())) {
                    return new TreeKeepingEntityIterable(r.getInstance(), leftType, new Or(l.getTree(), r.getTree()), l.annotatedTree, r.annotatedTree, this);
                }
            }
        }
        String staticType = null;
        if (left instanceof StaticTypedEntityIterable) {
            StaticTypedEntityIterable r;
            String rightType;
            StaticTypedEntityIterable l = (StaticTypedEntityIterable)left;
            String leftType = l.getEntityType();
            if (right instanceof StaticTypedEntityIterable && leftType.equals(rightType = (r = (StaticTypedEntityIterable)right).getEntityType())) {
                staticType = rightType;
                if (QueryEngine.isGetAllTree(l)) {
                    return new AddNullStaticTypedEntityIterable(staticType, l, r, this);
                }
                if (QueryEngine.isGetAllTree(r)) {
                    return new AddNullStaticTypedEntityIterable(staticType, r, l, this);
                }
            }
        }
        right = this.instantiateAndAdjust(right);
        left = this.instantiateAndAdjust(left);
        StaticTypedIterableDecorator result = this.unionNonTrees(left, right);
        return staticType != null ? new StaticTypedIterableDecorator(staticType, result, this) : result;
    }

    public Iterable<Entity> concat(Iterable<Entity> left, Iterable<Entity> right) {
        if (QueryEngine.isEmptyIterable(left)) {
            return right;
        }
        if (QueryEngine.isEmptyIterable(right)) {
            return left;
        }
        if (left instanceof TreeKeepingEntityIterable) {
            TreeKeepingEntityIterable l = (TreeKeepingEntityIterable)left;
            String leftType = l.getEntityType();
            if (right instanceof TreeKeepingEntityIterable) {
                TreeKeepingEntityIterable r = (TreeKeepingEntityIterable)right;
                if (l.getInstance() == r.getInstance() && leftType.equals(r.getEntityType())) {
                    return new TreeKeepingEntityIterable(r.getInstance(), leftType, new Concat(l.getTree(), r.getTree()), l.annotatedTree, r.annotatedTree, this);
                }
            }
        }
        String staticType = QueryEngine.retrieveStaticType(left, right);
        right = this.instantiateAndAdjust(right);
        left = this.instantiateAndAdjust(left);
        StaticTypedIterableDecorator result = this.concatNonTrees(left, right);
        return staticType != null ? new StaticTypedIterableDecorator(staticType, result, this) : result;
    }

    public Iterable<Entity> exclude(Iterable<Entity> left, Iterable<Entity> right) {
        if (QueryEngine.isEmptyIterable(left) || left == right) {
            return EntityIterableBase.EMPTY;
        }
        if (QueryEngine.isEmptyIterable(right)) {
            return left;
        }
        if (left instanceof TreeKeepingEntityIterable) {
            TreeKeepingEntityIterable l = (TreeKeepingEntityIterable)left;
            String leftType = l.getEntityType();
            if (right instanceof TreeKeepingEntityIterable) {
                TreeKeepingEntityIterable r = (TreeKeepingEntityIterable)right;
                if (l.getInstance() == r.getInstance() && leftType.equals(r.getEntityType())) {
                    return new TreeKeepingEntityIterable(r.getInstance(), leftType, new Minus(l.getTree(), r.getTree()), l.annotatedTree, r.annotatedTree, this);
                }
            }
        }
        String staticType = QueryEngine.retrieveStaticType(left, right);
        right = this.instantiateAndAdjust(right);
        left = this.instantiateAndAdjust(left);
        StaticTypedIterableDecorator result = this.excludeNonTrees(left, right);
        return staticType != null ? new StaticTypedIterableDecorator(staticType, result, this) : result;
    }

    public Iterable<Entity> selectDistinct(Iterable<Entity> it, String linkName) {
        if (it == null) {
            return EntityIterableBase.EMPTY;
        }
        if (this.mmd != null) {
            if (it instanceof StaticTypedEntityIterable) {
                AssociationEndMetaData aemd;
                String entityType;
                EntityMetaData emd;
                StaticTypedEntityIterable ktei = (StaticTypedEntityIterable)it;
                if (this.isPersistentIterable(it = this.toEntityIterable(it)) && (emd = this.mmd.getEntityMetaData(entityType = ktei.getEntityType())) != null && (aemd = emd.getAssociationEndMetaData(linkName)) != null) {
                    String resultType = aemd.getOppositeEntityMetaData().getType();
                    return new StaticTypedIterableDecorator(resultType, this.selectDistinctImpl((EntityIterableBase)it, linkName), this);
                }
            } else if (this.isPersistentIterable(it)) {
                return this.selectDistinctImpl((EntityIterableBase)it, linkName);
            }
        }
        return this.inMemorySelectDistinct(it, linkName);
    }

    public Iterable<Entity> selectManyDistinct(Iterable<Entity> it, String linkName) {
        if (it == null) {
            return EntityIterableBase.EMPTY;
        }
        if (this.mmd != null) {
            if (it instanceof StaticTypedEntityIterable) {
                AssociationEndMetaData aemd;
                String entityType;
                EntityMetaData emd;
                StaticTypedEntityIterable tree = (StaticTypedEntityIterable)it;
                if (this.isPersistentIterable(it = this.toEntityIterable(it)) && (emd = this.mmd.getEntityMetaData(entityType = tree.getEntityType())) != null && (aemd = emd.getAssociationEndMetaData(linkName)) != null) {
                    String resultType = aemd.getOppositeEntityMetaData().getType();
                    return new StaticTypedIterableDecorator(resultType, this.selectManyDistinctImpl((EntityIterableBase)it, linkName), this);
                }
            } else if (this.isPersistentIterable(it)) {
                return this.selectManyDistinctImpl((EntityIterableBase)it, linkName);
            }
        }
        return this.inMemorySelectManyDistinct(it, linkName);
    }

    public Iterable<Entity> toEntityIterable(Iterable<Entity> it) {
        if (it instanceof StaticTypedEntityIterable) {
            it = ((StaticTypedEntityIterable)it).instantiate();
        }
        return this.adjustEntityIterable(it);
    }

    public Iterable<Entity> intersectNonTrees(Iterable<Entity> left, Iterable<Entity> right) {
        if (this.isPersistentIterable(left) && this.isPersistentIterable(right)) {
            return this.wrap(((EntityIterableBase)left).getSource().intersect((EntityIterable)((EntityIterableBase)right).getSource()));
        }
        return this.inMemoryIntersect(left, right);
    }

    public Iterable<Entity> unionNonTrees(Iterable<Entity> left, Iterable<Entity> right) {
        if (this.isPersistentIterable(left) && this.isPersistentIterable(right)) {
            return this.wrap(((EntityIterableBase)left).getSource().union((EntityIterable)((EntityIterableBase)right).getSource()));
        }
        return this.inMemoryUnion(left, right);
    }

    public Iterable<Entity> concatNonTrees(Iterable<Entity> left, Iterable<Entity> right) {
        if (this.isPersistentIterable(left) && this.isPersistentIterable(right)) {
            return this.wrap(((EntityIterableBase)left).getSource().concat((EntityIterable)((EntityIterableBase)right).getSource()));
        }
        return this.inMemoryConcat(left, right);
    }

    public Iterable<Entity> excludeNonTrees(Iterable<Entity> left, Iterable<Entity> right) {
        if (this.isPersistentIterable(left) && this.isPersistentIterable(right)) {
            return this.wrap(((EntityIterableBase)left).getSource().minus((EntityIterable)((EntityIterableBase)right).getSource()));
        }
        return this.inMemoryExclude(left, right);
    }

    private Iterable<Entity> instantiateAndAdjust(Iterable<Entity> it) {
        return this.adjustEntityIterable(StaticTypedEntityIterable.instantiate(it));
    }

    private Iterable<Entity> selectDistinctImpl(EntityIterableBase it, String linkName) {
        this.assertOperational();
        return this.wrap(it.getSource().selectDistinct(linkName));
    }

    private Iterable<Entity> selectManyDistinctImpl(EntityIterableBase it, String linkName) {
        this.assertOperational();
        return this.wrap(it.getSource().selectManyDistinct(linkName));
    }

    public Iterable<Entity> adjustEntityIterable(Iterable<Entity> it) {
        if (it == EntityIterableBase.EMPTY) {
            return it;
        }
        if (it instanceof Collection) {
            Collection collection = (Collection)it;
            Iterator itr = collection.iterator();
            if (itr.hasNext()) {
                Iterable<Entity> wrapped;
                Entity e = (Entity)itr.next();
                if (!itr.hasNext() && (wrapped = this.wrap(e)) != null) {
                    it = wrapped;
                }
            } else {
                return EntityIterableBase.EMPTY;
            }
        }
        return this.isPersistentIterable((Iterable<Entity>)it) && !this.isWrapped((Iterable<Entity>)it) ? this.wrap((EntityIterable)((EntityIterableBase)it).getSource()) : it;
    }

    public Iterable<Entity> unionAdjusted(Iterable<Entity> left, Iterable<Entity> right) {
        return this.unionNonTrees(this.adjustEntityIterable(left), this.adjustEntityIterable(right));
    }

    public Iterable<Entity> intersectAdjusted(Iterable<Entity> left, Iterable<Entity> right) {
        return this.intersectNonTrees(this.adjustEntityIterable(left), this.adjustEntityIterable(right));
    }

    public Iterable<Entity> concatAdjusted(Iterable<Entity> left, Iterable<Entity> right) {
        return this.concatNonTrees(this.adjustEntityIterable(left), this.adjustEntityIterable(right));
    }

    public Iterable<Entity> excludeAdjusted(Iterable<Entity> left, Iterable<Entity> right) {
        return this.excludeNonTrees(this.adjustEntityIterable(left), this.adjustEntityIterable(right));
    }

    public EntityIterable instantiateGetAll(@NotNull String entityType) {
        return this.instantiateGetAll((StoreTransaction)this.getPersistentStore().getAndCheckCurrentTransaction(), entityType);
    }

    public EntityIterable instantiateGetAll(@NotNull StoreTransaction txn, @NotNull String entityType) {
        return txn.getAll(entityType);
    }

    public static boolean isEmptyIterable(Iterable<Entity> it) {
        return it == null || it == EntityIterableBase.EMPTY || it instanceof StaticTypedIterableDecorator && ((StaticTypedIterableDecorator)it).getDecorated() == EntityIterableBase.EMPTY;
    }

    public static boolean isGetAllTree(StaticTypedEntityIterable tree) {
        return tree instanceof TreeKeepingEntityIterable && ((TreeKeepingEntityIterable)tree).getTree() instanceof GetAll;
    }

    private static String retrieveStaticType(Iterable<Entity> left, Iterable<Entity> right) {
        if (left instanceof StaticTypedEntityIterable) {
            String rightType;
            String leftType = ((StaticTypedEntityIterable)left).getEntityType();
            if (right instanceof StaticTypedEntityIterable && leftType.equals(rightType = ((StaticTypedEntityIterable)right).getEntityType())) {
                return rightType;
            }
        }
        return null;
    }
}

