/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.monitoring;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.glassfish.jersey.server.internal.monitoring.SlidingWindowTimeReservoir;
import org.glassfish.jersey.server.internal.monitoring.TimeReservoir;
import org.glassfish.jersey.server.internal.monitoring.UniformTimeReservoir;
import org.glassfish.jersey.server.internal.monitoring.UniformTimeSnapshot;
import org.glassfish.jersey.server.monitoring.TimeWindowStatistics;

final class TimeWindowStatisticsImpl
implements TimeWindowStatistics {
    private static final ConcurrentHashMap<Long, TimeWindowStatisticsImpl> EMPTY = new ConcurrentHashMap(6);
    private final long interval;
    private final long minimumDuration;
    private final long maximumDuration;
    private final long averageDuration;
    private final long totalCount;
    private final double requestsPerSecond;

    private TimeWindowStatisticsImpl(long interval, double requestsPerSecond, long minimumDuration, long maximumDuration, long averageDuration, long totalCount) {
        this.interval = interval;
        this.requestsPerSecond = requestsPerSecond;
        this.minimumDuration = minimumDuration;
        this.maximumDuration = maximumDuration;
        this.averageDuration = averageDuration;
        this.totalCount = totalCount;
    }

    @Override
    public long getTimeWindow() {
        return this.interval;
    }

    @Override
    public double getRequestsPerSecond() {
        return this.requestsPerSecond;
    }

    @Override
    public long getMinimumDuration() {
        return this.minimumDuration;
    }

    @Override
    public long getMaximumDuration() {
        return this.maximumDuration;
    }

    @Override
    public long getRequestCount() {
        return this.totalCount;
    }

    @Override
    public TimeWindowStatistics snapshot() {
        return this;
    }

    @Override
    public long getAverageDuration() {
        return this.averageDuration;
    }

    static {
        EMPTY.putIfAbsent(0L, new TimeWindowStatisticsImpl(0L, 0.0, 0L, 0L, 0L, 0L));
    }

    static class Builder {
        private final long interval;
        private final TimeReservoir durationReservoir;

        Builder(long timeWindowSize, TimeUnit timeUnit) {
            this(timeWindowSize, timeUnit, System.currentTimeMillis());
        }

        Builder(long timeWindowSize, TimeUnit timeUnit, long now) {
            this.interval = timeUnit.toMillis(timeWindowSize);
            this.durationReservoir = this.interval == 0L ? new UniformTimeReservoir(now, TimeUnit.MILLISECONDS) : new SlidingWindowTimeReservoir(timeWindowSize, timeUnit, now, TimeUnit.MILLISECONDS);
        }

        void addRequest(long requestTime, long duration) {
            this.durationReservoir.update(duration, requestTime, TimeUnit.MILLISECONDS);
        }

        TimeWindowStatisticsImpl build() {
            return this.build(System.currentTimeMillis());
        }

        TimeWindowStatisticsImpl build(long currentTime) {
            UniformTimeSnapshot durationReservoirSnapshot = this.durationReservoir.getSnapshot(currentTime, TimeUnit.MILLISECONDS);
            if (durationReservoirSnapshot.size() == 0L) {
                return this.getOrCreateEmptyStats(this.interval);
            }
            double requestsPerSecond = (double)(1000L * durationReservoirSnapshot.size()) / (double)durationReservoirSnapshot.getTimeInterval(TimeUnit.MILLISECONDS);
            return new TimeWindowStatisticsImpl(this.interval, requestsPerSecond, durationReservoirSnapshot.getMin(), durationReservoirSnapshot.getMax(), (long)durationReservoirSnapshot.getMean(), durationReservoirSnapshot.size());
        }

        private TimeWindowStatisticsImpl getOrCreateEmptyStats(long interval) {
            if (!EMPTY.containsKey(interval)) {
                EMPTY.putIfAbsent(interval, new TimeWindowStatisticsImpl(interval, 0.0, -1L, -1L, -1L, 0L));
            }
            return (TimeWindowStatisticsImpl)EMPTY.get(interval);
        }

        public long getInterval() {
            return this.interval;
        }
    }
}

