/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.github.rest.client.json;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.auth.module.github.rest.client.api.GithubUserDetails;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.AuthmoduleJSON;
import jetbrains.jetpass.rest.dto.DetailsJSON;
import jetbrains.jetpass.rest.dto.EmailJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="githubdetails")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=GithubdetailsJSON.class)
public class GithubdetailsJSON
extends DetailsJSON
implements GithubUserDetails {
    @XmlElement(name="login")
    private String login;
    @XmlElement(name="fullName")
    private String fullName;
    @XmlElement(name="avatar")
    private String avatar;

    public GithubdetailsJSON() {
    }

    public GithubdetailsJSON(@NotNull GithubUserDetails that) {
        AuthmoduleJSON ref;
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias it : that.getAliases()) {
                aggregated.add(new AliasJSON(it));
            }
            this.setAliases(aggregated);
        }
        if (that.getEmail() != null) {
            this.setEmail(new EmailJSON(that.getEmail()));
        }
        if (that.getAuthModule() != null) {
            ref = new AuthmoduleJSON();
            ref.setId(that.getAuthModule().getId());
            this.setAuthModule(ref);
        }
        this.setAuthModuleName(that.getAuthModuleName());
        if (that.getUser() != null) {
            ref = new UserJSON();
            ref.setId(that.getUser().getId());
            this.setUser((UserJSON)ref);
        }
        this.setLastAccessTime(that.getLastAccessTime());
        this.setLastAccessAddress(that.getLastAccessAddress());
        this.setLastAccessUserAgent(that.getLastAccessUserAgent());
        this.setLogin(that.getLogin());
        this.setFullName(that.getFullName());
        this.setAvatar(that.getAvatar());
    }

    @Override
    @Nullable
    public String getLogin() {
        return this.login;
    }

    @Override
    @Nullable
    public String getFullName() {
        return this.fullName;
    }

    @Override
    @Nullable
    public String getAvatar() {
        return this.avatar;
    }

    @XmlTransient
    public void setLogin(@Nullable String login) {
        this.login = login;
    }

    @XmlTransient
    public void setFullName(@Nullable String fullName) {
        this.fullName = fullName;
    }

    @XmlTransient
    public void setAvatar(@Nullable String avatar) {
        this.avatar = avatar;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GithubUserDetails)) {
            return false;
        }
        GithubUserDetails that = (GithubUserDetails)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static GithubdetailsJSON wrap(@NotNull GithubUserDetails that) {
        if (that instanceof GithubdetailsJSON) {
            return (GithubdetailsJSON)that;
        }
        return new GithubdetailsJSON(that);
    }
}

