/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus;

import java.util.UUID;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.Environments;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.env.TransactionalComputable;
import jetbrains.exodus.env.TransactionalExecutable;
import jetbrains.exodus.util.LightOutputStream;
import org.jetbrains.annotations.NotNull;

public class StressTest {
    public static void main(String[] args) throws Exception {
        EnvironmentConfig config = new EnvironmentConfig().setLogFileSize(40960L);
        final Environment env = Environments.newInstance("d:/guids", config);
        final Store store = (Store)env.computeInTransaction((TransactionalComputable)new TransactionalComputable<Store>(){

            public Store compute(@NotNull Transaction txn) {
                return env.openStore("stressdb", StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, txn);
            }
        });
        long started = System.currentTimeMillis();
        int count = 300;
        int batch = 100000;
        final Event[] evts = new Event[100000];
        for (int i = 0; i < count; ++i) {
            for (int j = 0; j < 100000; ++j) {
                UUID g = UUID.randomUUID();
                evts[j] = new Event(g.getLeastSignificantBits(), g.getMostSignificantBits(), j);
            }
            env.executeInTransaction(new TransactionalExecutable(){

                public void execute(@NotNull Transaction txn) {
                    for (int j = 0; j < 100000; ++j) {
                        store.add(txn, evts[j].getKey(), evts[j].getValue());
                    }
                }
            });
            if (i * 100000 % 100000 != 0) continue;
            System.out.println("count = " + i * 100000 + ", ms = " + (System.currentTimeMillis() - started));
        }
        env.close();
    }

    public static class Event {
        long key1;
        long key2;
        double val;

        public static ByteIterable get(long p1, long p2) {
            LightOutputStream output = new LightOutputStream();
            output.writeUnsignedLong(p1);
            output.writeUnsignedLong(p2);
            return output.asArrayByteIterable();
        }

        public static Event getEvent(ByteIterable kbytes, ByteIterable vbytes) {
            ByteIterator iterator = kbytes.iterator();
            long p1 = LongBinding.entryToUnsignedLong((ByteIterator)iterator, (int)8);
            iterator.skip(8L);
            long p2 = LongBinding.entryToUnsignedLong((ByteIterator)iterator, (int)8);
            long v = LongBinding.entryToLong((ByteIterable)vbytes);
            return new Event(p1, p2, Double.longBitsToDouble(v));
        }

        public Event(long key1, long key2, double val) {
            this.key1 = key1;
            this.key2 = key2;
            this.val = val;
        }

        public void set(long p1, long p2, double val) {
            this.key1 = p1;
            this.key2 = p2;
            this.val = val;
        }

        public String toString() {
            return this.key1 + ":" + this.key2 + "; val=" + this.val;
        }

        public ByteIterable getKey() {
            return Event.get(this.key1, this.key2);
        }

        public ByteIterable getValue() {
            return LongBinding.longToEntry((long)Double.doubleToLongBits(this.val));
        }
    }
}

