/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import java.util.ConcurrentModificationException;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.StoreImpl;
import jetbrains.exodus.env.TransactionBase;
import jetbrains.exodus.env.TransactionImpl;
import jetbrains.exodus.tree.ITree;
import jetbrains.exodus.tree.ITreeCursor;
import org.jetbrains.annotations.NotNull;

final class CursorImpl
implements Cursor {
    private static final String CANT_DELETE_MODIFIED_MSG = "Can't delete (pair not found in mutable tree)";
    @NotNull
    private final StoreImpl store;
    @NotNull
    private final TransactionBase txn;
    private ITreeCursor treeCursor;
    private volatile boolean isClosed;

    CursorImpl(@NotNull StoreImpl store, @NotNull TransactionBase txn) {
        this.store = store;
        this.txn = txn;
        this.treeCursor = null;
        this.isClosed = false;
    }

    public boolean getNext() {
        this.checkTreeCursor();
        return this.treeCursor.getNext();
    }

    public boolean getNextDup() {
        this.checkTreeCursor();
        return this.treeCursor.getNextDup();
    }

    public boolean getNextNoDup() {
        this.checkTreeCursor();
        return this.treeCursor.getNextNoDup();
    }

    public boolean getPrev() {
        this.checkTreeCursor();
        return this.treeCursor.getPrev();
    }

    public boolean getPrevDup() {
        this.checkTreeCursor();
        return this.treeCursor.getPrevDup();
    }

    public boolean getPrevNoDup() {
        this.checkTreeCursor();
        return this.treeCursor.getPrevNoDup();
    }

    public boolean getLast() {
        this.checkTreeCursor();
        return this.treeCursor.getLast();
    }

    @NotNull
    public ByteIterable getKey() {
        this.checkTreeCursor();
        return this.treeCursor.getKey();
    }

    @NotNull
    public ByteIterable getValue() {
        this.checkTreeCursor();
        return this.treeCursor.getValue();
    }

    public ByteIterable getSearchKey(@NotNull ByteIterable key) {
        this.checkTreeCursor();
        this.setTreeNodesCache();
        return this.treeCursor.getSearchKey(key);
    }

    public ByteIterable getSearchKeyRange(@NotNull ByteIterable key) {
        this.checkTreeCursor();
        this.setTreeNodesCache();
        return this.treeCursor.getSearchKeyRange(key);
    }

    public boolean getSearchBoth(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        this.checkTreeCursor();
        this.setTreeNodesCache();
        return this.treeCursor.getSearchBoth(key, value);
    }

    public ByteIterable getSearchBothRange(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        this.checkTreeCursor();
        this.setTreeNodesCache();
        return this.treeCursor.getSearchBothRange(key, value);
    }

    public int count() {
        this.checkTreeCursor();
        return this.treeCursor.count();
    }

    public void close() {
        if (this.isClosed) {
            throw new ExodusException("Cursor is already closed");
        }
        if (this.treeCursor != null) {
            this.treeCursor.close();
        }
        this.isClosed = true;
    }

    public boolean deleteCurrent() {
        TransactionImpl txn = EnvironmentImpl.throwIfReadonly(this.txn, "Can't delete a key/value pair of cursor in read-only transaction");
        if (this.treeCursor == null) {
            this.treeCursor = txn.getMutableTree(this.store).openCursor();
        } else if (!this.treeCursor.isMutable()) {
            ByteIterable key = this.treeCursor.getKey();
            ByteIterable value = this.treeCursor.getValue();
            ITreeCursor newCursor = txn.getMutableTree(this.store).openCursor();
            if (newCursor.getSearchBoth(key, value)) {
                this.treeCursor = newCursor;
            } else {
                throw new ConcurrentModificationException(CANT_DELETE_MODIFIED_MSG);
            }
        }
        return this.treeCursor.deleteCurrent();
    }

    private void checkTreeCursor() {
        if (this.treeCursor == null) {
            this.treeCursor = this.txn.getTree(this.store).openCursor();
        }
    }

    private void setTreeNodesCache() {
        ITree tree = this.treeCursor.getTree();
        if (tree != null) {
            tree.setTreeNodesCache(this.store.getEnvironment().getTreeNodesCache());
        }
    }
}

