/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.log.ByteIterableWithAddress;
import jetbrains.exodus.log.ByteIteratorWithAddress;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.LoggableFactory;
import jetbrains.exodus.log.RandomAccessLoggable;
import jetbrains.exodus.log.RandomAccessLoggableImpl;
import jetbrains.exodus.util.LightOutputStream;
import org.jetbrains.annotations.NotNull;

final class DatabaseRoot
extends RandomAccessLoggableImpl {
    static final byte DATABASE_ROOT_TYPE = 1;
    private static final long MAGIC_DIFF = 199L;
    private static final LoggableFactory ROOT_FACTORY = new LoggableFactory(){

        @Override
        protected RandomAccessLoggable create(long address, @NotNull ByteIterableWithAddress data, int dataLength, int structureId) {
            ByteIteratorWithAddress it = data.iterator();
            long rootAddress = CompressedUnsignedLongByteIterable.getLong(it);
            int lastStructureId = CompressedUnsignedLongByteIterable.getInt(it);
            boolean isValid = rootAddress == CompressedUnsignedLongByteIterable.getLong(it) - (long)lastStructureId - 199L;
            return new DatabaseRoot(rootAddress, lastStructureId, isValid, address, data, dataLength);
        }
    };
    private final long rootAddress;
    private final int lastStructureId;
    private final boolean isValid;

    private DatabaseRoot(long rootAddress, int lastStructureId, boolean isValid, long address, @NotNull ByteIterableWithAddress data, int dataLength) {
        super(address, (byte)1, data, dataLength, 0);
        this.rootAddress = rootAddress;
        this.lastStructureId = lastStructureId;
        this.isValid = isValid;
    }

    long getRootAddress() {
        return this.rootAddress;
    }

    int getLastStructureId() {
        return this.lastStructureId;
    }

    boolean isValid() {
        return this.isValid;
    }

    static void register() {
        LoggableFactory.registerLoggable(1, ROOT_FACTORY);
    }

    static ByteIterable asByteIterable(long rootAddress, int lastStructureId) {
        LightOutputStream output = new LightOutputStream(20);
        CompressedUnsignedLongByteIterable.fillBytes(rootAddress, output);
        CompressedUnsignedLongByteIterable.fillBytes(lastStructureId, output);
        CompressedUnsignedLongByteIterable.fillBytes(rootAddress + (long)lastStructureId + 199L, output);
        return output.asArrayByteIterable();
    }
}

