/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import java.io.File;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jetbrains.exodus.backup.BackupStrategy;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.util.IOUtil;
import org.jetbrains.annotations.NotNull;

class EnvironmentBackupStrategyImpl
extends BackupStrategy {
    @NotNull
    private final EnvironmentImpl environment;

    public EnvironmentBackupStrategyImpl(@NotNull EnvironmentImpl environment) {
        this.environment = environment;
    }

    public void beforeBackup() {
        this.environment.suspendGC();
        this.environment.flushAndSync();
    }

    public Iterable<BackupStrategy.FileDescriptor> listFiles() {
        return new Iterable<BackupStrategy.FileDescriptor>(){
            private final File[] files;
            private int i;
            private BackupStrategy.FileDescriptor next;
            {
                this.files = IOUtil.listFiles((File)new File(EnvironmentBackupStrategyImpl.this.environment.getLog().getLocation()));
                this.i = 0;
            }

            @Override
            public Iterator<BackupStrategy.FileDescriptor> iterator() {
                return new Iterator<BackupStrategy.FileDescriptor>(){

                    @Override
                    public boolean hasNext() {
                        if (next != null) {
                            return true;
                        }
                        while (i < files.length) {
                            long fileSize;
                            File file = files[i++];
                            if (!file.isFile() || (fileSize = file.length()) == 0L || !file.getName().endsWith(".xd")) continue;
                            next = new BackupStrategy.FileDescriptor(file, "", fileSize);
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public BackupStrategy.FileDescriptor next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        BackupStrategy.FileDescriptor result = next;
                        next = null;
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public void afterBackup() {
        this.environment.resumeGC();
    }
}

