/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import jetbrains.exodus.ConfigSettingChangeListener;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.backup.BackupStrategy;
import jetbrains.exodus.core.dataStructures.ConcurrentLongObjectCache;
import jetbrains.exodus.core.dataStructures.LongObjectCacheBase;
import jetbrains.exodus.core.dataStructures.ObjectCacheBase;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentBackupStrategyImpl;
import jetbrains.exodus.env.EnvironmentClosedException;
import jetbrains.exodus.env.MetaTree;
import jetbrains.exodus.env.ReadonlyTransaction;
import jetbrains.exodus.env.ReadonlyTransactionException;
import jetbrains.exodus.env.ReentrantTransactionDispatcher;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.StoreGetCache;
import jetbrains.exodus.env.StoreImpl;
import jetbrains.exodus.env.StuckTransactionMonitor;
import jetbrains.exodus.env.TemporaryEmptyStore;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.env.TransactionBase;
import jetbrains.exodus.env.TransactionImpl;
import jetbrains.exodus.env.TransactionSet;
import jetbrains.exodus.env.TransactionalComputable;
import jetbrains.exodus.env.TransactionalExecutable;
import jetbrains.exodus.env.management.EnvironmentConfig;
import jetbrains.exodus.env.management.EnvironmentStatistics;
import jetbrains.exodus.gc.GarbageCollector;
import jetbrains.exodus.gc.UtilizationProfile;
import jetbrains.exodus.log.ExpiredLoggableInfo;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogConfig;
import jetbrains.exodus.tree.TreeMetaInfo;
import jetbrains.exodus.tree.btree.BTree;
import jetbrains.exodus.tree.btree.BTreeBalancePolicy;
import jetbrains.exodus.util.DeferredIO;
import jetbrains.exodus.util.IOUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentImpl
implements Environment {
    public static final int META_TREE_ID = 1;
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentImpl.class);
    private static final String ENVIRONMENT_PROPERTIES_FILE = "exodus.properties";
    @NotNull
    private final Log log;
    @NotNull
    private final jetbrains.exodus.env.EnvironmentConfig ec;
    private BTreeBalancePolicy balancePolicy;
    private MetaTree metaTree;
    private final AtomicInteger structureId;
    @NotNull
    private final TransactionSet txns;
    private final LinkedList<RunnableWithTxnRoot> txnSafeTasks;
    @Nullable
    private StoreGetCache storeGetCache;
    @Nullable
    private SoftReference<LongObjectCacheBase> treeNodesCache;
    private final EnvironmentSettingsListener envSettingsListener;
    private final GarbageCollector gc;
    private final Object commitLock = new Object();
    private final Object metaLock = new Object();
    private final ReentrantTransactionDispatcher txnDispatcher;
    private final ReentrantTransactionDispatcher roTxnDispatcher;
    @NotNull
    private final jetbrains.exodus.env.EnvironmentStatistics statistics;
    @Nullable
    private final EnvironmentConfig configMBean;
    @Nullable
    private final EnvironmentStatistics statisticsMBean;
    private volatile Throwable throwableOnCommit;
    private EnvironmentClosedException throwableOnClose;

    EnvironmentImpl(@NotNull Log log, @NotNull jetbrains.exodus.env.EnvironmentConfig ec) {
        this.log = log;
        this.ec = ec;
        EnvironmentImpl.applyEnvironmentSettings(log.getLocation(), ec);
        Pair<MetaTree, Integer> meta = MetaTree.create(this);
        this.metaTree = (MetaTree)meta.getFirst();
        this.structureId = new AtomicInteger((Integer)meta.getSecond());
        this.txns = new TransactionSet();
        this.txnSafeTasks = new LinkedList();
        this.invalidateStoreGetCache();
        this.invalidateTreeNodesCache();
        this.envSettingsListener = new EnvironmentSettingsListener();
        ec.addChangedSettingsListener((ConfigSettingChangeListener)this.envSettingsListener);
        this.gc = new GarbageCollector(this);
        this.txnDispatcher = new ReentrantTransactionDispatcher(ec.getEnvMaxParallelTxns());
        this.roTxnDispatcher = new ReentrantTransactionDispatcher(ec.getEnvMaxParallelReadonlyTxns());
        this.statistics = new jetbrains.exodus.env.EnvironmentStatistics(this);
        if (ec.isManagementEnabled()) {
            this.configMBean = new EnvironmentConfig(this);
            this.statisticsMBean = ec.getEnvGatherStatistics() ? new EnvironmentStatistics(this) : null;
        } else {
            this.configMBean = null;
            this.statisticsMBean = null;
        }
        this.throwableOnCommit = null;
        this.throwableOnClose = null;
        if (this.transactionTimeout() > 0) {
            new StuckTransactionMonitor(this);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Exodus environment created: " + log.getLocation());
        }
    }

    public long getCreated() {
        return this.log.getCreated();
    }

    @NotNull
    public String getLocation() {
        return this.log.getLocation();
    }

    @NotNull
    public jetbrains.exodus.env.EnvironmentConfig getEnvironmentConfig() {
        return this.ec;
    }

    @NotNull
    public jetbrains.exodus.env.EnvironmentStatistics getStatistics() {
        return this.statistics;
    }

    public GarbageCollector getGC() {
        return this.gc;
    }

    @NotNull
    public StoreImpl openStore(@NotNull String name, @NotNull StoreConfig config, @NotNull Transaction transaction) {
        TransactionBase txn = (TransactionBase)transaction;
        return this.openStoreImpl(name, config, txn, txn.getTreeMetaInfo(name));
    }

    @Nullable
    public StoreImpl openStore(@NotNull String name, @NotNull StoreConfig config, @NotNull Transaction transaction, boolean creationRequired) {
        TransactionBase txn = (TransactionBase)transaction;
        TreeMetaInfo metaInfo = txn.getTreeMetaInfo(name);
        if (metaInfo == null && !creationRequired) {
            return null;
        }
        return this.openStoreImpl(name, config, txn, metaInfo);
    }

    @NotNull
    public TransactionBase beginTransaction() {
        return this.beginTransaction(null, false, false);
    }

    @NotNull
    public TransactionBase beginTransaction(Runnable beginHook) {
        return this.beginTransaction(beginHook, false, false);
    }

    @NotNull
    public Transaction beginExclusiveTransaction() {
        return this.beginTransaction(null, true, false);
    }

    @NotNull
    public Transaction beginExclusiveTransaction(Runnable beginHook) {
        return this.beginTransaction(beginHook, true, false);
    }

    @NotNull
    public Transaction beginReadonlyTransaction() {
        return this.beginReadonlyTransaction(null);
    }

    @NotNull
    public TransactionBase beginReadonlyTransaction(Runnable beginHook) {
        this.checkIsOperative();
        return new ReadonlyTransaction(this, beginHook);
    }

    @NotNull
    public TransactionImpl beginGCTransaction() {
        if (this.ec.getEnvIsReadonly()) {
            throw new ReadonlyTransactionException("Can't start GC transaction on read-only Environment");
        }
        return new TransactionImpl(this, null, this.ec.getGcUseExclusiveTransaction(), true){

            @Override
            boolean isGCTransaction() {
                return true;
            }
        };
    }

    public void executeInTransaction(@NotNull TransactionalExecutable executable) {
        EnvironmentImpl.executeInTransaction(executable, this.beginTransaction());
    }

    public void executeInExclusiveTransaction(@NotNull TransactionalExecutable executable) {
        EnvironmentImpl.executeInTransaction(executable, this.beginExclusiveTransaction());
    }

    public void executeInReadonlyTransaction(@NotNull TransactionalExecutable executable) {
        Transaction txn = this.beginReadonlyTransaction();
        try {
            executable.execute(txn);
        }
        finally {
            EnvironmentImpl.abortIfNotFinished(txn);
        }
    }

    public <T> T computeInTransaction(@NotNull TransactionalComputable<T> computable) {
        return EnvironmentImpl.computeInTransaction(computable, this.beginTransaction());
    }

    public <T> T computeInExclusiveTransaction(@NotNull TransactionalComputable<T> computable) {
        return EnvironmentImpl.computeInTransaction(computable, this.beginExclusiveTransaction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T computeInReadonlyTransaction(@NotNull TransactionalComputable<T> computable) {
        Transaction txn = this.beginReadonlyTransaction();
        try {
            Object object = computable.compute(txn);
            return (T)object;
        }
        finally {
            EnvironmentImpl.abortIfNotFinished(txn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTransactionSafeTask(@NotNull Runnable task) {
        long newestTxnRoot = this.getNewestTxnRootAddress();
        if (newestTxnRoot == Long.MIN_VALUE) {
            task.run();
        } else {
            LinkedList<RunnableWithTxnRoot> linkedList = this.txnSafeTasks;
            synchronized (linkedList) {
                this.txnSafeTasks.addLast(new RunnableWithTxnRoot(task, newestTxnRoot));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Thread currentThread = Thread.currentThread();
        if (this.txnDispatcher.getThreadPermits(currentThread) != 0 || this.roTxnDispatcher.getThreadPermits(currentThread) != 0) {
            throw new ExodusException("Environment.clear() can't proceed if there is a transaction in current thread");
        }
        this.runAllTransactionSafeTasks();
        LinkedList<RunnableWithTxnRoot> linkedList = this.txnSafeTasks;
        synchronized (linkedList) {
            this.txnSafeTasks.clear();
        }
        this.suspendGC();
        try {
            int permits = this.txnDispatcher.acquireExclusiveTransaction(currentThread);
            try {
                int roPermits = this.roTxnDispatcher.acquireExclusiveTransaction(currentThread);
                try {
                    Object object = this.commitLock;
                    synchronized (object) {
                        Object object2 = this.metaLock;
                        synchronized (object2) {
                            this.gc.clear();
                            this.log.clear();
                            this.invalidateStoreGetCache();
                            this.invalidateTreeNodesCache();
                            this.throwableOnCommit = null;
                            Pair<MetaTree, Integer> meta = MetaTree.create(this);
                            this.metaTree = (MetaTree)meta.getFirst();
                            this.structureId.set((Integer)meta.getSecond());
                        }
                    }
                }
                finally {
                    this.roTxnDispatcher.releaseTransaction(currentThread, roPermits);
                }
            }
            finally {
                this.txnDispatcher.releaseTransaction(currentThread, permits);
            }
        }
        finally {
            this.resumeGC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        float treeNodesCacheHitRate;
        float storeGetCacheHitRate;
        float logCacheHitRate;
        if (this.configMBean != null) {
            this.configMBean.unregister();
        }
        if (this.statisticsMBean != null) {
            this.statisticsMBean.unregister();
        }
        this.runAllTransactionSafeTasks();
        this.gc.finish();
        Object object = this.commitLock;
        synchronized (object) {
            LongObjectCacheBase treeNodesCache;
            if (!this.isOpen()) {
                throw this.throwableOnClose;
            }
            this.checkInactive(this.ec.getEnvCloseForcedly());
            try {
                if (!this.ec.getEnvIsReadonly() && this.ec.isGcEnabled()) {
                    this.executeInTransaction(new TransactionalExecutable(){

                        public void execute(@NotNull Transaction txn) {
                            UtilizationProfile up = EnvironmentImpl.this.gc.getUtilizationProfile();
                            up.setDirty(true);
                            up.save(txn);
                        }
                    });
                }
                this.ec.removeChangedSettingsListener((ConfigSettingChangeListener)this.envSettingsListener);
                logCacheHitRate = this.log.getCacheHitRate();
                this.log.close();
            }
            finally {
                this.log.release();
            }
            if (this.storeGetCache == null) {
                storeGetCacheHitRate = 0.0f;
            } else {
                storeGetCacheHitRate = this.storeGetCache.hitRate();
                this.storeGetCache.close();
            }
            LongObjectCacheBase longObjectCacheBase = treeNodesCache = this.treeNodesCache == null ? null : this.treeNodesCache.get();
            if (treeNodesCache == null) {
                treeNodesCacheHitRate = 0.0f;
            } else {
                treeNodesCacheHitRate = treeNodesCache.hitRate();
                treeNodesCache.close();
            }
            this.throwableOnClose = new EnvironmentClosedException();
            this.throwableOnCommit = this.throwableOnClose;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Store get cache hit rate: " + ObjectCacheBase.formatHitRate((float)storeGetCacheHitRate));
            logger.info("Tree nodes cache hit rate: " + ObjectCacheBase.formatHitRate((float)treeNodesCacheHitRate));
            logger.info("Exodus log cache hit rate: " + ObjectCacheBase.formatHitRate((float)logCacheHitRate));
        }
    }

    public boolean isOpen() {
        return this.throwableOnClose == null;
    }

    public BackupStrategy getBackupStrategy() {
        return new EnvironmentBackupStrategyImpl(this);
    }

    public void truncateStore(@NotNull String storeName, @NotNull Transaction txn) {
        TransactionImpl t = EnvironmentImpl.throwIfReadonly(txn, "Can't truncate a store in read-only transaction");
        StoreImpl store = this.openStore(storeName, StoreConfig.USE_EXISTING, t, false);
        if (store == null) {
            throw new ExodusException("Attempt to truncate unknown store '" + storeName + '\'');
        }
        t.storeRemoved(store);
        TreeMetaInfo metaInfoCloned = store.getMetaInfo().clone(this.allocateStructureId());
        store = new StoreImpl(this, storeName, metaInfoCloned);
        t.storeCreated(store);
    }

    public void removeStore(@NotNull String storeName, @NotNull Transaction txn) {
        TransactionImpl t = EnvironmentImpl.throwIfReadonly(txn, "Can't remove a store in read-only transaction");
        StoreImpl store = this.openStore(storeName, StoreConfig.USE_EXISTING, t, false);
        if (store == null) {
            throw new ExodusException("Attempt to remove unknown store '" + storeName + '\'');
        }
        t.storeRemoved(store);
    }

    @NotNull
    public List<String> getAllStoreNames(@NotNull Transaction txn) {
        return ((TransactionBase)txn).getAllStoreNames();
    }

    public boolean storeExists(@NotNull String storeName, @NotNull Transaction txn) {
        return ((TransactionBase)txn).getTreeMetaInfo(storeName) != null;
    }

    @NotNull
    public Log getLog() {
        return this.log;
    }

    public void gc() {
        this.gc.wake();
    }

    public void suspendGC() {
        this.gc.suspend();
    }

    public void resumeGC() {
        this.gc.resume();
    }

    public BTreeBalancePolicy getBTreeBalancePolicy() {
        if (this.balancePolicy == null) {
            this.balancePolicy = new BTreeBalancePolicy(this.ec.getTreeMaxPageSize());
        }
        return this.balancePolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAndSync() {
        Object object = this.commitLock;
        synchronized (object) {
            if (this.isOpen()) {
                this.getLog().flush(true);
            }
        }
    }

    protected StoreImpl createStore(@NotNull String name, @NotNull TreeMetaInfo metaInfo) {
        return new StoreImpl(this, name, metaInfo);
    }

    protected void finishTransaction(@NotNull TransactionBase txn) {
        this.releaseTransaction(txn);
        this.txns.remove(txn);
        txn.setIsFinished();
        this.runTransactionSafeTasks();
    }

    @NotNull
    protected TransactionBase beginTransaction(Runnable beginHook, boolean exclusive, boolean cloneMeta) {
        this.checkIsOperative();
        return this.ec.getEnvIsReadonly() ? new ReadonlyTransaction(this, beginHook) : new TransactionImpl(this, beginHook, exclusive, cloneMeta);
    }

    long getDiskUsage() {
        return IOUtil.getDirectorySize((File)new File(this.getLocation()), (String)".xd", (boolean)false);
    }

    void acquireTransaction(@NotNull TransactionBase txn) {
        (txn.isReadonly() ? this.roTxnDispatcher : this.txnDispatcher).acquireTransaction(txn, this);
    }

    void releaseTransaction(@NotNull TransactionBase txn) {
        (txn.isReadonly() ? this.roTxnDispatcher : this.txnDispatcher).releaseTransaction(txn);
    }

    void downgradeTransaction(@NotNull TransactionBase txn) {
        (txn.isReadonly() ? this.roTxnDispatcher : this.txnDispatcher).downgradeTransaction(txn);
    }

    boolean shouldTransactionBeExclusive(@NotNull TransactionImpl txn) {
        int replayCount = txn.getReplayCount();
        return replayCount >= this.ec.getEnvTxnReplayMaxCount() || System.currentTimeMillis() - txn.getCreated() >= this.ec.getEnvTxnReplayTimeout();
    }

    int transactionTimeout() {
        return this.ec.getEnvMonitorTxnsTimeout();
    }

    @Nullable
    BTree loadMetaTree(long rootAddress) {
        if (rootAddress < 0L || rootAddress >= this.log.getHighAddress()) {
            return null;
        }
        return new BTree(this.log, this.getBTreeBalancePolicy(), rootAddress, false, 1);
    }

    boolean commitTransaction(@NotNull TransactionImpl txn, boolean forceCommit) {
        if (this.flushTransaction(txn, forceCommit)) {
            this.finishTransaction(txn);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean flushTransaction(@NotNull TransactionImpl txn, boolean forceCommit) {
        long resultingHighAddress;
        Iterable[] expiredLoggables;
        long initialHighAddress;
        if (!forceCommit && txn.isIdempotent()) {
            return true;
        }
        boolean isGcTransaction = txn.isGCTransaction();
        boolean wasUpSaved = false;
        UtilizationProfile up = this.gc.getUtilizationProfile();
        if (!isGcTransaction && up.isDirty()) {
            up.save(txn);
            wasUpSaved = true;
        }
        Object object = this.commitLock;
        synchronized (object) {
            if (this.ec.getEnvIsReadonly()) {
                throw new ReadonlyTransactionException();
            }
            this.checkIsOperative();
            if (!txn.checkVersion(this.metaTree.root)) {
                return false;
            }
            if (wasUpSaved) {
                up.setDirty(false);
            }
            LogConfig config = this.log.getConfig();
            config.setFsyncSuppressed(isGcTransaction);
            try {
                initialHighAddress = this.log.getHighAddress();
                try {
                    MetaTree[] tree = new MetaTree[1];
                    expiredLoggables = txn.doCommit(tree);
                    this.log.flush();
                    Object object2 = this.metaLock;
                    synchronized (object2) {
                        this.metaTree = tree[0];
                        txn.setMetaTree(this.metaTree);
                        txn.executeCommitHook();
                    }
                    resultingHighAddress = this.log.approveHighAddress();
                }
                catch (Throwable t) {
                    EnvironmentImpl.loggerError("Failed to flush transaction", t);
                    try {
                        this.log.setHighAddress(initialHighAddress);
                    }
                    catch (Throwable th) {
                        this.throwableOnCommit = t;
                        EnvironmentImpl.loggerError("Failed to rollback high address", th);
                        throw ExodusException.toExodusException((Throwable)th, (String)"Failed to rollback high address");
                    }
                    throw ExodusException.toExodusException((Throwable)t, (String)"Failed to flush transaction");
                }
            }
            finally {
                config.setFsyncSuppressed(false);
            }
        }
        this.gc.fetchExpiredLoggables(new ExpiredLoggableIterable(expiredLoggables));
        this.statistics.getStatisticsItem("Bytes written").setTotal(resultingHighAddress);
        if (isGcTransaction) {
            this.statistics.getStatisticsItem("Bytes moved by GC").addTotal(resultingHighAddress - initialHighAddress);
        }
        this.statistics.getStatisticsItem("Flushed transactions").incTotal();
        return true;
    }

    MetaTree holdNewestSnapshotBy(@NotNull TransactionBase txn) {
        return this.holdNewestSnapshotBy(txn, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MetaTree holdNewestSnapshotBy(@NotNull TransactionBase txn, boolean acquireTxn) {
        if (acquireTxn) {
            this.acquireTransaction(txn);
        }
        Runnable beginHook = txn.getBeginHook();
        Object object = this.metaLock;
        synchronized (object) {
            if (beginHook != null) {
                beginHook.run();
            }
            return this.metaTree;
        }
    }

    MetaTree getMetaTree() {
        return this.metaTree;
    }

    @NotNull
    StoreImpl openStoreImpl(@NotNull String name, @NotNull StoreConfig config, @NotNull TransactionBase txn, @Nullable TreeMetaInfo metaInfo) {
        StoreImpl result;
        if (config.useExisting) {
            if (metaInfo == null) {
                throw new ExodusException("Can't restore meta information for store " + name);
            }
            config = TreeMetaInfo.toConfig(metaInfo);
        }
        if (metaInfo == null) {
            if (this.ec.getEnvIsReadonly() && this.ec.getEnvReadonlyEmptyStores()) {
                return this.createTemporaryEmptyStore(name);
            }
            int structureId = this.allocateStructureId();
            metaInfo = TreeMetaInfo.load(this, config.duplicates, config.prefixing, structureId);
            result = this.createStore(name, metaInfo);
            TransactionImpl tx = EnvironmentImpl.throwIfReadonly(txn, "Can't create a store in read-only transaction");
            tx.getMutableTree(result);
            tx.storeCreated(result);
        } else {
            boolean hasDuplicates = metaInfo.hasDuplicates();
            if (hasDuplicates != config.duplicates) {
                throw new ExodusException("Attempt to open store '" + name + "' with duplicates = " + config.duplicates + " while it was created with duplicates =" + hasDuplicates);
            }
            if (metaInfo.isKeyPrefixing() != config.prefixing) {
                if (!config.prefixing) {
                    throw new ExodusException("Attempt to open store '" + name + "' with prefixing = false while it was created with prefixing = true");
                }
                metaInfo = TreeMetaInfo.load(this, hasDuplicates, false, metaInfo.getStructureId());
            }
            result = this.createStore(name, metaInfo);
        }
        return result;
    }

    int getLastStructureId() {
        return this.structureId.get();
    }

    void registerTransaction(@NotNull TransactionBase txn) {
        this.txns.add(txn);
    }

    boolean isRegistered(@NotNull TransactionImpl txn) {
        return this.txns.contains(txn);
    }

    int activeTransactions() {
        return this.txns.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runTransactionSafeTasks() {
        if (this.throwableOnCommit == null) {
            ArrayList<Runnable> tasksToRun = null;
            long oldestTxnRoot = this.getOldestTxnRootAddress();
            LinkedList<RunnableWithTxnRoot> linkedList = this.txnSafeTasks;
            synchronized (linkedList) {
                RunnableWithTxnRoot r;
                while (!this.txnSafeTasks.isEmpty() && (r = this.txnSafeTasks.getFirst()).txnRoot < oldestTxnRoot) {
                    this.txnSafeTasks.removeFirst();
                    if (tasksToRun == null) {
                        tasksToRun = new ArrayList<Runnable>(4);
                    }
                    tasksToRun.add(r.runnable);
                }
            }
            if (tasksToRun != null) {
                for (Runnable task : tasksToRun) {
                    task.run();
                }
            }
        }
    }

    @Nullable
    TransactionBase getOldestTransaction() {
        return this.txns.getOldestTransaction();
    }

    @Nullable
    TransactionBase getNewestTransaction() {
        return this.txns.getNewestTransaction();
    }

    @Nullable
    StoreGetCache getStoreGetCache() {
        return this.storeGetCache;
    }

    @Nullable
    LongObjectCacheBase getTreeNodesCache() {
        SoftReference<LongObjectCacheBase> cacheRef = this.treeNodesCache;
        if (cacheRef != null) {
            LongObjectCacheBase cache = cacheRef.get();
            return cache != null ? cache : this.invalidateTreeNodesCache();
        }
        return null;
    }

    void forEachActiveTransaction(@NotNull TransactionalExecutable executable) {
        for (Transaction txn : this.txns) {
            executable.execute(txn);
        }
    }

    protected StoreImpl createTemporaryEmptyStore(String name) {
        return new TemporaryEmptyStore(this, name);
    }

    static boolean isUtilizationProfile(@NotNull String storeName) {
        return GarbageCollector.isUtilizationProfile(storeName);
    }

    static TransactionImpl throwIfReadonly(@NotNull Transaction txn, @NotNull String exceptionMessage) {
        if (txn.isReadonly()) {
            throw new ReadonlyTransactionException(exceptionMessage);
        }
        return (TransactionImpl)txn;
    }

    static void loggerError(@NotNull String errorMessage) {
        EnvironmentImpl.loggerError(errorMessage, null);
    }

    static void loggerError(@NotNull String errorMessage, @Nullable Throwable t) {
        if (t == null) {
            logger.error(errorMessage);
        } else {
            logger.error(errorMessage, t);
        }
    }

    private long getOldestTxnRootAddress() {
        TransactionBase oldestTxn = this.getOldestTransaction();
        return oldestTxn == null ? Long.MAX_VALUE : oldestTxn.getRoot();
    }

    private long getNewestTxnRootAddress() {
        TransactionBase newestTxn = this.getNewestTransaction();
        return newestTxn == null ? Long.MIN_VALUE : newestTxn.getRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAllTransactionSafeTasks() {
        if (this.throwableOnCommit == null) {
            LinkedList<RunnableWithTxnRoot> linkedList = this.txnSafeTasks;
            synchronized (linkedList) {
                for (RunnableWithTxnRoot r : this.txnSafeTasks) {
                    r.runnable.run();
                }
            }
            DeferredIO.getJobProcessor().waitForJobs(100L);
        }
    }

    private void checkInactive(boolean exceptionSafe) {
        int txnCount = this.txns.size();
        if (txnCount > 0) {
            String errorString = "Environment[" + this.getLocation() + "] is active: " + txnCount + " transaction(s) not finished";
            if (!exceptionSafe) {
                EnvironmentImpl.loggerError(errorString);
            } else if (logger.isInfoEnabled()) {
                logger.info(errorString);
            }
            if (!exceptionSafe) {
                this.reportAliveTransactions(false);
            } else if (logger.isDebugEnabled()) {
                this.reportAliveTransactions(true);
            }
        }
        if (!exceptionSafe && txnCount > 0) {
            throw new ExodusException("Finish all transactions before closing database environment");
        }
    }

    private void reportAliveTransactions(final boolean debug) {
        if (this.transactionTimeout() == 0) {
            String stacksUnavailable = "Transactions stack traces are not available, set 'exodus.env.monitorTxns.timeout > 0'";
            if (debug) {
                logger.debug(stacksUnavailable);
            } else {
                EnvironmentImpl.loggerError(stacksUnavailable);
            }
        } else {
            this.forEachActiveTransaction(new TransactionalExecutable(){

                public void execute(@NotNull Transaction txn) {
                    Throwable trace = ((TransactionBase)txn).getTrace();
                    if (debug) {
                        logger.debug("Alive transaction: ", trace);
                    } else {
                        EnvironmentImpl.loggerError("Alive transaction: ", trace);
                    }
                }
            });
        }
    }

    private void checkIsOperative() {
        Throwable t = this.throwableOnCommit;
        if (t != null) {
            throw ExodusException.toExodusException((Throwable)t, (String)"Environment is inoperative");
        }
    }

    private int allocateStructureId() {
        int result;
        while (((result = this.structureId.incrementAndGet()) & 0xFF) == 0) {
        }
        return result;
    }

    private void invalidateStoreGetCache() {
        int storeGetCacheSize = this.ec.getEnvStoreGetCacheSize();
        this.storeGetCache = storeGetCacheSize == 0 ? null : new StoreGetCache(storeGetCacheSize);
    }

    private LongObjectCacheBase invalidateTreeNodesCache() {
        int treeNodesCacheSize = this.ec.getTreeNodesCacheSize();
        ConcurrentLongObjectCache result = treeNodesCacheSize == 0 ? null : new ConcurrentLongObjectCache(treeNodesCacheSize, 2);
        this.treeNodesCache = result == null ? null : new SoftReference<ConcurrentLongObjectCache>(result);
        return result;
    }

    private static void applyEnvironmentSettings(@NotNull String location, @NotNull jetbrains.exodus.env.EnvironmentConfig ec) {
        File propsFile = new File(location, ENVIRONMENT_PROPERTIES_FILE);
        if (propsFile.exists() && propsFile.isFile()) {
            try (FileInputStream propsStream = new FileInputStream(propsFile);){
                Properties envProps = new Properties();
                envProps.load(propsStream);
                for (Map.Entry<Object, Object> entry : envProps.entrySet()) {
                    ec.setSetting(entry.getKey().toString(), entry.getValue());
                }
            }
            catch (IOException e) {
                throw ExodusException.toExodusException((Throwable)e);
            }
        }
    }

    private static void executeInTransaction(@NotNull TransactionalExecutable executable, @NotNull Transaction txn) {
        try {
            while (true) {
                executable.execute(txn);
                if (txn.isReadonly() || txn.isFinished()) break;
                if (txn.flush()) {
                    break;
                }
                txn.revert();
            }
        }
        finally {
            EnvironmentImpl.abortIfNotFinished(txn);
        }
    }

    private static <T> T computeInTransaction(@NotNull TransactionalComputable<T> computable, @NotNull Transaction txn) {
        try {
            while (true) {
                Object result = computable.compute(txn);
                if (txn.isReadonly() || txn.isFinished() || txn.flush()) {
                    Object object = result;
                    return (T)object;
                }
                txn.revert();
            }
        }
        finally {
            EnvironmentImpl.abortIfNotFinished(txn);
        }
    }

    private static void abortIfNotFinished(@NotNull Transaction txn) {
        if (!txn.isFinished()) {
            txn.abort();
        }
    }

    private static class RunnableWithTxnRoot {
        private final Runnable runnable;
        private final long txnRoot;

        private RunnableWithTxnRoot(Runnable runnable, long txnRoot) {
            this.runnable = runnable;
            this.txnRoot = txnRoot;
        }
    }

    private static class ExpiredLoggableIterable
    implements Iterable<ExpiredLoggableInfo> {
        private final Iterable<ExpiredLoggableInfo>[] expiredLoggables;

        private ExpiredLoggableIterable(Iterable<ExpiredLoggableInfo>[] expiredLoggables) {
            this.expiredLoggables = expiredLoggables;
        }

        @Override
        public Iterator<ExpiredLoggableInfo> iterator() {
            return new Iterator<ExpiredLoggableInfo>(){
                private Iterator<ExpiredLoggableInfo> current;
                private int index;
                {
                    this.current = ExpiredLoggableIterable.this.expiredLoggables[0].iterator();
                    this.index = 0;
                }

                @Override
                public boolean hasNext() {
                    while (!this.current.hasNext()) {
                        if (++this.index == ExpiredLoggableIterable.this.expiredLoggables.length) {
                            return false;
                        }
                        this.current = ExpiredLoggableIterable.this.expiredLoggables[this.index].iterator();
                    }
                    return true;
                }

                @Override
                public ExpiredLoggableInfo next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException("No more loggables available");
                    }
                    return this.current.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private class EnvironmentSettingsListener
    implements ConfigSettingChangeListener {
        private EnvironmentSettingsListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeSettingChanged(@NotNull String key, @NotNull Object value, @NotNull Map<String, Object> context) {
            if (key.equals("exodus.env.isReadonly") && Boolean.TRUE.equals(value)) {
                EnvironmentImpl.this.suspendGC();
                TransactionBase txn = EnvironmentImpl.this.beginTransaction();
                try {
                    if (!txn.isReadonly()) {
                        txn.setCommitHook(new Runnable(){

                            @Override
                            public void run() {
                                jetbrains.exodus.env.EnvironmentConfig.suppressConfigChangeListenersForThread();
                                EnvironmentImpl.this.ec.setEnvIsReadonly(true);
                                jetbrains.exodus.env.EnvironmentConfig.resumeConfigChangeListenersForThread();
                            }
                        });
                        ((TransactionImpl)txn).forceFlush();
                    }
                }
                finally {
                    txn.abort();
                }
            }
        }

        public void afterSettingChanged(@NotNull String key, @NotNull Object value, @NotNull Map<String, Object> context) {
            if (key.equals("exodus.env.storeGetCacheSize")) {
                EnvironmentImpl.this.invalidateStoreGetCache();
            } else if (key.equals("exodus.tree.nodesCacheSize")) {
                EnvironmentImpl.this.invalidateTreeNodesCache();
            } else if (key.equals("exodus.log.syncPeriod")) {
                EnvironmentImpl.this.log.getConfig().setSyncPeriod(EnvironmentImpl.this.ec.getLogSyncPeriod());
            } else if (key.equals("exodus.log.durableWrite")) {
                EnvironmentImpl.this.log.getConfig().setDurableWrite(EnvironmentImpl.this.ec.getLogDurableWrite());
            } else if (key.equals("exodus.env.isReadonly") && !EnvironmentImpl.this.ec.getEnvIsReadonly()) {
                EnvironmentImpl.this.resumeGC();
            }
        }
    }
}

