/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.log.ReadBytesListener;
import jetbrains.exodus.management.Statistics;
import jetbrains.exodus.management.StatisticsItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnvironmentStatistics
extends Statistics {
    public static final String BYTES_WRITTEN = "Bytes written";
    public static final String BYTES_READ = "Bytes read";
    public static final String BYTES_MOVED_BY_GC = "Bytes moved by GC";
    public static final String TRANSACTIONS = "Transactions";
    public static final String READONLY_TRANSACTIONS = "Read-only transactions";
    public static final String ACTIVE_TRANSACTIONS = "Active transactions";
    public static final String FLUSHED_TRANSACTIONS = "Flushed transactions";
    public static final String DISK_USAGE = "Disk usage";
    public static final String UTILIZATION_PERCENT = "Utilization percent";
    private static final int DISK_USAGE_FREQ = 10000;
    @NotNull
    private final EnvironmentImpl env;

    EnvironmentStatistics(@NotNull EnvironmentImpl env) {
        this.env = env;
        this.getStatisticsItem(BYTES_WRITTEN).setTotal(env.getLog().getHighAddress());
        this.getStatisticsItem(BYTES_READ);
        this.getStatisticsItem(BYTES_MOVED_BY_GC);
        this.getStatisticsItem(TRANSACTIONS);
        this.getStatisticsItem(READONLY_TRANSACTIONS);
        this.getStatisticsItem(ACTIVE_TRANSACTIONS);
        this.getStatisticsItem(FLUSHED_TRANSACTIONS);
        this.getStatisticsItem(DISK_USAGE);
        this.getStatisticsItem(UTILIZATION_PERCENT);
        env.getLog().addReadBytesListener(new ReadBytesListener(){

            @Override
            public void bytesRead(byte[] bytes, int count) {
                EnvironmentStatistics.this.getStatisticsItem(EnvironmentStatistics.BYTES_READ).addTotal((long)count);
            }
        });
    }

    @NotNull
    public StatisticsItem getStatisticsItem(@NotNull String statisticsName) {
        if (!this.env.getEnvironmentConfig().getEnvGatherStatistics()) {
            return new StatisticsItem((Statistics)this);
        }
        return super.getStatisticsItem(statisticsName);
    }

    @NotNull
    protected StatisticsItem createNewItem(@NotNull String statisticsName) {
        if (ACTIVE_TRANSACTIONS.equals(statisticsName)) {
            return new ActiveTransactionsStatisticsItem(this);
        }
        if (DISK_USAGE.equals(statisticsName)) {
            return new DiskUsageStatisticsItem(this);
        }
        if (UTILIZATION_PERCENT.equals(statisticsName)) {
            return new UtilizationPercentStatisticsItem(this);
        }
        return super.createNewItem(statisticsName);
    }

    private static class UtilizationPercentStatisticsItem
    extends StatisticsItem {
        UtilizationPercentStatisticsItem(@NotNull EnvironmentStatistics statistics) {
            super((Statistics)statistics);
        }

        @Nullable
        protected Long getAutoUpdatedTotal() {
            EnvironmentStatistics statistics = (EnvironmentStatistics)this.getStatistics();
            return statistics == null ? null : Long.valueOf(statistics.env.getGC().getUtilizationProfile().totalUtilizationPercent());
        }
    }

    private static class DiskUsageStatisticsItem
    extends StatisticsItem {
        private long lastAutoUpdateTime = 0L;

        DiskUsageStatisticsItem(@NotNull EnvironmentStatistics statistics) {
            super((Statistics)statistics);
        }

        @Nullable
        protected Long getAutoUpdatedTotal() {
            long currentTime;
            EnvironmentStatistics statistics = (EnvironmentStatistics)this.getStatistics();
            if (statistics != null && (currentTime = System.currentTimeMillis()) - this.lastAutoUpdateTime > 10000L) {
                this.lastAutoUpdateTime = currentTime;
                return statistics.env.getDiskUsage();
            }
            return null;
        }
    }

    private static class ActiveTransactionsStatisticsItem
    extends StatisticsItem {
        ActiveTransactionsStatisticsItem(@NotNull EnvironmentStatistics statistics) {
            super((Statistics)statistics);
        }

        @Nullable
        protected Long getAutoUpdatedTotal() {
            EnvironmentStatistics statistics = (EnvironmentStatistics)this.getStatistics();
            return statistics == null ? null : Long.valueOf(statistics.env.activeTransactions());
        }
    }
}

