/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.bindings.StringBinding;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.env.DatabaseRoot;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.ExpiredLoggableInfo;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogUtil;
import jetbrains.exodus.log.RandomAccessLoggable;
import jetbrains.exodus.tree.ITree;
import jetbrains.exodus.tree.ITreeCursor;
import jetbrains.exodus.tree.ITreeMutable;
import jetbrains.exodus.tree.LongIterator;
import jetbrains.exodus.tree.TreeMetaInfo;
import jetbrains.exodus.tree.btree.BTree;
import jetbrains.exodus.tree.btree.BTreeEmpty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MetaTree {
    final ITree tree;
    final long root;
    final long highAddress;

    private MetaTree(ITree tree, long root, long highAddress) {
        this.tree = tree;
        this.root = root;
        this.highAddress = highAddress;
    }

    static Pair<MetaTree, Integer> create(@NotNull EnvironmentImpl env) {
        Log log = env.getLog();
        DatabaseRoot dbRoot = (DatabaseRoot)log.getLastLoggableOfType(1);
        if (dbRoot != null) {
            long root;
            do {
                root = dbRoot.getAddress();
                if (!dbRoot.isValid()) continue;
                try {
                    BTree metaTree;
                    long validHighAddress = root + (long)dbRoot.length();
                    if (log.getHighAddress() != validHighAddress) {
                        log.setHighAddress(validHighAddress);
                    }
                    if ((metaTree = env.loadMetaTree(dbRoot.getRootAddress())) != null) {
                        MetaTree.cloneTree(metaTree);
                        return new Pair((Object)new MetaTree(metaTree, root, validHighAddress), (Object)dbRoot.getLastStructureId());
                    }
                }
                catch (ExodusException e) {
                    EnvironmentImpl.loggerError("Failed to recover to valid root" + LogUtil.getWrongAddressErrorMessage(dbRoot.getAddress(), env.getEnvironmentConfig().getLogFileSize()), e);
                }
            } while ((dbRoot = (DatabaseRoot)log.getLastLoggableOfTypeBefore(1, root)) != null);
            throw new ExodusException("Database is not empty, but no valid root found");
        }
        log.setHighAddress(0L);
        ITree resultTree = MetaTree.getEmptyMetaTree(env);
        long rootAddress = resultTree.getMutableCopy().save();
        long root = log.write((byte)1, 0, DatabaseRoot.asByteIterable(rootAddress, 1));
        log.flush();
        return new Pair((Object)new MetaTree(resultTree, root, log.getHighAddress()), (Object)1);
    }

    LongIterator addressIterator() {
        return this.tree.addressIterator();
    }

    @Nullable
    TreeMetaInfo getMetaInfo(@NotNull String storeName, @NotNull EnvironmentImpl env) {
        ByteIterable value = this.tree.get((ByteIterable)StringBinding.stringToEntry((String)storeName));
        if (value == null) {
            return null;
        }
        return TreeMetaInfo.load(env, value);
    }

    long getRootAddress(int structureId) {
        ITree rememberedTree = this.tree;
        ByteIterable value = rememberedTree.get((ByteIterable)LongBinding.longToCompressedEntry((long)structureId));
        return value == null ? -1L : CompressedUnsignedLongByteIterable.getLong(value);
    }

    static void removeStore(@NotNull ITreeMutable out, @NotNull String storeName, long id) {
        out.delete((ByteIterable)StringBinding.stringToEntry((String)storeName));
        out.delete((ByteIterable)LongBinding.longToCompressedEntry((long)id));
    }

    static void addStore(@NotNull ITreeMutable out, @NotNull String storeName, @NotNull TreeMetaInfo metaInfo) {
        out.put((ByteIterable)StringBinding.stringToEntry((String)storeName), metaInfo.toByteIterable());
    }

    static void saveTree(@NotNull ITreeMutable out, @NotNull ITreeMutable treeMutable) {
        long treeRootAddress = treeMutable.save();
        int structureId = treeMutable.getStructureId();
        out.put((ByteIterable)LongBinding.longToCompressedEntry((long)structureId), CompressedUnsignedLongByteIterable.getIterable(treeRootAddress));
    }

    @Nullable
    static MetaTree saveMetaTree(@NotNull ITreeMutable metaTree, @NotNull EnvironmentImpl env, @NotNull Collection<ExpiredLoggableInfo> expired) {
        long newMetaTreeAddress = metaTree.save();
        Log log = env.getLog();
        int lastStructureId = env.getLastStructureId();
        long dbRootAddress = log.write((byte)1, 0, DatabaseRoot.asByteIterable(newMetaTreeAddress, lastStructureId));
        BTree resultTree = env.loadMetaTree(newMetaTreeAddress);
        RandomAccessLoggable dbRootLoggable = log.read(dbRootAddress);
        expired.add(new ExpiredLoggableInfo(dbRootLoggable));
        return new MetaTree(resultTree, dbRootAddress, dbRootAddress + (long)dbRootLoggable.length());
    }

    @NotNull
    List<String> getAllStoreNames() {
        ITree tree = this.tree;
        if (tree.getSize() == 0L) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        ITreeCursor cursor = tree.openCursor();
        while (cursor.getNext()) {
            String storeName;
            ArrayByteIterable key = new ArrayByteIterable(cursor.getKey());
            if (!MetaTree.isStringKey(key) || EnvironmentImpl.isUtilizationProfile(storeName = StringBinding.entryToString((ByteIterable)key))) continue;
            result.add(storeName);
        }
        return result;
    }

    @Nullable
    String getStoreNameByStructureId(int structureId, @NotNull EnvironmentImpl env) {
        try (ITreeCursor cursor = this.tree.openCursor();){
            while (cursor.getNext()) {
                ByteIterable key = cursor.getKey();
                if (!MetaTree.isStringKey(new ArrayByteIterable(key)) || TreeMetaInfo.load(env, cursor.getValue()).getStructureId() != structureId) continue;
                String string = StringBinding.entryToString((ByteIterable)key);
                return string;
            }
        }
        return null;
    }

    MetaTree getClone() {
        return new MetaTree(MetaTree.cloneTree(this.tree), this.root, this.highAddress);
    }

    static boolean isStringKey(ArrayByteIterable key) {
        return key.getBytesUnsafe()[key.getLength() - 1] == 0;
    }

    private static ITreeMutable cloneTree(@NotNull ITree tree) {
        try (ITreeCursor cursor = tree.openCursor();){
            ITreeMutable result = tree.getMutableCopy();
            while (cursor.getNext()) {
                result.put(cursor.getKey(), cursor.getValue());
            }
            ITreeMutable iTreeMutable = result;
            return iTreeMutable;
        }
    }

    private static ITree getEmptyMetaTree(@NotNull EnvironmentImpl env) {
        return new BTreeEmpty(env.getLog(), env.getBTreeBalancePolicy(), false, 1);
    }
}

