/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.ReadonlyTransactionException;
import jetbrains.exodus.env.StoreImpl;
import jetbrains.exodus.env.TransactionBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ReadonlyTransaction
extends TransactionBase {
    @Nullable
    private final Runnable beginHook;

    ReadonlyTransaction(@NotNull EnvironmentImpl env, @Nullable Runnable beginHook) {
        super(env, false);
        this.beginHook = this.getWrappedBeginHook(beginHook);
        env.holdNewestSnapshotBy(this);
        env.getStatistics().getStatisticsItem("Read-only transactions").incTotal();
    }

    ReadonlyTransaction(@NotNull TransactionBase origin) {
        super(origin.getEnvironment(), false);
        this.beginHook = null;
        this.setMetaTree(origin.getMetaTree());
        EnvironmentImpl env = this.getEnvironment();
        env.acquireTransaction(this);
        env.registerTransaction(this);
        env.getStatistics().getStatisticsItem("Read-only transactions").incTotal();
    }

    public void setCommitHook(@Nullable Runnable hook) {
        throw new ReadonlyTransactionException();
    }

    @Override
    void storeRemoved(@NotNull StoreImpl store) {
        throw new ReadonlyTransactionException();
    }

    public boolean isIdempotent() {
        return true;
    }

    public void abort() {
        this.checkIsFinished();
        this.getEnvironment().finishTransaction(this);
    }

    public boolean commit() {
        throw new ReadonlyTransactionException();
    }

    public boolean flush() {
        throw new ReadonlyTransactionException();
    }

    public void revert() {
        throw new ReadonlyTransactionException();
    }

    public boolean isReadonly() {
        return true;
    }

    @Override
    @Nullable
    Runnable getBeginHook() {
        return this.beginHook;
    }
}

