/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.core.dataStructures.SoftConcurrentObjectCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StoreGetCache {
    private final SoftConcurrentObjectCache<KeyEntry, ArrayByteIterable> cache;

    StoreGetCache(int cacheSize) {
        this.cache = new SoftConcurrentObjectCache(cacheSize);
    }

    void close() {
        this.cache.close();
    }

    @Nullable
    ByteIterable tryKey(long treeRootAddress, @NotNull ByteIterable key) {
        return (ByteIterable)this.cache.tryKey((Object)new KeyEntry(treeRootAddress, key));
    }

    void cacheObject(long treeRootAddress, @NotNull ByteIterable key, @NotNull ArrayByteIterable value) {
        this.cache.cacheObject((Object)new KeyEntry(treeRootAddress, key), (Object)value);
    }

    float hitRate() {
        return this.cache.hitRate();
    }

    private static class KeyEntry {
        private final long treeRootAddress;
        @NotNull
        private final ByteIterable key;
        private int hc;

        KeyEntry(long treeRootAddress, @NotNull ByteIterable key) {
            this.treeRootAddress = treeRootAddress;
            this.key = key;
            this.hc = 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyEntry right = (KeyEntry)o;
            return this.treeRootAddress == right.treeRootAddress && this.key.equals(right.key);
        }

        public int hashCode() {
            if (this.hc == 0) {
                int keyHashCode = this.key.hashCode();
                int result = (int)(this.treeRootAddress + (long)keyHashCode ^ this.treeRootAddress >>> 32);
                this.hc = 31 * result + keyHashCode;
            }
            return this.hc;
        }
    }
}

