/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import java.util.Date;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessor;
import jetbrains.exodus.core.execution.ThreadJobProcessorPool;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.env.TransactionBase;
import jetbrains.exodus.env.TransactionalExecutable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StuckTransactionMonitor
extends Job {
    private static final Logger logger = LoggerFactory.getLogger(StuckTransactionMonitor.class);
    @NotNull
    private final EnvironmentImpl env;
    @NotNull
    private final JobProcessor processor;

    StuckTransactionMonitor(@NotNull EnvironmentImpl env) {
        this.env = env;
        this.processor = ThreadJobProcessorPool.getOrCreateJobProcessor((String)"Exodus shared stuck transaction monitor");
        this.queueThis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Throwable {
        if (this.env.isOpen()) {
            try {
                int transactionTimeout = this.env.transactionTimeout();
                if (transactionTimeout != 0) {
                    final long creationTimeBound = System.currentTimeMillis() - (long)transactionTimeout;
                    this.env.forEachActiveTransaction(new TransactionalExecutable(){

                        public void execute(@NotNull Transaction txn) {
                            TransactionBase transaction = (TransactionBase)txn;
                            long created = transaction.getStartTime();
                            if (created < creationTimeBound) {
                                Thread creatingThread = transaction.getCreatingThread();
                                logger.error("Transaction timed out: created at " + new Date(created).toString() + ", thread = " + creatingThread + '(' + (creatingThread == null ? "" : Long.valueOf(creatingThread.getId())) + ')', transaction.getTrace());
                            }
                        }
                    });
                }
            }
            finally {
                this.queueThis();
            }
        }
    }

    private void queueThis() {
        this.processor.queueIn((Job)this, (long)this.env.getEnvironmentConfig().getEnvMonitorTxnsCheckFreq());
    }
}

