/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import jetbrains.exodus.core.dataStructures.persistent.PersistentHashSet;
import jetbrains.exodus.env.TransactionBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TransactionSet
implements Iterable<TransactionBase> {
    private final AtomicReference<MinMaxAwareTransactionSet> txns = new AtomicReference<MinMaxAwareTransactionSet>(new MinMaxAwareTransactionSet());

    TransactionSet() {
    }

    @Override
    public Iterator<TransactionBase> iterator() {
        return this.getCurrent().iterator();
    }

    void add(@NotNull TransactionBase txn) {
        TransactionBase prevMax;
        TransactionBase newMax;
        TransactionBase newMin;
        PersistentHashSet newSet;
        MinMaxAwareTransactionSet prevSet;
        long root = txn.getRoot();
        do {
            prevSet = this.txns.get();
            newSet = prevSet.set.getClone();
            TransactionBase prevMin = prevSet.min;
            if (newSet.contains((Object)txn)) {
                newMin = prevMin == txn ? null : prevMin;
                continue;
            }
            PersistentHashSet.MutablePersistentHashSet mutableSet = newSet.beginWrite();
            mutableSet.add((Object)txn);
            mutableSet.endWrite();
            newMin = prevMin != null && prevMin.getRoot() > root ? txn : prevMin;
        } while (!this.txns.compareAndSet(prevSet, new MinMaxAwareTransactionSet(newSet, newMin, newMax = (prevMax = prevSet.max) != null && prevMax.getRoot() < root ? txn : prevMax)));
    }

    boolean contains(@NotNull TransactionBase txn) {
        return this.getCurrent().contains((Object)txn);
    }

    void remove(@NotNull TransactionBase txn) {
        MinMaxAwareTransactionSet prevSet;
        PersistentHashSet newSet;
        PersistentHashSet.MutablePersistentHashSet mutableSet;
        while ((mutableSet = (newSet = (prevSet = this.txns.get()).set.getClone()).beginWrite()).remove((Object)txn)) {
            TransactionBase prevMax;
            TransactionBase newMax;
            mutableSet.endWrite();
            TransactionBase prevMin = prevSet.min;
            TransactionBase newMin = prevMin == txn ? null : prevMin;
            if (!this.txns.compareAndSet(prevSet, new MinMaxAwareTransactionSet(newSet, newMin, newMax = (prevMax = prevSet.max) == txn ? null : prevMax))) continue;
            break;
        }
    }

    boolean isEmpty() {
        return this.getCurrent().isEmpty();
    }

    int size() {
        return this.getCurrent().size();
    }

    @Nullable
    TransactionBase getOldestTransaction() {
        return this.txns.get().getMin();
    }

    @Nullable
    TransactionBase getNewestTransaction() {
        return this.txns.get().getMax();
    }

    @NotNull
    private PersistentHashSet<TransactionBase> getCurrent() {
        return this.txns.get().set;
    }

    private static class MinMaxAwareTransactionSet {
        @NotNull
        private final PersistentHashSet<TransactionBase> set;
        @Nullable
        private TransactionBase min;
        @Nullable
        private TransactionBase max;

        private MinMaxAwareTransactionSet(@NotNull PersistentHashSet<TransactionBase> set, @Nullable TransactionBase min, @Nullable TransactionBase max) {
            this.set = set;
            this.min = min;
            this.max = max;
        }

        private MinMaxAwareTransactionSet() {
            this((PersistentHashSet<TransactionBase>)new PersistentHashSet(), null, null);
        }

        @Nullable
        private TransactionBase getMin() {
            if (this.min == null) {
                TransactionBase min = null;
                long minRoot = Long.MIN_VALUE;
                for (TransactionBase txn : this.set) {
                    long root = txn.getRoot();
                    if (min != null && root >= minRoot) continue;
                    min = txn;
                    minRoot = root;
                }
                this.min = min;
            }
            return this.min;
        }

        @Nullable
        private TransactionBase getMax() {
            if (this.max == null) {
                TransactionBase max = null;
                long maxRoot = Long.MAX_VALUE;
                for (TransactionBase txn : this.set) {
                    long root = txn.getRoot();
                    if (max != null && root <= maxRoot) continue;
                    max = txn;
                    maxRoot = root;
                }
                this.max = max;
            }
            return this.max;
        }
    }
}

