/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env.management;

import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.management.EnvironmentStatisticsMBean;
import jetbrains.exodus.management.MBeanBase;
import jetbrains.exodus.management.Statistics;
import org.jetbrains.annotations.NotNull;

public class EnvironmentStatistics
extends MBeanBase
implements EnvironmentStatisticsMBean {
    @NotNull
    private final Environment env;
    @NotNull
    private final Statistics statistics;

    public EnvironmentStatistics(@NotNull Environment env) {
        super(EnvironmentStatistics.getObjectName(env));
        this.env = env;
        this.statistics = env.getStatistics();
    }

    public static String getObjectName(@NotNull Environment env) {
        return "jetbrains.exodus.env: type=EnvironmentStatistics, location=" + EnvironmentStatistics.escapeLocation((String)env.getLocation());
    }

    @Override
    public long getBytesWritten() {
        return this.statistics.getStatisticsItem("Bytes written").getTotal();
    }

    @Override
    public double getBytesWrittenPerSecond() {
        return this.statistics.getStatisticsItem("Bytes written").getMean();
    }

    @Override
    public long getBytesRead() {
        return this.statistics.getStatisticsItem("Bytes read").getTotal();
    }

    @Override
    public double getBytesReadPerSecond() {
        return this.statistics.getStatisticsItem("Bytes read").getMean();
    }

    @Override
    public long getBytesMovedByGC() {
        return this.statistics.getStatisticsItem("Bytes moved by GC").getTotal();
    }

    @Override
    public double getBytesMovedByGCPerSecond() {
        return this.statistics.getStatisticsItem("Bytes moved by GC").getMean();
    }

    @Override
    public double getLogCacheHitRate() {
        return ((EnvironmentImpl)this.env).getLog().getCacheHitRate();
    }

    @Override
    public long getNumberOfTransactions() {
        return this.statistics.getStatisticsItem("Transactions").getTotal();
    }

    @Override
    public double getNumberOfTransactionsPerSecond() {
        return this.statistics.getStatisticsItem("Transactions").getMean();
    }

    @Override
    public long getNumberOfReadonlyTransactions() {
        return this.statistics.getStatisticsItem("Read-only transactions").getTotal();
    }

    @Override
    public double getNumberOfReadonlyTransactionsPerSecond() {
        return this.statistics.getStatisticsItem("Read-only transactions").getMean();
    }

    @Override
    public int getActiveTransactions() {
        return (int)this.statistics.getStatisticsItem("Active transactions").getTotal();
    }

    @Override
    public long getNumberOfFlushedTransactions() {
        return this.statistics.getStatisticsItem("Flushed transactions").getTotal();
    }

    @Override
    public double getNumberOfFlushedTransactionsPerSecond() {
        return this.statistics.getStatisticsItem("Flushed transactions").getMean();
    }

    @Override
    public long getDiskUsage() {
        return this.statistics.getStatisticsItem("Disk usage").getTotal();
    }

    @Override
    public int getUtilizationPercent() {
        return (int)this.statistics.getStatisticsItem("Utilization percent").getTotal();
    }
}

