/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.gc;

import jetbrains.exodus.ExodusException;
import jetbrains.exodus.core.execution.DelegatingJobProcessor;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessor;
import jetbrains.exodus.core.execution.JobProcessorAdapter;
import jetbrains.exodus.core.execution.JobProcessorExceptionHandler;
import jetbrains.exodus.core.execution.LatchJob;
import jetbrains.exodus.core.execution.ThreadJobProcessor;
import jetbrains.exodus.core.execution.ThreadJobProcessorPool;
import jetbrains.exodus.gc.BackgroundCleaningJob;
import jetbrains.exodus.gc.CleanWholeLogJob;
import jetbrains.exodus.gc.GarbageCollector;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BackgroundCleaner {
    private static final Logger logger = LoggerFactory.getLogger(BackgroundCleaner.class);
    @NotNull
    private final GarbageCollector gc;
    @NotNull
    private final BackgroundCleaningJob backgroundCleaningJob;
    @NotNull
    private JobProcessorAdapter processor;
    private long threadId;
    private volatile boolean isSuspended;
    private volatile boolean isCleaning;

    BackgroundCleaner(@NotNull GarbageCollector gc) {
        this.gc = gc;
        this.backgroundCleaningJob = new BackgroundCleaningJob(gc);
        if (gc.getEnvironment().getEnvironmentConfig().isLogCacheShared()) {
            this.setJobProcessor((JobProcessorAdapter)new DelegatingJobProcessor((JobProcessorAdapter)ThreadJobProcessorPool.getOrCreateJobProcessor((String)"Exodus shared background cleaner")));
        } else {
            this.setJobProcessor((JobProcessorAdapter)new ThreadJobProcessor("Exodus background cleaner for " + gc.getEnvironment().getLocation()));
        }
    }

    void setJobProcessor(@NotNull JobProcessorAdapter processor) {
        JobProcessorAdapter delegate;
        JobProcessorAdapter result = null;
        if (processor instanceof ThreadJobProcessor) {
            result = processor;
            this.threadId = ((ThreadJobProcessor)processor).getId();
        } else if (processor instanceof DelegatingJobProcessor && (delegate = ((DelegatingJobProcessor)processor).getDelegate()) instanceof ThreadJobProcessor) {
            result = processor;
            this.threadId = ((ThreadJobProcessor)delegate).getId();
        }
        if (result == null) {
            throw new ExodusException("Unexpected job processor: " + processor);
        }
        if (result.getExceptionHandler() == null) {
            result.setExceptionHandler(new JobProcessorExceptionHandler(){

                public void handle(JobProcessor processor, Job job, Throwable t) {
                    logger.error(t.getMessage(), t);
                }
            });
        }
        result.start();
        this.processor = result;
    }

    @NotNull
    JobProcessorAdapter getJobProcessor() {
        return this.processor;
    }

    void finish() {
        this.backgroundCleaningJob.cancel();
        this.processor.waitForLatchJob(new LatchJob(){

            protected void execute() throws Throwable {
                try {
                    BackgroundCleaner.this.gc.deletePendingFiles();
                }
                finally {
                    this.release();
                }
            }
        }, 100L);
        this.processor.finish();
    }

    boolean isFinished() {
        return this.processor.isFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void suspend() {
        BackgroundCleaningJob backgroundCleaningJob = this.backgroundCleaningJob;
        synchronized (backgroundCleaningJob) {
            if (!this.isSuspended) {
                this.isSuspended = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resume() {
        BackgroundCleaningJob backgroundCleaningJob = this.backgroundCleaningJob;
        synchronized (backgroundCleaningJob) {
            this.isSuspended = false;
        }
    }

    boolean isSuspended() {
        return this.isSuspended;
    }

    boolean isCurrentThread() {
        return this.threadId == Thread.currentThread().getId();
    }

    void queueCleaningJob() {
        if (this.gc.getEnvironment().getEnvironmentConfig().isGcEnabled()) {
            this.processor.queue((Job)this.backgroundCleaningJob);
        }
    }

    void queueCleaningJobAt(long millis) {
        if (this.gc.getEnvironment().getEnvironmentConfig().isGcEnabled()) {
            this.processor.queueAt((Job)this.backgroundCleaningJob, millis);
        }
    }

    boolean isCleaning() {
        return this.isCleaning;
    }

    void setCleaning(boolean isCleaning) {
        this.isCleaning = isCleaning;
    }

    void cleanWholeLog() {
        this.processor.waitForLatchJob((LatchJob)new CleanWholeLogJob(this.gc), 0L);
    }

    void checkThread() {
        if (!this.isCurrentThread()) {
            throw new ExodusException("Background cleaner thread expected as current one");
        }
    }
}

