/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.gc;

import java.util.Iterator;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.gc.BackgroundCleaner;
import jetbrains.exodus.gc.GarbageCollector;
import jetbrains.exodus.gc.UtilizationProfile;
import jetbrains.exodus.log.Log;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BackgroundCleaningJob
extends Job {
    @Nullable
    private GarbageCollector gc;

    BackgroundCleaningJob(@NotNull GarbageCollector gc) {
        this.gc = gc;
    }

    public String getName() {
        return "Background cleaner";
    }

    public String getGroup() {
        return this.gc == null ? "<finished>" : this.gc.getEnvironment().getLocation();
    }

    void cancel() {
        this.gc = null;
        this.setProcessor(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Throwable {
        block11: {
            GarbageCollector gc = this.gc;
            if (gc == null) {
                return;
            }
            BackgroundCleaner cleaner = gc.getCleaner();
            if (!cleaner.isCurrentThread()) {
                return;
            }
            try {
                long minTimeToInvokeCleaner;
                if (!this.canContinue()) break block11;
                EnvironmentImpl env = gc.getEnvironment();
                EnvironmentConfig ec = env.getEnvironmentConfig();
                int gcStartIn = ec.getGcStartIn();
                if (gcStartIn != 0 && (minTimeToInvokeCleaner = (long)gcStartIn + env.getCreated()) > System.currentTimeMillis()) {
                    gc.wakeAt(minTimeToInvokeCleaner);
                    return;
                }
                Log log = env.getLog();
                if ((long)gc.getMinFileAge() >= log.getNumberOfFiles()) break block11;
                cleaner.setCleaning(true);
                try {
                    int gcRunPeriod;
                    this.doCleanLog(log, gc);
                    if (gc.isTooMuchFreeSpace() && (gcRunPeriod = ec.getGcRunPeriod()) > 0) {
                        gc.wakeAt(System.currentTimeMillis() + (long)gcRunPeriod);
                    }
                }
                finally {
                    cleaner.setCleaning(false);
                }
            }
            finally {
                gc.deletePendingFiles();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCleanLog(@NotNull Log log, @NotNull GarbageCollector gc) {
        GarbageCollector.loggingInfo("Starting background cleaner loop for " + log.getLocation());
        EnvironmentImpl env = gc.getEnvironment();
        UtilizationProfile up = gc.getUtilizationProfile();
        long highFile = log.getHighFileAddress();
        long loopStart = System.currentTimeMillis();
        int gcRunPeriod = env.getEnvironmentConfig().getGcRunPeriod();
        try {
            Iterator<Long> fragmentedFiles;
            do {
                if (!(fragmentedFiles = up.getFilesSortedByUtilization(highFile)).hasNext()) {
                    return;
                }
                if (this.cleanFiles(gc, fragmentedFiles)) break;
                Thread.yield();
            } while (this.canContinue() && loopStart + (long)gcRunPeriod > System.currentTimeMillis());
            gc.setUseRegularTxn(true);
            try {
                while (this.canContinue() && loopStart + (long)gcRunPeriod > System.currentTimeMillis() && (fragmentedFiles = up.getFilesSortedByUtilization(highFile)).hasNext()) {
                    if (this.cleanFiles(gc, fragmentedFiles)) continue;
                    break;
                }
            }
            finally {
                gc.setUseRegularTxn(false);
            }
        }
        finally {
            gc.resetNewFiles();
            up.estimateTotalBytes();
            up.setDirty(true);
            GarbageCollector.loggingInfo("Finished background cleaner loop for " + log.getLocation());
        }
    }

    private synchronized boolean cleanFiles(@NotNull GarbageCollector gc, @NotNull Iterator<Long> fragmentedFiles) {
        return gc.cleanFiles(fragmentedFiles);
    }

    private boolean canContinue() {
        GarbageCollector gc = this.gc;
        if (gc == null) {
            return false;
        }
        BackgroundCleaner cleaner = gc.getCleaner();
        if (cleaner.isSuspended() || cleaner.isFinished()) {
            return false;
        }
        EnvironmentConfig ec = gc.getEnvironment().getEnvironmentConfig();
        return ec.isGcEnabled() && !ec.getEnvIsReadonly() && gc.isTooMuchFreeSpace();
    }
}

