/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.gc;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.Priority;
import jetbrains.exodus.core.dataStructures.hash.LongHashMap;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.StoreImpl;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.env.TransactionBase;
import jetbrains.exodus.env.TransactionalExecutable;
import jetbrains.exodus.gc.GarbageCollector;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.ExpiredLoggableInfo;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.NewFileListener;
import jetbrains.exodus.log.RandomAccessLoggable;
import jetbrains.exodus.tree.LongIterator;
import org.jetbrains.annotations.NotNull;

public final class UtilizationProfile {
    @NotNull
    private final EnvironmentImpl env;
    @NotNull
    private final GarbageCollector gc;
    @NotNull
    private final Log log;
    private final long fileSize;
    @NotNull
    private final LongHashMap<MutableLong> filesUtilization;
    private long totalBytes;
    private long totalFreeBytes;
    private volatile boolean isDirty;

    UtilizationProfile(@NotNull EnvironmentImpl env, @NotNull GarbageCollector gc) {
        this.env = env;
        this.gc = gc;
        this.log = env.getLog();
        this.fileSize = this.log.getFileSize() * 1024L;
        this.filesUtilization = new LongHashMap();
        this.log.addNewFileListener(new NewFileListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void fileCreated(long fileAddress) {
                LongHashMap longHashMap = UtilizationProfile.this.filesUtilization;
                synchronized (longHashMap) {
                    UtilizationProfile.this.filesUtilization.put(fileAddress, (Object)new MutableLong(0L));
                }
                UtilizationProfile.this.estimateTotalBytes();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        LongHashMap<MutableLong> longHashMap = this.filesUtilization;
        synchronized (longHashMap) {
            this.filesUtilization.clear();
        }
        this.estimateTotalBytes();
    }

    public void load() {
        if (this.env.getEnvironmentConfig().getGcUtilizationFromScratch()) {
            this.computeUtilizationFromScratch();
        } else {
            this.env.executeInReadonlyTransaction(new TransactionalExecutable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(@NotNull Transaction txn) {
                    if (!UtilizationProfile.this.env.storeExists("exodus.gc.up", txn)) {
                        UtilizationProfile.this.computeUtilizationFromScratch();
                    } else {
                        LongHashMap filesUtilization = new LongHashMap();
                        StoreImpl store = UtilizationProfile.this.env.openStore("exodus.gc.up", StoreConfig.WITHOUT_DUPLICATES, txn);
                        try (Cursor cursor = store.openCursor(txn);){
                            while (cursor.getNext()) {
                                long fileAddress = LongBinding.compressedEntryToLong((ByteIterable)cursor.getKey());
                                long freeBytes = CompressedUnsignedLongByteIterable.getLong(cursor.getValue());
                                filesUtilization.put(fileAddress, (Object)new MutableLong(freeBytes));
                            }
                        }
                        LongHashMap longHashMap = UtilizationProfile.this.filesUtilization;
                        synchronized (longHashMap) {
                            UtilizationProfile.this.filesUtilization.clear();
                            UtilizationProfile.this.filesUtilization.putAll((Map)filesUtilization);
                        }
                    }
                }
            });
        }
        this.estimateTotalBytes();
        if (this.gc.isTooMuchFreeSpace()) {
            this.gc.wake();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(@NotNull Transaction txn) {
        if (this.isDirty) {
            ArrayList filesUtilization;
            StoreImpl store = this.env.openStore("exodus.gc.up", StoreConfig.WITHOUT_DUPLICATES, txn);
            Cursor cursor = store.openCursor(txn);
            Object object = null;
            try {
                while (cursor.getNext()) {
                    boolean fileIsDeleted;
                    long fileAddress = LongBinding.compressedEntryToLong((ByteIterable)cursor.getKey());
                    LongHashMap<MutableLong> longHashMap = this.filesUtilization;
                    synchronized (longHashMap) {
                        fileIsDeleted = !this.filesUtilization.containsKey(fileAddress);
                    }
                    if (!fileIsDeleted) continue;
                    cursor.deleteCurrent();
                }
            }
            catch (Throwable fileAddress) {
                object = fileAddress;
                throw fileAddress;
            }
            finally {
                if (cursor != null) {
                    if (object != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable fileAddress) {
                            ((Throwable)object).addSuppressed(fileAddress);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            object = this.filesUtilization;
            synchronized (object) {
                filesUtilization = new ArrayList(this.filesUtilization.entrySet());
            }
            for (Map.Entry entry : filesUtilization) {
                store.put(txn, (ByteIterable)LongBinding.longToCompressedEntry((long)((Long)entry.getKey())), CompressedUnsignedLongByteIterable.getIterable(((MutableLong)entry.getValue()).value));
            }
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    int totalFreeSpacePercent() {
        long totalBytes = this.totalBytes;
        return (int)(totalBytes == 0L ? 0L : this.totalFreeBytes * 100L / totalBytes);
    }

    public int totalUtilizationPercent() {
        return 100 - this.totalFreeSpacePercent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getFileFreeBytes(long fileAddress) {
        LongHashMap<MutableLong> longHashMap = this.filesUtilization;
        synchronized (longHashMap) {
            MutableLong freeBytes = (MutableLong)this.filesUtilization.get(fileAddress);
            return freeBytes == null ? Long.MAX_VALUE : freeBytes.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fetchExpiredLoggables(@NotNull Iterable<ExpiredLoggableInfo> loggables) {
        long prevFileAddress = -1L;
        MutableLong prevFreeBytes = null;
        LongHashMap<MutableLong> longHashMap = this.filesUtilization;
        synchronized (longHashMap) {
            for (ExpiredLoggableInfo loggable : loggables) {
                MutableLong freeBytes;
                long fileAddress = this.log.getFileAddress(loggable.address);
                MutableLong mutableLong = freeBytes = prevFileAddress == fileAddress ? prevFreeBytes : (MutableLong)this.filesUtilization.get(fileAddress);
                if (freeBytes == null) {
                    freeBytes = new MutableLong(0L);
                    this.filesUtilization.put(fileAddress, (Object)freeBytes);
                }
                MutableLong mutableLong2 = freeBytes;
                mutableLong2.value = mutableLong2.value + (long)loggable.length;
                prevFreeBytes = freeBytes;
                prevFileAddress = fileAddress;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFile(long fileAddress) {
        LongHashMap<MutableLong> longHashMap = this.filesUtilization;
        synchronized (longHashMap) {
            this.filesUtilization.remove(fileAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void estimateTotalBytes() {
        int i;
        long[] fileAddresses = this.log.getAllFileAddresses();
        int filesCount = fileAddresses.length;
        this.totalBytes = filesCount > (i = this.gc.getMinFileAge()) ? (long)(filesCount - i) * this.fileSize : 0L;
        long totalFreeBytes = 0L;
        LongHashMap<MutableLong> longHashMap = this.filesUtilization;
        synchronized (longHashMap) {
            while (i < fileAddresses.length) {
                MutableLong freeBytes = (MutableLong)this.filesUtilization.get(fileAddresses[i]);
                totalFreeBytes += freeBytes != null ? freeBytes.value : this.fileSize;
                ++i;
            }
        }
        this.totalFreeBytes = totalFreeBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<Long> getFilesSortedByUtilization(long highFile) {
        long[] fileAddresses = this.log.getAllFileAddresses();
        long maxFreeBytes = this.fileSize * (long)this.gc.getMaximumFreeSpacePercent() / 100L;
        final PriorityQueue<Pair<Long, Long>> fragmentedFiles = new PriorityQueue<Pair<Long, Long>>(10, new Comparator<Pair<Long, Long>>(){

            @Override
            public int compare(Pair<Long, Long> leftPair, Pair<Long, Long> rightPair) {
                long rightFreeBytes;
                long leftFreeBytes = (Long)leftPair.getSecond();
                if (leftFreeBytes == (rightFreeBytes = ((Long)rightPair.getSecond()).longValue())) {
                    return 0;
                }
                return leftFreeBytes > rightFreeBytes ? -1 : 1;
            }
        });
        final long[] totalCleanableBytes = new long[]{0L};
        final long[] totalFreeBytes = new long[]{0L};
        LongHashMap<MutableLong> longHashMap = this.filesUtilization;
        synchronized (longHashMap) {
            for (int i = this.gc.getMinFileAge(); i < fileAddresses.length; ++i) {
                long file = fileAddresses[i];
                if (file >= highFile || this.gc.isFileCleaned(file)) continue;
                totalCleanableBytes[0] = totalCleanableBytes[0] + this.fileSize;
                MutableLong freeBytes = (MutableLong)this.filesUtilization.get(file);
                if (freeBytes == null) {
                    fragmentedFiles.add((Pair<Long, Long>)new Pair((Object)file, (Object)this.fileSize));
                    totalFreeBytes[0] = totalFreeBytes[0] + this.fileSize;
                    continue;
                }
                long freeBytesValue = freeBytes.value;
                if (freeBytesValue > maxFreeBytes) {
                    fragmentedFiles.add((Pair<Long, Long>)new Pair((Object)file, (Object)freeBytesValue));
                }
                totalFreeBytes[0] = totalFreeBytes[0] + freeBytesValue;
            }
        }
        return new Iterator<Long>(){

            @Override
            public boolean hasNext() {
                return !fragmentedFiles.isEmpty() && totalFreeBytes[0] > totalCleanableBytes[0] * (long)UtilizationProfile.this.gc.getMaximumFreeSpacePercent() / 100L;
            }

            @Override
            public Long next() {
                Pair pair = (Pair)fragmentedFiles.poll();
                totalFreeBytes[0] = totalFreeBytes[0] - (Long)pair.getSecond();
                return (Long)pair.getFirst();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    private void computeUtilizationFromScratch() {
        this.gc.getCleaner().getJobProcessor().queue(new Job(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void execute() throws Throwable {
                final LongHashMap usedSpace = new LongHashMap();
                UtilizationProfile.this.env.executeInReadonlyTransaction(new TransactionalExecutable(){

                    public void execute(@NotNull Transaction txn) {
                        for (String storeName : UtilizationProfile.this.env.getAllStoreNames(txn)) {
                            StoreImpl store = UtilizationProfile.this.env.openStore(storeName, StoreConfig.USE_EXISTING, txn);
                            LongIterator it = ((TransactionBase)txn).getTree(store).addressIterator();
                            while (it.hasNext()) {
                                long address = it.next();
                                RandomAccessLoggable loggable = UtilizationProfile.this.log.read(address);
                                Long fileAddress = UtilizationProfile.this.log.getFileAddress(address);
                                Long usedBytes = (Long)usedSpace.get((Object)fileAddress);
                                if (usedBytes == null) {
                                    usedBytes = 0L;
                                }
                                usedBytes = usedBytes + (long)loggable.length();
                                usedSpace.put(fileAddress, (Object)usedBytes);
                            }
                        }
                    }
                });
                LongHashMap longHashMap = UtilizationProfile.this.filesUtilization;
                synchronized (longHashMap) {
                    UtilizationProfile.this.filesUtilization.clear();
                    for (Map.Entry entry : usedSpace.entrySet()) {
                        UtilizationProfile.this.filesUtilization.put((Long)entry.getKey(), (Object)new MutableLong(UtilizationProfile.this.fileSize - (Long)entry.getValue()));
                    }
                }
            }
        }, Priority.highest);
    }

    private static class MutableLong {
        private long value;

        MutableLong(long value) {
            this.value = value;
        }

        public String toString() {
            return Long.toString(this.value);
        }
    }
}

