/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.OutOfDiskSpaceException;
import jetbrains.exodus.io.AbstractDataWriter;
import jetbrains.exodus.io.LockingManager;
import jetbrains.exodus.log.LogUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDataWriter
extends AbstractDataWriter {
    @NotNull
    private final File dir;
    @NotNull
    private final LockingManager lockingManager;
    @Nullable
    private RandomAccessFile file = null;

    public FileDataWriter(File directory) {
        this.dir = directory;
        this.lockingManager = new LockingManager(this.dir);
    }

    @Override
    public boolean write(byte[] b, int off, int len) throws ExodusException {
        try {
            this.file.write(b, off, len);
        }
        catch (IOException ioe) {
            if (this.lockingManager.getUsableSpace() < (long)len) {
                throw new OutOfDiskSpaceException((Throwable)ioe);
            }
            throw new ExodusException("Can't write to file", (Throwable)ioe);
        }
        return true;
    }

    @Override
    public boolean lock(long timeout) {
        return this.lockingManager.lock(timeout);
    }

    @Override
    public boolean release() {
        return this.lockingManager.release();
    }

    @Override
    public String lockInfo() {
        return this.lockingManager.lockInfo();
    }

    @Override
    protected void syncImpl() {
        RandomAccessFile file = this.file;
        if (file != null) {
            this.forceSync(file);
        }
    }

    @Override
    protected void closeImpl() {
        try {
            this.file.close();
            this.file = null;
        }
        catch (IOException e) {
            throw new ExodusException((Throwable)e);
        }
    }

    @Override
    protected void openOrCreateBlockImpl(long address, long length) {
        try {
            RandomAccessFile result = new RandomAccessFile(new File(this.dir, LogUtil.getLogFilename(address)), "rw");
            result.seek(length);
            if (length != result.length()) {
                result.setLength(length);
                this.forceSync(result);
            }
            this.file = result;
        }
        catch (IOException ioe) {
            throw new ExodusException((Throwable)ioe);
        }
    }

    private void forceSync(@NotNull RandomAccessFile file) {
        block3: {
            try {
                FileChannel channel = file.getChannel();
                channel.force(false);
            }
            catch (ClosedChannelException e) {
            }
            catch (IOException ioe) {
                if (!file.getChannel().isOpen()) break block3;
                throw new ExodusException((Throwable)ioe);
            }
        }
    }
}

