/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.io.inMemory;

import java.util.Collection;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.io.Block;
import jetbrains.exodus.io.DataReader;
import jetbrains.exodus.io.FileDataReader;
import jetbrains.exodus.io.RemoveBlockType;
import jetbrains.exodus.io.inMemory.Memory;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogUtil;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryDataReader
implements DataReader {
    private static final Logger logger = LoggerFactory.getLogger(MemoryDataReader.class);
    @NotNull
    private final Memory data;

    public MemoryDataReader(@NotNull Memory data) {
        this.data = data;
    }

    @Override
    public Block[] getBlocks() {
        Collection<Memory.Block> blocks = this.data.getAllBlocks();
        Block[] result = new Block[blocks.size()];
        int i = 0;
        for (Memory.Block block : blocks) {
            result[i++] = new MemoryBlock(block);
        }
        FileDataReader.sortBlocks(result);
        return result;
    }

    @Override
    public void removeBlock(long blockAddress, @NotNull RemoveBlockType rbt) {
        if (!this.data.removeBlock(blockAddress)) {
            throw new ExodusException("There is no memory block by address " + blockAddress);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Deleted file " + LogUtil.getLogFilename(blockAddress));
        }
    }

    @Override
    public void truncateBlock(long blockAddress, long length) {
        this.data.getOrCreateBlockData(blockAddress, length);
        if (logger.isInfoEnabled()) {
            logger.info("Truncated file " + LogUtil.getLogFilename(blockAddress));
        }
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public void close() {
    }

    @Override
    public void setLog(@NotNull Log log) {
    }

    @Override
    public String getLocation() {
        return this.data.toString();
    }

    @Override
    public Block getBlock(long address) {
        return new MemoryBlock(this.data.getBlockData(address));
    }

    private static final class MemoryBlock
    implements Block {
        @NotNull
        private final Memory.Block data;

        private MemoryBlock(@NotNull Memory.Block data) {
            this.data = data;
        }

        @Override
        public long getAddress() {
            return this.data.getAddress();
        }

        @Override
        public long length() {
            return this.data.getSize();
        }

        @Override
        public int read(byte[] output, long position, int count) {
            return this.data.read(output, position, count);
        }

        @Override
        public boolean setWritable(boolean writable) {
            return false;
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public long lastModified() {
            return 0L;
        }
    }
}

