/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterableBase;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.log.ByteIterableWithAddress;
import jetbrains.exodus.log.ByteIteratorWithAddress;
import jetbrains.exodus.util.ByteIterableUtil;
import org.jetbrains.annotations.NotNull;

class ArrayByteIterableWithAddress
extends ByteIterableWithAddress {
    @NotNull
    private final byte[] bytes;
    private final int start;
    private final int end;

    ArrayByteIterableWithAddress(long address, @NotNull byte[] bytes, int start, int length) {
        super(address);
        this.bytes = bytes;
        this.start = start;
        this.end = Math.min(start + length, bytes.length);
    }

    @Override
    public ByteIteratorWithAddress iterator() {
        return this.iterator(0);
    }

    @Override
    public ByteIteratorWithAddress iterator(int offset) {
        return new ArrayByteIteratorWithAddress(offset);
    }

    @Override
    public int compareTo(int offset, int len, @NotNull ByteIterable right) {
        int absoluteOffset = this.start + offset;
        return ByteIterableUtil.compare((byte[])this.bytes, (int)(absoluteOffset + len), (int)absoluteOffset, (byte[])right.getBytesUnsafe(), (int)right.getLength());
    }

    @Override
    public ByteIterableWithAddress clone(int offset) {
        return new ArrayByteIterableWithAddress(this.getDataAddress() + (long)offset, this.bytes, this.start + offset, this.end - this.start - offset);
    }

    @Override
    public int getLength() {
        return this.end - this.start;
    }

    public String toString() {
        return ByteIterableBase.toString((byte[])this.bytes, (int)this.start, (int)this.end);
    }

    private class ArrayByteIteratorWithAddress
    extends ByteIteratorWithAddress {
        private int i;

        ArrayByteIteratorWithAddress(int offset) {
            this.i = ArrayByteIterableWithAddress.this.start + offset;
        }

        @Override
        public long getAddress() {
            return ArrayByteIterableWithAddress.this.getDataAddress() + (long)this.i - (long)ArrayByteIterableWithAddress.this.start;
        }

        public boolean hasNext() {
            return this.i < ArrayByteIterableWithAddress.this.end;
        }

        public byte next() {
            return ArrayByteIterableWithAddress.this.bytes[this.i++];
        }

        public long skip(long bytes) {
            int skipped = Math.min(ArrayByteIterableWithAddress.this.end - this.i, (int)bytes);
            this.i += skipped;
            return skipped;
        }

        public long nextLong(int length) {
            long result = LongBinding.entryToUnsignedLong((byte[])ArrayByteIterableWithAddress.this.bytes, (int)this.i, (int)length);
            this.i += length;
            return result;
        }
    }
}

