/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import java.util.ArrayList;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.InvalidSettingException;
import jetbrains.exodus.io.DataWriter;
import jetbrains.exodus.io.TransactionalDataWriter;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BufferedDataWriter
implements TransactionalDataWriter {
    @NotNull
    private final Log log;
    @NotNull
    private final LogCache logCache;
    @NotNull
    private final DataWriter child;
    @NotNull
    private MutablePage currentPage;
    private final int pageSize;
    private int count;
    private int capacity;

    private BufferedDataWriter(@NotNull Log log, @NotNull DataWriter child, @NotNull ArrayByteIterable page, long pageAddress) {
        this.log = log;
        this.logCache = log.cache;
        this.child = child;
        this.currentPage = new MutablePage(null, page, pageAddress);
        this.pageSize = log.getCachePageSize();
        if (this.pageSize != page.getBytesUnsafe().length) {
            throw new InvalidSettingException("Configured page size doesn't match actual page size, pageSize = " + this.pageSize + ", actual page size = " + page.getBytesUnsafe().length);
        }
    }

    BufferedDataWriter(@NotNull Log log, @NotNull DataWriter child) {
        this(log, child, log.cache.allocPage(), 0L);
    }

    BufferedDataWriter(@NotNull Log log, @NotNull DataWriter child, long highPageAddress, byte[] highPageContent, int highPageSize) {
        this(log, child, new ArrayByteIterable(highPageContent), highPageAddress);
        this.currentPage.setPageSize(highPageSize);
    }

    @Override
    public DataWriter getChildWriter() {
        return this.child;
    }

    @Override
    public boolean isOpen() {
        return this.child.isOpen();
    }

    @Override
    public boolean write(byte b) {
        int count = this.count;
        MutablePage currentPage = this.currentPage;
        int writtenCount = currentPage.writtenCount;
        if (writtenCount < this.pageSize) {
            currentPage.bytes[writtenCount] = b;
            currentPage.writtenCount = writtenCount + 1;
            this.count = count + 1;
            return true;
        }
        if (count >= this.capacity) {
            return false;
        }
        currentPage = this.allocNewPage();
        currentPage.bytes[0] = b;
        currentPage.writtenCount = 1;
        this.count = count + 1;
        return true;
    }

    @Override
    public boolean write(byte[] b, int off, int len) throws ExodusException {
        int count = this.count + len;
        MutablePage currentPage = this.currentPage;
        while (len > 0) {
            int bytesToWrite = this.pageSize - currentPage.writtenCount;
            if (bytesToWrite == 0) {
                if (count > this.capacity) {
                    return false;
                }
                currentPage = this.allocNewPage();
                bytesToWrite = this.pageSize;
            }
            if (bytesToWrite > len) {
                bytesToWrite = len;
            }
            System.arraycopy(b, off, currentPage.bytes, currentPage.writtenCount, bytesToWrite);
            currentPage.writtenCount += bytesToWrite;
            len -= bytesToWrite;
            off += bytesToWrite;
        }
        this.count = count;
        return true;
    }

    @Override
    public void setMaxBytesToWrite(int capacity) {
        this.capacity = capacity;
    }

    @Override
    public void commit() {
        this.count = 0;
        MutablePage currentPage = this.currentPage;
        currentPage.committedCount = currentPage.writtenCount;
        MutablePage previousPage = currentPage.previousPage;
        if (previousPage != null) {
            ArrayList<MutablePage> fullPages = new ArrayList<MutablePage>();
            do {
                fullPages.add(0, previousPage);
            } while ((previousPage = previousPage.previousPage) != null);
            for (MutablePage mutablePage : fullPages) {
                int off = mutablePage.flushedCount;
                this.child.write(mutablePage.bytes, off, this.pageSize - off);
                this.logCache.cachePage(this.log, mutablePage.pageAddress, mutablePage.page);
            }
            currentPage.previousPage = null;
        }
    }

    @Override
    public void rollback() {
        this.count = 0;
        MutablePage currentPage = this.currentPage;
        MutablePage previousPage = currentPage.previousPage;
        while (previousPage != null) {
            currentPage = previousPage;
            previousPage = previousPage.previousPage;
        }
        currentPage.writtenCount = currentPage.committedCount;
        this.currentPage = currentPage;
    }

    @Override
    public void flush() {
        if (this.count > 0) {
            throw new IllegalStateException("Can't flush uncommitted writer: " + this.count);
        }
        MutablePage currentPage = this.currentPage;
        int committedCount = currentPage.committedCount;
        int flushedCount = currentPage.flushedCount;
        if (committedCount > flushedCount) {
            this.child.write(currentPage.bytes, flushedCount, committedCount - flushedCount);
            currentPage.flushedCount = committedCount;
        }
    }

    @Override
    public void sync() {
        this.child.sync();
    }

    @Override
    public void close() {
        if (this.count > 0) {
            throw new IllegalStateException("Can't close uncommitted writer " + this.count);
        }
        this.child.close();
    }

    @Override
    public void openOrCreateBlock(long address, long length) {
        this.child.openOrCreateBlock(address, length);
    }

    @Override
    public boolean lock(long timeout) {
        return this.child.lock(timeout);
    }

    @Override
    public boolean release() {
        return this.child.release();
    }

    @Override
    public String lockInfo() {
        return this.child.lockInfo();
    }

    @Override
    public ArrayByteIterable getHighPage(long alignedAddress) {
        MutablePage currentPage = this.currentPage;
        do {
            long highPageAddress;
            if (alignedAddress != (highPageAddress = currentPage.pageAddress)) continue;
            int committedCount = currentPage.committedCount;
            return committedCount > 0 ? new ArrayByteIterable(currentPage.bytes, committedCount) : null;
        } while ((currentPage = currentPage.previousPage) != null);
        return null;
    }

    @Override
    public boolean tryAndUpdateHighAddress(long highAddress) {
        if (this.count > 0) {
            throw new IllegalStateException("Can't update high address for uncommitted writer: " + this.count);
        }
        MutablePage currentPage = this.currentPage;
        int committed = (int)(highAddress - currentPage.pageAddress);
        if (committed < 0 || committed > this.pageSize) {
            return false;
        }
        currentPage.setPageSize(committed);
        return true;
    }

    private MutablePage allocNewPage() {
        MutablePage currentPage = this.currentPage;
        this.currentPage = new MutablePage(currentPage, this.logCache.allocPage(), currentPage.pageAddress + (long)this.pageSize);
        return this.currentPage;
    }

    private static class MutablePage {
        @Nullable
        MutablePage previousPage;
        @NotNull
        final ArrayByteIterable page;
        @NotNull
        final byte[] bytes;
        final long pageAddress;
        int flushedCount;
        int committedCount;
        int writtenCount;

        MutablePage(@Nullable MutablePage previousPage, @NotNull ArrayByteIterable page, long pageAddress) {
            this.previousPage = previousPage;
            this.page = page;
            this.bytes = page.getBytesUnsafe();
            this.pageAddress = pageAddress;
            this.setPageSize(0);
        }

        void setPageSize(int pageSize) {
            this.committedCount = this.writtenCount = pageSize;
            this.flushedCount = this.writtenCount;
        }
    }
}

