/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.CompoundByteIteratorBase;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.log.ArrayByteIterableWithAddress;
import jetbrains.exodus.log.ByteIteratorWithAddress;
import jetbrains.exodus.log.IByteIterableComparator;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogAwareFixedLengthByteIterable;
import jetbrains.exodus.log.LogCache;
import org.jetbrains.annotations.NotNull;

public abstract class ByteIterableWithAddress
implements ByteIterable {
    public static final ByteIterableWithAddress EMPTY = ByteIterableWithAddress.getEmpty(-1L);
    private final long address;

    protected ByteIterableWithAddress(long address) {
        this.address = address;
    }

    public final long getDataAddress() {
        return this.address;
    }

    public abstract ByteIteratorWithAddress iterator();

    public abstract ByteIteratorWithAddress iterator(int var1);

    public abstract int compareTo(int var1, int var2, @NotNull ByteIterable var3);

    public abstract ByteIterableWithAddress clone(int var1);

    public byte[] getBytesUnsafe() {
        throw new UnsupportedOperationException();
    }

    public int getLength() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public ByteIterable subIterable(int offset, int length) {
        return new LogAwareFixedLengthByteIterable(this, offset, length);
    }

    public int compareTo(@NotNull ByteIterable right) {
        throw new UnsupportedOperationException();
    }

    public static ByteIterableWithAddress getEmpty(long address) {
        return new ArrayByteIterableWithAddress(address, ByteIterable.EMPTY_BYTES, 0, 0);
    }

    public static int binarySearch(@NotNull IByteIterableComparator comparator, ByteIterable key, int low, int high, int bytesPerLong, Log log, long startAddress) {
        LogCache cache = log.cache;
        int pageSize = log.getCachePageSize();
        int mask = pageSize - 1;
        long leftAddress = -1L;
        byte[] leftPage = null;
        long rightAddress = -1L;
        byte[] rightPage = null;
        BinarySearchIterator it = new BinarySearchIterator(pageSize);
        while (low <= high) {
            int cmp;
            byte[] page;
            long address;
            int mid = low + high + 1 >>> 1;
            long midAddress = startAddress + (long)(mid * bytesPerLong);
            it.offset = (int)midAddress & mask;
            it.address = midAddress - (long)it.offset;
            boolean loaded = false;
            if (it.address == leftAddress) {
                BinarySearchIterator.access$302(it, leftPage);
            } else if (it.address == rightAddress) {
                BinarySearchIterator.access$302(it, rightPage);
            } else {
                BinarySearchIterator.access$302(it, cache.getPage(log, it.address).getBytesUnsafe());
                loaded = true;
            }
            if (pageSize - it.offset < bytesPerLong) {
                address = it.address;
                long nextAddress = address + (long)pageSize;
                if (rightAddress == nextAddress) {
                    BinarySearchIterator.access$402(it, rightPage);
                } else {
                    BinarySearchIterator.access$402(it, cache.getPage(log, nextAddress).getBytesUnsafe());
                    loaded = true;
                }
                page = it.page;
                cmp = comparator.compare(it.asCompound().nextLong(bytesPerLong), key);
            } else {
                cmp = comparator.compare(it.nextLong(bytesPerLong), key);
                page = it.page;
                address = it.address;
            }
            if (cmp < 0) {
                low = mid + 1;
                if (!loaded) continue;
                leftAddress = it.address;
                leftPage = it.page;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                if (!loaded) continue;
                rightAddress = address;
                rightPage = page;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static class BinarySearchIterator
    extends ByteIterator {
        private byte[] page;
        private byte[] nextPage;
        private int offset;
        private long address;
        private final int pageSize;

        private BinarySearchIterator(int pageSize) {
            this.pageSize = pageSize;
        }

        private CompoundByteIteratorBase asCompound() {
            return new CompoundByteIteratorBase(this){

                protected ByteIterator nextIterator() {
                    BinarySearchIterator.access$302(BinarySearchIterator.this, BinarySearchIterator.this.nextPage);
                    BinarySearchIterator.this.address = BinarySearchIterator.this.address + (long)BinarySearchIterator.this.pageSize;
                    BinarySearchIterator.this.offset = 0;
                    return BinarySearchIterator.this;
                }
            };
        }

        public boolean hasNext() {
            return this.offset < this.pageSize;
        }

        public byte next() {
            return this.page[this.offset++];
        }

        public long skip(long bytes) {
            throw new UnsupportedOperationException();
        }

        public long nextLong(int length) {
            long result = LongBinding.entryToUnsignedLong((byte[])this.page, (int)this.offset, (int)length);
            this.offset += length;
            return result;
        }

        static /* synthetic */ byte[] access$302(BinarySearchIterator x0, byte[] x1) {
            x0.page = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$402(BinarySearchIterator x0, byte[] x1) {
            x0.nextPage = x1;
            return x1;
        }
    }
}

