/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.log.ByteIteratorWithAddress;
import jetbrains.exodus.log.Log;
import org.jetbrains.annotations.NotNull;

class CompoundByteIterator
extends ByteIteratorWithAddress {
    @NotNull
    private ArrayByteIterable.Iterator current;
    private boolean hasNext;
    private boolean hasNextValid;
    private long currentAddress;
    private int read;
    private int offset;
    private final Log log;

    CompoundByteIterator(long address, Log log) {
        this.current = ArrayByteIterable.EMPTY.ITERATOR;
        this.currentAddress = address;
        this.read = 0;
        this.offset = 0;
        this.log = log;
    }

    public boolean hasNext() {
        if (!this.hasNextValid) {
            this.hasNext = this.hasNextImpl();
            this.hasNextValid = true;
        }
        return this.hasNext;
    }

    public long skip(long bytes) {
        long skipped = this.current.skip(bytes);
        while (true) {
            this.hasNextValid = false;
            if (skipped >= bytes || !this.hasNext()) break;
            skipped += this.current.skip(bytes - skipped);
        }
        return skipped;
    }

    public byte next() {
        if (!this.hasNext()) {
            throw new ExodusException("CompoundByteIterator: no more bytes available");
        }
        byte result = this.current.next();
        this.hasNextValid = false;
        return result;
    }

    private boolean hasNextImpl() {
        while (!this.current.hasNext()) {
            this.currentAddress += (long)this.read;
            int alignment = (int)this.currentAddress & this.log.getCachePageSize() - 1;
            long alignedAddress = this.currentAddress - (long)alignment;
            ArrayByteIterable page = this.log.cache.getPage(this.log, alignedAddress);
            int readBytes = page.getLength();
            if (readBytes <= alignment) {
                this.read = 0;
                this.offset = 0;
                return false;
            }
            this.read = readBytes - alignment;
            this.current = page.iterator(alignment);
            this.offset = this.current.getOffset();
        }
        return true;
    }

    @Override
    public long getAddress() {
        return this.currentAddress + (long)this.current.getOffset() - (long)this.offset;
    }
}

