/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.log.BlockNotFoundException;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogUtil;
import org.jetbrains.annotations.NotNull;

final class DataIterator
extends ByteIterator {
    @NotNull
    private final Log log;
    private long pageAddress;
    private byte[] page;
    private int offset;
    private int length;

    DataIterator(@NotNull Log log, long startAddress) {
        this.log = log;
        this.nextPage(startAddress);
    }

    public boolean hasNext() {
        if (this.page == null) {
            return false;
        }
        if (this.offset >= this.length) {
            this.nextPage(this.getHighAddress());
            return this.hasNext();
        }
        return true;
    }

    public byte next() {
        if (!this.hasNext()) {
            throw new ExodusException("DataIterator: no more bytes available" + LogUtil.getWrongAddressErrorMessage(this.getHighAddress(), this.log.getFileSize()));
        }
        return this.page[this.offset++];
    }

    public long skip(long bytes) {
        long skipped;
        long pageBytesToSkip;
        for (skipped = 0L; this.page != null && skipped < bytes; skipped += pageBytesToSkip) {
            pageBytesToSkip = Math.min(bytes - skipped, (long)(this.length - this.offset));
            this.offset = (int)((long)this.offset + pageBytesToSkip);
            if (this.offset < this.length) break;
            this.nextPage(this.getHighAddress());
        }
        return skipped;
    }

    public long nextLong(int length) {
        if (this.page == null || this.length - this.offset < length) {
            return LongBinding.entryToUnsignedLong((ByteIterator)this, (int)length);
        }
        long result = LongBinding.entryToUnsignedLong((byte[])this.page, (int)this.offset, (int)length);
        this.offset += length;
        return result;
    }

    byte[] getCurrentPage() {
        return this.page;
    }

    int getOffset() {
        return this.offset;
    }

    int getLength() {
        return this.length;
    }

    long getHighAddress() {
        return this.pageAddress + (long)this.offset;
    }

    private void nextPage(long highAddress) {
        ArrayByteIterable page;
        int offset = (int)highAddress & this.log.getCachePageSize() - 1;
        long pageAddress = highAddress - (long)offset;
        try {
            page = this.log.cache.getPage(this.log, pageAddress);
        }
        catch (BlockNotFoundException e) {
            this.page = null;
            return;
        }
        int len = page.getLength();
        if (len <= offset) {
            this.page = null;
            return;
        }
        this.offset = offset;
        this.length = len;
        this.page = page.getBytesUnsafe();
        this.pageAddress = pageAddress;
    }
}

