/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.InvalidSettingException;
import jetbrains.exodus.core.dataStructures.LongArrayList;
import jetbrains.exodus.core.dataStructures.skiplists.LongSkipList;
import jetbrains.exodus.io.Block;
import jetbrains.exodus.io.DataReader;
import jetbrains.exodus.io.DataWriter;
import jetbrains.exodus.io.RemoveBlockType;
import jetbrains.exodus.io.TransactionalDataWriter;
import jetbrains.exodus.log.ArrayByteIterableWithAddress;
import jetbrains.exodus.log.BlockNotFoundException;
import jetbrains.exodus.log.BufferedDataWriter;
import jetbrains.exodus.log.ByteIteratorWithAddress;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.DataIterator;
import jetbrains.exodus.log.LogCache;
import jetbrains.exodus.log.LogConfig;
import jetbrains.exodus.log.LogTestConfig;
import jetbrains.exodus.log.LogUtil;
import jetbrains.exodus.log.Loggable;
import jetbrains.exodus.log.LoggableFactory;
import jetbrains.exodus.log.LoggableIterator;
import jetbrains.exodus.log.NewFileListener;
import jetbrains.exodus.log.NullLoggable;
import jetbrains.exodus.log.RandomAccessByteIterable;
import jetbrains.exodus.log.RandomAccessLoggable;
import jetbrains.exodus.log.RandomAccessLoggableAndArrayByteIterable;
import jetbrains.exodus.log.RandomAccessLoggableImpl;
import jetbrains.exodus.log.ReadBytesListener;
import jetbrains.exodus.log.RemoveFileListener;
import jetbrains.exodus.log.SeparateLogCache;
import jetbrains.exodus.log.SharedLogCache;
import jetbrains.exodus.log.TooBigLoggableException;
import jetbrains.exodus.util.DeferredIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Log
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(Log.class);
    private static AtomicInteger identityGenerator = new AtomicInteger((int)(Math.random() * 2.147483647E9));
    private static volatile LogCache sharedCache = null;
    @NotNull
    private final LogConfig config;
    private final long created;
    @NotNull
    private final String location;
    private final LongSkipList blockAddrs;
    final LogCache cache;
    private int logIdentity;
    @NotNull
    private TransactionalDataWriter bufferedWriter;
    private long lastSyncTicks;
    @NotNull
    private final DataReader reader;
    private final List<NewFileListener> newFileListeners;
    private final List<ReadBytesListener> readBytesListeners;
    private final List<RemoveFileListener> removeFileListeners;
    private final int cachePageSize;
    private final long fileSize;
    private final long fileLengthBound;
    private long highAddress;
    private long approvedHighAddress;
    @Nullable
    private LogTestConfig testConfig;

    public Log(@NotNull LogConfig config) {
        this.config = config;
        this.tryLock();
        this.created = System.currentTimeMillis();
        this.blockAddrs = new LongSkipList();
        this.fileSize = config.getFileSize();
        this.cachePageSize = config.getCachePageSize();
        long fileLength = this.fileSize * 1024L;
        if (fileLength % (long)this.cachePageSize != 0L) {
            throw new InvalidSettingException("File size should be a multiple of cache page size.");
        }
        this.fileLengthBound = fileLength;
        this.reader = config.getReader();
        this.reader.setLog(this);
        this.location = this.reader.getLocation();
        this.checkLogConsistency();
        this.newFileListeners = new ArrayList<NewFileListener>(2);
        this.readBytesListeners = new ArrayList<ReadBytesListener>(2);
        this.removeFileListeners = new ArrayList<RemoveFileListener>(2);
        long memoryUsage = config.getMemoryUsage();
        boolean nonBlockingCache = config.isNonBlockingCache();
        if (memoryUsage != 0L) {
            this.cache = config.isSharedCache() ? Log.getSharedCache(memoryUsage, this.cachePageSize, nonBlockingCache) : new SeparateLogCache(memoryUsage, this.cachePageSize, nonBlockingCache);
        } else {
            int memoryUsagePercentage = config.getMemoryUsagePercentage();
            this.cache = config.isSharedCache() ? Log.getSharedCache(memoryUsagePercentage, this.cachePageSize, nonBlockingCache) : new SeparateLogCache(memoryUsagePercentage, this.cachePageSize, nonBlockingCache);
        }
        DeferredIO.getJobProcessor();
        this.highAddress = 0L;
        this.approvedHighAddress = 0L;
        DataWriter baseWriter = config.getWriter();
        LongSkipList.SkipListNode lastFile = this.blockAddrs.getMaximumNode();
        if (lastFile == null) {
            this.setBufferedWriter(this.createEmptyBufferedWriter(baseWriter));
        } else {
            long lastFileAddress = lastFile.getKey();
            this.highAddress = lastFileAddress + this.reader.getBlock(lastFileAddress).length();
            long highPageAddress = this.getHighPageAddress();
            byte[] highPageContent = new byte[this.cachePageSize];
            this.setBufferedWriter(this.createBufferedWriter(baseWriter, highPageAddress, highPageContent, this.highAddress == 0L ? 0 : this.readBytes(highPageContent, highPageAddress)));
            LoggableIterator lastFileLoggables = new LoggableIterator(this, lastFileAddress);
            long approvedHighAddress = lastFileAddress;
            try {
                while (lastFileLoggables.hasNext()) {
                    int dataLength;
                    RandomAccessLoggable loggable = (RandomAccessLoggable)lastFileLoggables.next();
                    int n = dataLength = NullLoggable.isNullLoggable(loggable) ? 0 : loggable.getDataLength();
                    if (dataLength > 0) {
                        ByteIteratorWithAddress data = loggable.getData().iterator();
                        for (int i = 0; i < dataLength; ++i) {
                            if (!data.hasNext()) {
                                throw new ExodusException("Can't read loggable fully" + LogUtil.getWrongAddressErrorMessage(data.getAddress(), this.fileSize));
                            }
                            data.next();
                        }
                    }
                    approvedHighAddress = loggable.getAddress() + (long)loggable.length();
                }
            }
            catch (ExodusException e) {
                logger.error("Exception on Log recovery. Approved high address = " + approvedHighAddress, (Throwable)e);
            }
            this.setHighAddress(approvedHighAddress);
            this.approvedHighAddress = approvedHighAddress;
        }
        this.flush(true);
    }

    private void checkLogConsistency() {
        Block[] blocks = this.reader.getBlocks();
        for (int i = 0; i < blocks.length; ++i) {
            Block block = blocks[i];
            long address = block.getAddress();
            long blockLength = block.length();
            String clearLogReason = null;
            if (blockLength > this.fileLengthBound || i < blocks.length - 1 && blockLength != this.fileLengthBound) {
                clearLogReason = "Unexpected file length" + LogUtil.getWrongAddressErrorMessage(address, this.fileSize);
            }
            if (clearLogReason == null && address != this.getFileAddress(address)) {
                if (!this.config.isClearInvalidLog()) {
                    throw new ExodusException("Unexpected file address " + LogUtil.getLogFilename(address) + LogUtil.getWrongAddressErrorMessage(address, this.fileSize));
                }
                clearLogReason = "Unexpected file address " + LogUtil.getLogFilename(address) + LogUtil.getWrongAddressErrorMessage(address, this.fileSize);
            }
            if (clearLogReason != null) {
                if (!this.config.isClearInvalidLog()) {
                    throw new ExodusException(clearLogReason);
                }
                logger.error("Clearing log due to: " + clearLogReason);
                this.blockAddrs.clear();
                this.reader.clear();
                break;
            }
            this.blockAddrs.add(address);
        }
    }

    @NotNull
    public LogConfig getConfig() {
        return this.config;
    }

    public long getCreated() {
        return this.created;
    }

    @NotNull
    public String getLocation() {
        return this.location;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getFileLengthBound() {
        return this.fileLengthBound;
    }

    public long getNumberOfFiles() {
        return this.blockAddrs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getAllFileAddresses() {
        LongSkipList longSkipList = this.blockAddrs;
        synchronized (longSkipList) {
            long[] result = new long[this.blockAddrs.size()];
            LongSkipList.SkipListNode node = this.blockAddrs.getMaximumNode();
            int i = 0;
            while (node != null) {
                result[i] = node.getKey();
                node = this.blockAddrs.getPrevious(node);
                ++i;
            }
            return result;
        }
    }

    public long getHighAddress() {
        return this.highAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHighAddress(long highAddress) {
        if (highAddress > this.highAddress) {
            throw new ExodusException("Only can decrease high address");
        }
        if (highAddress == this.highAddress) {
            return;
        }
        LogTestConfig testConfig = this.testConfig;
        if (testConfig != null && testConfig.isSettingHighAddressDenied()) {
            throw new ExodusException("Setting high address is denied");
        }
        this.bufferedWriter.close();
        LongArrayList blocksToDelete = new LongArrayList();
        long blockToTruncate = -1L;
        LongSkipList longSkipList = this.blockAddrs;
        synchronized (longSkipList) {
            LongSkipList.SkipListNode node = this.blockAddrs.getMaximumNode();
            while (node != null) {
                long blockAddress = node.getKey();
                if (blockAddress <= highAddress) {
                    blockToTruncate = blockAddress;
                    break;
                }
                blocksToDelete.add(blockAddress);
                node = this.blockAddrs.getPrevious(node);
            }
        }
        for (int i = 0; i < blocksToDelete.size(); ++i) {
            this.removeFile(blocksToDelete.get(i));
        }
        if (blockToTruncate >= 0L) {
            this.truncateFile(blockToTruncate, highAddress - blockToTruncate);
        }
        DataWriter baseWriter = this.config.getWriter();
        if (this.blockAddrs.isEmpty()) {
            this.highAddress = 0L;
            this.setBufferedWriter(this.createEmptyBufferedWriter(baseWriter));
        } else {
            long oldHighPageAddress = this.getHighPageAddress();
            this.highAddress = highAddress;
            long highPageAddress = this.getHighPageAddress();
            if (oldHighPageAddress != highPageAddress || !this.bufferedWriter.tryAndUpdateHighAddress(highAddress)) {
                int highPageSize = (int)(highAddress - highPageAddress);
                byte[] highPageContent = new byte[this.cachePageSize];
                if (highPageSize > 0 && this.readBytes(highPageContent, highPageAddress) < highPageSize) {
                    throw new ExodusException("Can't read expected high page bytes");
                }
                this.setBufferedWriter(this.createBufferedWriter(baseWriter, highPageAddress, highPageContent, highPageSize));
            }
        }
    }

    public long approveHighAddress() {
        this.approvedHighAddress = this.highAddress;
        return this.approvedHighAddress;
    }

    public long getLowAddress() {
        Long result = this.blockAddrs.getMinimum();
        return result == null ? -1L : result;
    }

    public long getFileAddress(long address) {
        return address - address % this.fileLengthBound;
    }

    public long getHighFileAddress() {
        return this.getFileAddress(this.highAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextFileAddress(long fileAddress) {
        LongSkipList.SkipListNode node;
        LongSkipList longSkipList = this.blockAddrs;
        synchronized (longSkipList) {
            node = this.blockAddrs.search(fileAddress);
        }
        if (node == null) {
            throw new ExodusException("There is no file by address " + fileAddress);
        }
        return (node = this.blockAddrs.getNext(node)) == null ? -1L : node.getKey();
    }

    public boolean isLastFileAddress(long address) {
        return this.getFileAddress(address) == this.getHighFileAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAddress(long address) {
        LongSkipList.SkipListNode node;
        LongSkipList longSkipList = this.blockAddrs;
        synchronized (longSkipList) {
            node = this.blockAddrs.getLessOrEqual(address);
        }
        if (node == null) {
            return false;
        }
        long leftBound = node.getKey();
        return leftBound + this.getFileSize(leftBound) > address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAddressRange(long from, long to) {
        long leftBound;
        LongSkipList.SkipListNode node;
        LongSkipList longSkipList = this.blockAddrs;
        synchronized (longSkipList) {
            node = this.blockAddrs.getLessOrEqual(from);
        }
        if (node == null) {
            return false;
        }
        do {
            if ((leftBound = node.getKey()) + this.getFileSize(leftBound) <= to) continue;
            return true;
        } while ((node = this.blockAddrs.getNext(node)) != null && node.getKey() - this.fileLengthBound <= leftBound);
        return false;
    }

    public long getFileSize(long fileAddress) {
        if (!this.isLastFileAddress(fileAddress)) {
            return this.fileLengthBound;
        }
        long highAddress = this.highAddress;
        long result = highAddress % this.fileLengthBound;
        if (result == 0L && highAddress != fileAddress) {
            return this.fileLengthBound;
        }
        return result;
    }

    ArrayByteIterable getHighPage(long alignedAddress) {
        return this.bufferedWriter.getHighPage(alignedAddress);
    }

    final int getCachePageSize() {
        return this.cachePageSize;
    }

    public float getCacheHitRate() {
        return this.cache == null ? 0.0f : this.cache.hitRate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewFileListener(@NotNull NewFileListener listener) {
        List<NewFileListener> list = this.newFileListeners;
        synchronized (list) {
            this.newFileListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReadBytesListener(@NotNull ReadBytesListener listener) {
        List<ReadBytesListener> list = this.readBytesListeners;
        synchronized (list) {
            this.readBytesListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoveFileListener(@NotNull RemoveFileListener listener) {
        List<RemoveFileListener> list = this.removeFileListeners;
        synchronized (list) {
            this.removeFileListeners.add(listener);
        }
    }

    @NotNull
    public RandomAccessLoggable read(long address) {
        return this.read(this.readIteratorFrom(address), address);
    }

    @NotNull
    public RandomAccessLoggable read(DataIterator it) {
        return this.read(it, it.getHighAddress());
    }

    @NotNull
    public RandomAccessLoggable read(DataIterator it, long address) {
        byte type = (byte)(it.next() ^ 0x80);
        if (NullLoggable.isNullLoggable(type)) {
            return new NullLoggable(address);
        }
        LoggableFactory prototype = LoggableFactory.getPrototype(type);
        int structureId = CompressedUnsignedLongByteIterable.getInt(it);
        int dataLength = CompressedUnsignedLongByteIterable.getInt(it);
        long dataAddress = it.getHighAddress();
        if (dataLength > 0) {
            byte[] currentPage = it.getCurrentPage();
            int currentOffset = it.getOffset();
            if (it.getLength() - currentOffset >= dataLength) {
                return prototype == null ? new RandomAccessLoggableAndArrayByteIterable(address, type, structureId, dataAddress, currentPage, currentOffset, dataLength) : prototype.create(address, new ArrayByteIterableWithAddress(dataAddress, currentPage, currentOffset, dataLength), dataLength, structureId);
            }
        }
        RandomAccessByteIterable data = new RandomAccessByteIterable(dataAddress, this);
        return prototype == null ? new RandomAccessLoggableImpl(address, type, data, dataLength, structureId) : prototype.create(address, data, dataLength, structureId);
    }

    public LoggableIterator getLoggableIterator(long startAddress) {
        return new LoggableIterator(this, startAddress);
    }

    public long tryWrite(Loggable loggable) {
        return this.tryWrite(loggable.getType(), loggable.getStructureId(), loggable.getData());
    }

    public long tryWrite(byte type, int structureId, ByteIterable data) {
        long result = this.writeContinuously(type, structureId, data);
        if (result < 0L) {
            this.padWithNulls();
        }
        return result;
    }

    public long write(Loggable loggable) {
        return this.write(loggable.getType(), loggable.getStructureId(), loggable.getData());
    }

    public long write(byte type, int structureId, ByteIterable data) {
        long result = this.writeContinuously(type, structureId, data);
        if (result < 0L) {
            this.padWithNulls();
            result = this.writeContinuously(type, structureId, data);
            if (result < 0L) {
                throw new TooBigLoggableException();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Loggable getFirstLoggableOfType(int type) {
        LongSkipList.SkipListNode node;
        LongSkipList longSkipList = this.blockAddrs;
        synchronized (longSkipList) {
            node = this.blockAddrs.getMinimumNode();
        }
        while (node != null) {
            Loggable loggable;
            long fileAddress = node.getKey();
            LoggableIterator it = this.getLoggableIterator(fileAddress);
            while (it.hasNext() && (loggable = (Loggable)it.next()).getAddress() < fileAddress + this.fileLengthBound) {
                if (loggable.getType() != type) continue;
                return loggable;
            }
            node = this.blockAddrs.getNext(node);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Loggable getLastLoggableOfType(int type) {
        LongSkipList.SkipListNode node;
        LongSkipList longSkipList = this.blockAddrs;
        synchronized (longSkipList) {
            node = this.blockAddrs.getMaximumNode();
        }
        Loggable result = null;
        if (node != null) {
            if (this.getFileSize(node.getKey()) == 0L) {
                node = this.blockAddrs.getPrevious(node);
            }
            while (result == null && node != null) {
                Loggable loggable;
                long fileAddress = node.getKey();
                LoggableIterator it = this.getLoggableIterator(fileAddress);
                while (it.hasNext() && (loggable = (Loggable)it.next()).getAddress() < fileAddress + this.fileLengthBound) {
                    if (loggable.getType() != type) continue;
                    result = loggable;
                }
                node = this.blockAddrs.getPrevious(node);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Loggable getLastLoggableOfTypeBefore(int type, long beforeAddress) {
        LongSkipList.SkipListNode node;
        LongSkipList longSkipList = this.blockAddrs;
        synchronized (longSkipList) {
            node = this.blockAddrs.getLessOrEqual(beforeAddress);
        }
        Loggable result = null;
        while (result == null && node != null) {
            Loggable loggable;
            LoggableIterator it = this.getLoggableIterator(node.getKey());
            while (it.hasNext() && (loggable = (Loggable)it.next()).getAddress() < beforeAddress) {
                if (loggable.getType() != type) continue;
                result = loggable;
            }
            node = this.blockAddrs.getPrevious(node);
        }
        return result;
    }

    public boolean isImmutableFile(long fileAddress) {
        return fileAddress + this.fileLengthBound <= this.approvedHighAddress;
    }

    public void flush() {
        this.flush(false);
    }

    public void flush(boolean forceSync) {
        TransactionalDataWriter bufferedWriter = this.bufferedWriter;
        bufferedWriter.flush();
        if ((forceSync || this.config.isDurableWrite()) && !this.config.isFsyncSuppressed()) {
            bufferedWriter.sync();
            this.lastSyncTicks = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.flush(true);
        this.reader.close();
        this.bufferedWriter.close();
        this.release();
        LongSkipList longSkipList = this.blockAddrs;
        synchronized (longSkipList) {
            this.blockAddrs.clear();
        }
    }

    public void release() {
        this.bufferedWriter.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.bufferedWriter.close();
        LongSkipList longSkipList = this.blockAddrs;
        synchronized (longSkipList) {
            this.blockAddrs.clear();
        }
        this.cache.clear();
        this.reader.clear();
        this.setBufferedWriter(this.createEmptyBufferedWriter(this.bufferedWriter.getChildWriter()));
        this.highAddress = 0L;
    }

    public boolean fileExists(long fileAddress) {
        return this.reader.getBlock(fileAddress).exists();
    }

    public void removeFile(long address) {
        this.removeFile(address, RemoveBlockType.Delete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFile(long address, @NotNull RemoveBlockType rbt) {
        LongSkipList listeners;
        LongSkipList longSkipList = this.removeFileListeners;
        synchronized (longSkipList) {
            listeners = this.removeFileListeners.toArray(new RemoveFileListener[this.removeFileListeners.size()]);
        }
        for (RemoveFileListener listener : listeners) {
            listener.beforeRemoveFile(address);
        }
        try {
            this.reader.removeBlock(address, rbt);
            longSkipList = this.blockAddrs;
            synchronized (longSkipList) {
                this.blockAddrs.remove(address);
            }
            for (long offset = 0L; offset < this.fileLengthBound; offset += (long)this.cachePageSize) {
                this.cache.removePage(this, address + offset);
            }
        }
        finally {
            for (RemoveFileListener listener : listeners) {
                listener.afterRemoveFile(address);
            }
        }
    }

    private void truncateFile(long address, long length) {
        this.reader.truncateBlock(address, length);
        for (long offset = length - length % (long)this.cachePageSize; offset < this.fileLengthBound; offset += (long)this.cachePageSize) {
            this.cache.removePage(this, address + offset);
        }
    }

    void padWithNulls() {
        ArrayByteIterable cachedTailPage;
        long bytesToWrite = this.fileLengthBound - this.getLastFileLength();
        if (bytesToWrite == 0L) {
            throw new ExodusException("Nothing to pad");
        }
        if (bytesToWrite >= (long)this.cachePageSize && (cachedTailPage = LogCache.getCachedTailPage(this.cachePageSize)) != null) {
            byte[] bytes = cachedTailPage.getBytesUnsafe();
            do {
                this.bufferedWriter.write(bytes, 0, this.cachePageSize);
                this.highAddress += (long)this.cachePageSize;
            } while ((bytesToWrite -= (long)this.cachePageSize) >= (long)this.cachePageSize);
        }
        if (bytesToWrite == 0L) {
            this.bufferedWriter.commit();
            this.createNewFileIfNecessary();
        } else {
            while (bytesToWrite-- > 0L) {
                this.writeContinuously(NullLoggable.create());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void invalidateSharedCache() {
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            sharedCache = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    int getIdentity() {
        return this.logIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readBytes(byte[] output, long address) throws BlockNotFoundException {
        LongSkipList.SkipListNode node;
        LongSkipList longSkipList = this.blockAddrs;
        synchronized (longSkipList) {
            node = this.blockAddrs.getLessOrEqual(address);
        }
        if (node == null) {
            throw new BlockNotFoundException("Address is out of log space, underflow", address);
        }
        long leftBound = node.getKey();
        Block block = this.reader.getBlock(leftBound);
        long fileSize = this.getFileSize(leftBound);
        if (leftBound + fileSize <= address) {
            if (this.blockAddrs.getMaximumNode() == node) {
                throw new BlockNotFoundException("Address is out of log space, overflow", address);
            }
            throw new BlockNotFoundException(address);
        }
        int readBytes = block.read(output, address - leftBound, output.length);
        this.notifyReadBytes(output, readBytes);
        return readBytes;
    }

    DataIterator readIteratorFrom(long address) {
        return new DataIterator(this, address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static LogCache getSharedCache(long memoryUsage, int pageSize, boolean nonBlocking) {
        if (sharedCache != null) return sharedCache;
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            if (sharedCache != null) return sharedCache;
            sharedCache = new SharedLogCache(memoryUsage, pageSize, nonBlocking);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return sharedCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static LogCache getSharedCache(int memoryUsagePercentage, int pageSize, boolean nonBlocking) {
        if (sharedCache != null) return sharedCache;
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            if (sharedCache != null) return sharedCache;
            sharedCache = new SharedLogCache(memoryUsagePercentage, pageSize, nonBlocking);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return sharedCache;
        }
    }

    private void tryLock() {
        long lockTimeout = this.config.getLockTimeout();
        DataWriter writer = this.config.getWriter();
        if (!writer.lock(lockTimeout)) {
            throw new ExodusException("Can't acquire environment lock after " + lockTimeout + " ms.\n\n Lock owner info: \n" + writer.lockInfo());
        }
    }

    @NotNull
    private TransactionalDataWriter createEmptyBufferedWriter(DataWriter writer) {
        this.notifyFileCreated(0L);
        return new BufferedDataWriter(this, writer);
    }

    private TransactionalDataWriter createBufferedWriter(DataWriter writer, long highPageAddress, byte[] highPageContent, int highPageSize) {
        return new BufferedDataWriter(this, writer, highPageAddress, highPageContent, highPageSize);
    }

    private long getHighPageAddress() {
        long highAddress = this.highAddress;
        int alignment = (int)highAddress & this.cachePageSize - 1;
        if (alignment == 0 && highAddress > 0L) {
            alignment = this.cachePageSize;
        }
        return highAddress - (long)alignment;
    }

    public long writeContinuously(Loggable loggable) {
        return this.writeContinuously(loggable.getType(), loggable.getStructureId(), loggable.getData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeContinuously(byte type, int structureId, ByteIterable data) {
        long maxHighAddress;
        long result = this.highAddress;
        LogTestConfig testConfig = this.testConfig;
        if (testConfig != null && (maxHighAddress = testConfig.getMaxHighAddress()) >= 0L && result >= maxHighAddress) {
            throw new ExodusException("Can't write more than " + maxHighAddress);
        }
        TransactionalDataWriter bufferedWriter = this.bufferedWriter;
        if (!bufferedWriter.isOpen()) {
            boolean fileCreated;
            long fileAddress = this.getFileAddress(result);
            bufferedWriter.openOrCreateBlock(fileAddress, this.getLastFileLength());
            LongSkipList longSkipList = this.blockAddrs;
            synchronized (longSkipList) {
                boolean bl = fileCreated = this.blockAddrs.search(fileAddress) == null;
                if (fileCreated) {
                    this.blockAddrs.add(fileAddress);
                }
            }
            if (fileCreated) {
                this.notifyFileCreated(fileAddress);
            }
        }
        try {
            bufferedWriter.setMaxBytesToWrite((int)(this.fileLengthBound - this.getLastFileLength()));
            bufferedWriter.write((byte)(type ^ 0x80));
            int recordLength = 1;
            if (!NullLoggable.isNullLoggable(type)) {
                recordLength += Log.writeByteIterable(bufferedWriter, CompressedUnsignedLongByteIterable.getIterable(structureId));
                int length = data.getLength();
                if (length < 0) {
                    throw new ExodusException("Negative length of loggable data");
                }
                recordLength += Log.writeByteIterable(bufferedWriter, CompressedUnsignedLongByteIterable.getIterable(length));
                int actualLength = Log.writeByteIterable(bufferedWriter, data);
                if (actualLength != length) {
                    throw new IllegalArgumentException("Loggable contains invalid length descriptor");
                }
                recordLength += actualLength;
            }
            bufferedWriter.commit();
            this.highAddress += (long)recordLength;
            this.createNewFileIfNecessary();
            return result;
        }
        catch (Throwable e) {
            this.highAddress = result;
            bufferedWriter.rollback();
            if (!(e instanceof NewFileCreationDeniedException)) {
                throw ExodusException.toExodusException((Throwable)e);
            }
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewFileIfNecessary() {
        boolean shouldCreateNewFile;
        boolean bl = shouldCreateNewFile = this.getLastFileLength() == 0L;
        if (shouldCreateNewFile) {
            this.flush();
            this.bufferedWriter.close();
            if (this.config.isFullFileReadonly()) {
                Long lastFile;
                LongSkipList longSkipList = this.blockAddrs;
                synchronized (longSkipList) {
                    lastFile = this.blockAddrs.getMaximum();
                }
                if (lastFile != null) {
                    this.reader.getBlock(lastFile).setWritable(false);
                }
            }
        } else if (System.currentTimeMillis() > this.lastSyncTicks + this.config.getSyncPeriod()) {
            this.flush(true);
        }
    }

    public void setLogTestConfig(@Nullable LogTestConfig testConfig) {
        this.testConfig = testConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFileCreated(long fileAddress) {
        NewFileListener[] newFileListenerArray = this.newFileListeners;
        synchronized (this.newFileListeners) {
            NewFileListener[] listeners = this.newFileListeners.toArray(new NewFileListener[this.newFileListeners.size()]);
            // ** MonitorExit[var4_2] (shouldn't be in output)
            for (NewFileListener listener : listeners) {
                listener.fileCreated(fileAddress);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyReadBytes(byte[] bytes, int count) {
        ReadBytesListener[] readBytesListenerArray = this.readBytesListeners;
        synchronized (this.readBytesListeners) {
            ReadBytesListener[] listeners = this.readBytesListeners.toArray(new ReadBytesListener[this.readBytesListeners.size()]);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (ReadBytesListener listener : listeners) {
                listener.bytesRead(bytes, count);
            }
            return;
        }
    }

    private static int writeByteIterable(TransactionalDataWriter writer, ByteIterable iterable) {
        int length = iterable.getLength();
        if (length == 0) {
            return 0;
        }
        if (length < 3) {
            ByteIterator iterator = iterable.iterator();
            if (!writer.write(iterator.next())) {
                throw new NewFileCreationDeniedException();
            }
            if (length == 2 && !writer.write(iterator.next())) {
                throw new NewFileCreationDeniedException();
            }
        } else if (!writer.write(iterable.getBytesUnsafe(), 0, length)) {
            throw new NewFileCreationDeniedException();
        }
        return length;
    }

    private long getLastFileLength() {
        return this.highAddress % this.fileLengthBound;
    }

    private void setBufferedWriter(@NotNull TransactionalDataWriter bufferedWriter) {
        int nextIdentity;
        int currentIdentity;
        this.bufferedWriter = bufferedWriter;
        int intPrime = 800076929;
        do {
            if ((nextIdentity = (currentIdentity = identityGenerator.get()) + 800076929 & Integer.MAX_VALUE) != 0) continue;
            nextIdentity += 800076929;
        } while (!identityGenerator.compareAndSet(currentIdentity, nextIdentity));
        this.logIdentity = nextIdentity;
    }

    private static final class NewFileCreationDeniedException
    extends RuntimeException {
        private NewFileCreationDeniedException() {
        }
    }
}

