/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.ExodusException;
import jetbrains.exodus.log.ByteIterableWithAddress;
import jetbrains.exodus.log.RandomAccessLoggable;
import org.jetbrains.annotations.NotNull;

public abstract class LoggableFactory {
    private static final int MAXIMUM_LOGGABLE_TYPE = 128;
    private static final LoggableFactory[] FACTORY = new LoggableFactory[128];

    protected LoggableFactory() {
    }

    public static void registerLoggable(int type, LoggableFactory loggableFactory) {
        LoggableFactory prevLoggableFactory = FACTORY[type];
        if (prevLoggableFactory != null && prevLoggableFactory != loggableFactory) {
            throw new ExodusException("Loggable type is already registered " + type);
        }
        LoggableFactory.FACTORY[type] = loggableFactory;
    }

    public static void clear() {
        for (int i = 0; i < FACTORY.length; ++i) {
            LoggableFactory.FACTORY[i] = null;
        }
    }

    static LoggableFactory getPrototype(byte type) {
        if (type < 0 || type >= FACTORY.length) {
            throw new ExodusException("Invalid loggable type");
        }
        return FACTORY[type];
    }

    protected abstract RandomAccessLoggable create(long var1, @NotNull ByteIterableWithAddress var3, int var4, int var5);
}

