/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.log.BlockNotFoundException;
import jetbrains.exodus.log.ByteIterableWithAddress;
import jetbrains.exodus.log.ByteIteratorWithAddress;
import jetbrains.exodus.log.CompoundByteIterator;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogCache;
import org.jetbrains.annotations.NotNull;

class RandomAccessByteIterable
extends ByteIterableWithAddress {
    @NotNull
    private final Log log;

    public RandomAccessByteIterable(long address, @NotNull Log log) {
        super(address);
        this.log = log;
    }

    @Override
    public ByteIteratorWithAddress iterator() {
        return new CompoundByteIterator(this.getDataAddress(), this.log);
    }

    @Override
    public ByteIteratorWithAddress iterator(int offset) {
        return new CompoundByteIterator(this.getDataAddress() + (long)offset, this.log);
    }

    @Override
    public int compareTo(int offset, int len, @NotNull ByteIterable right) {
        return RandomAccessByteIterable.compare(offset, len, right, this.log, this.getDataAddress());
    }

    @Override
    @NotNull
    public RandomAccessByteIterable clone(int offset) {
        return new RandomAccessByteIterable(this.getDataAddress() + (long)offset, this.log);
    }

    private static int compare(int offset, int len, ByteIterable right, Log log, long address) {
        int leftStep;
        ArrayByteIterable left;
        int leftLen;
        LogCache cache = log.cache;
        int pageSize = log.getCachePageSize();
        int mask = pageSize - 1;
        long alignedAddress = address + (long)offset;
        long endAddress = alignedAddress + (long)len;
        endAddress -= (long)((int)endAddress & mask);
        if ((leftLen = (left = cache.getPage(log, alignedAddress -= (long)(leftStep = (int)alignedAddress & mask))).getLength()) <= leftStep) {
            throw new BlockNotFoundException(alignedAddress);
        }
        byte[] leftArray = left.getBytesUnsafe();
        byte[] rightArray = right.getBytesUnsafe();
        int rightLen = right.getLength();
        int rightStep = 0;
        while (true) {
            int limit = Math.min(len, Math.min(leftLen - leftStep, rightLen));
            while (rightStep < limit) {
                byte b2;
                byte b1;
                if ((b1 = leftArray[leftStep++]) == (b2 = rightArray[rightStep++])) continue;
                return (b1 & 0xFF) - (b2 & 0xFF);
            }
            if (rightStep == rightLen || alignedAddress >= endAddress) {
                return len - rightLen;
            }
            left = cache.getPage(log, alignedAddress += (long)pageSize);
            leftArray = left.getBytesUnsafe();
            leftLen = left.getLength();
            leftStep = 0;
        }
    }
}

