/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.log.ArrayByteIterableWithAddress;
import jetbrains.exodus.log.ByteIterableWithAddress;
import jetbrains.exodus.log.RandomAccessLoggable;
import org.jetbrains.annotations.NotNull;

class RandomAccessLoggableAndArrayByteIterable
extends ArrayByteIterableWithAddress
implements RandomAccessLoggable {
    private final int structureId;
    private final byte type;
    private final byte headerLength;

    public RandomAccessLoggableAndArrayByteIterable(long address, byte type, int structureId, long dataAddress, @NotNull byte[] bytes, int start, int dataLength) {
        super(dataAddress, bytes, start, dataLength);
        this.structureId = structureId;
        this.type = type;
        this.headerLength = (byte)(dataAddress - address);
    }

    @Override
    public long getAddress() {
        return this.getDataAddress() - (long)this.headerLength;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    @Override
    public int length() {
        return this.headerLength + this.getDataLength();
    }

    @Override
    @NotNull
    public ByteIterableWithAddress getData() {
        return this;
    }

    @Override
    public int getDataLength() {
        return this.getLength();
    }

    @Override
    public int getStructureId() {
        return this.structureId;
    }
}

