/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.core.dataStructures.ConcurrentLongObjectCache;
import jetbrains.exodus.core.dataStructures.LongObjectCache;
import jetbrains.exodus.core.dataStructures.LongObjectCacheBase;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogCache;
import org.jetbrains.annotations.NotNull;

final class SeparateLogCache
extends LogCache {
    @NotNull
    private final LongObjectCacheBase<ArrayByteIterable> pagesCache;

    SeparateLogCache(long memoryUsage, int pageSize, boolean nonBlocking) {
        super(memoryUsage, pageSize);
        int pagesCount = (int)(memoryUsage / (long)(pageSize + 80));
        this.pagesCache = nonBlocking ? new ConcurrentLongObjectCache(pagesCount, 2) : new LongObjectCache(pagesCount);
    }

    SeparateLogCache(int memoryUsagePercentage, int pageSize, boolean nonBlocking) {
        super(memoryUsagePercentage, pageSize);
        if (this.memoryUsage == Long.MAX_VALUE) {
            this.pagesCache = nonBlocking ? new ConcurrentLongObjectCache(8192, 2) : new LongObjectCache();
        } else {
            int pagesCount = (int)(this.memoryUsage / (long)(pageSize + 80));
            this.pagesCache = nonBlocking ? new ConcurrentLongObjectCache(pagesCount, 2) : new LongObjectCache(pagesCount);
        }
    }

    @Override
    public void clear() {
        try (LongObjectCacheBase.CriticalSection ignored = this.pagesCache.newCriticalSection();){
            this.pagesCache.clear();
        }
    }

    @Override
    public float hitRate() {
        return this.pagesCache.hitRate();
    }

    @Override
    void cachePage(@NotNull Log log, long pageAddress, @NotNull ArrayByteIterable page) {
        this.cachePage(pageAddress >> this.pageSizeLogarithm, page);
    }

    @Override
    @NotNull
    ArrayByteIterable getPage(@NotNull Log log, long pageAddress) {
        ArrayByteIterable page = log.getHighPage(pageAddress);
        if (page != null) {
            return page;
        }
        long cacheKey = pageAddress >> this.pageSizeLogarithm;
        page = (ArrayByteIterable)this.pagesCache.tryKeyLocked(cacheKey);
        if (page != null) {
            return page;
        }
        page = this.readFullPage(log, pageAddress);
        this.cachePage(cacheKey, page);
        return page;
    }

    @Override
    protected void removePage(@NotNull Log log, long pageAddress) {
        try (LongObjectCacheBase.CriticalSection ignored = this.pagesCache.newCriticalSection();){
            this.pagesCache.remove(pageAddress >> this.pageSizeLogarithm);
        }
    }

    private void cachePage(long cacheKey, @NotNull ArrayByteIterable page) {
        try (LongObjectCacheBase.CriticalSection ignored = this.pagesCache.newCriticalSection();){
            if (this.pagesCache.getObject(cacheKey) == null) {
                this.pagesCache.cacheObject(cacheKey, (Object)SeparateLogCache.postProcessTailPage(page));
            }
        }
    }
}

