/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.core.dataStructures.ConcurrentLongObjectCache;
import jetbrains.exodus.core.dataStructures.LongObjectCache;
import jetbrains.exodus.core.dataStructures.LongObjectCacheBase;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogCache;
import org.jetbrains.annotations.NotNull;

final class SharedLogCache
extends LogCache {
    @NotNull
    private final LongObjectCacheBase<CachedValue> pagesCache;

    SharedLogCache(long memoryUsage, int pageSize, boolean nonBlocking) {
        super(memoryUsage, pageSize);
        int pagesCount = (int)(memoryUsage / (long)(pageSize + 96));
        this.pagesCache = nonBlocking ? new ConcurrentLongObjectCache(pagesCount, 2) : new LongObjectCache(pagesCount);
    }

    SharedLogCache(int memoryUsagePercentage, int pageSize, boolean nonBlocking) {
        super(memoryUsagePercentage, pageSize);
        if (this.memoryUsage == Long.MAX_VALUE) {
            this.pagesCache = nonBlocking ? new ConcurrentLongObjectCache(8192, 2) : new LongObjectCache();
        } else {
            int pagesCount = (int)(this.memoryUsage / (long)(pageSize + 96));
            this.pagesCache = nonBlocking ? new ConcurrentLongObjectCache(pagesCount, 2) : new LongObjectCache(pagesCount);
        }
    }

    @Override
    void clear() {
    }

    @Override
    float hitRate() {
        return this.pagesCache.hitRate();
    }

    @Override
    void cachePage(@NotNull Log log, long pageAddress, @NotNull ArrayByteIterable page) {
        int logIdentity = log.getIdentity();
        long adjustedPageAddress = pageAddress >> this.pageSizeLogarithm;
        this.cachePage(SharedLogCache.getLogPageFingerPrint(logIdentity, adjustedPageAddress), logIdentity, adjustedPageAddress, page);
    }

    @Override
    @NotNull
    protected ArrayByteIterable getPage(@NotNull Log log, long pageAddress) {
        ArrayByteIterable page = log.getHighPage(pageAddress);
        if (page != null) {
            return page;
        }
        long adjustedPageAddress = pageAddress >> this.pageSizeLogarithm;
        int logIdentity = log.getIdentity();
        long key = SharedLogCache.getLogPageFingerPrint(logIdentity, adjustedPageAddress);
        CachedValue cachedValue = (CachedValue)this.pagesCache.tryKeyLocked(key);
        ArrayByteIterable arrayByteIterable = page = cachedValue != null && cachedValue.logIdentity == logIdentity && cachedValue.address == adjustedPageAddress ? cachedValue.page : null;
        if (page != null) {
            return page;
        }
        page = this.readFullPage(log, pageAddress);
        this.cachePage(key, logIdentity, adjustedPageAddress, page);
        return page;
    }

    @Override
    protected void removePage(@NotNull Log log, long pageAddress) {
        long key = SharedLogCache.getLogPageFingerPrint(log.getIdentity(), pageAddress >> this.pageSizeLogarithm);
        try (LongObjectCacheBase.CriticalSection ignored = this.pagesCache.newCriticalSection();){
            this.pagesCache.remove(key);
        }
    }

    private void cachePage(long key, int logIdentity, long address, @NotNull ArrayByteIterable page) {
        try (LongObjectCacheBase.CriticalSection ignored = this.pagesCache.newCriticalSection();){
            if (this.pagesCache.getObject(key) == null) {
                this.pagesCache.cacheObject(key, (Object)new CachedValue(logIdentity, address, SharedLogCache.postProcessTailPage(page)));
            }
        }
    }

    private static long getLogPageFingerPrint(int logIdentity, long address) {
        return ((long)logIdentity << 32) + (long)logIdentity + address;
    }

    private static final class CachedValue {
        private final int logIdentity;
        private final long address;
        private final ArrayByteIterable page;

        public CachedValue(int logIdentity, long address, @NotNull ArrayByteIterable page) {
            this.logIdentity = logIdentity;
            this.address = address;
            this.page = page;
        }
    }
}

