/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.tree.ITreeCursorMutable;
import jetbrains.exodus.tree.ITreeMutable;
import jetbrains.exodus.tree.MutableTreeRoot;
import jetbrains.exodus.tree.TreeCursor;
import jetbrains.exodus.tree.TreeTraverser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeCursorMutable
extends TreeCursor
implements ITreeCursorMutable {
    protected ITreeMutable tree;
    protected boolean wasDelete = false;
    @Nullable
    protected ByteIterable nextAfterRemovedKey = null;
    @Nullable
    protected ByteIterable nextAfterRemovedValue = null;

    public TreeCursorMutable(ITreeMutable tree, TreeTraverser traverser) {
        super(traverser);
        this.tree = tree;
    }

    public TreeCursorMutable(ITreeMutable tree, TreeTraverser traverser, boolean alreadyIn) {
        super(traverser, alreadyIn);
        this.tree = tree;
    }

    @Override
    public boolean getNext() {
        if (this.wasDelete) {
            this.wasDelete = false;
            ByteIterable key = this.nextAfterRemovedKey;
            if (key != null) {
                if (this.traverser.moveTo(key, this.tree.isAllowingDuplicates() ? this.nextAfterRemovedValue : null)) {
                    this.inited = true;
                    return true;
                }
                return false;
            }
            return false;
        }
        return super.getNext();
    }

    protected void reset(MutableTreeRoot newRoot) {
        this.traverser.reset(newRoot);
        this.canGoDown = true;
        this.alreadyIn = false;
        this.inited = false;
    }

    @Override
    protected boolean hasNext() {
        return this.wasDelete ? this.nextAfterRemovedKey != null : super.hasNext();
    }

    @Override
    public boolean getPrev() {
        if (this.wasDelete) {
            throw new UnsupportedOperationException();
        }
        return super.getPrev();
    }

    @Override
    protected boolean hasPrev() {
        if (this.wasDelete) {
            throw new UnsupportedOperationException();
        }
        return super.hasPrev();
    }

    @Override
    public boolean deleteCurrent() {
        boolean result;
        if (this.wasDelete) {
            return false;
        }
        ByteIterable key = this.getKey();
        ByteIterable value = this.getValue();
        if (this.getNext()) {
            this.nextAfterRemovedKey = this.traverser.getKey();
            this.nextAfterRemovedValue = this.traverser.getValue();
        } else {
            this.nextAfterRemovedKey = null;
            this.nextAfterRemovedValue = null;
        }
        boolean bl = result = this.tree.isAllowingDuplicates() ? this.tree.delete(key, value, this) : this.tree.delete(key, null, this);
        assert (result);
        this.wasDelete = true;
        this.reset(this.tree.getRoot());
        return true;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public void treeChanged() {
        ByteIterable key = this.getKey();
        ByteIterable value = this.getValue();
        this.reset(this.tree.getRoot());
        boolean withDuplicates = this.tree.isAllowingDuplicates();
        if (!this.traverser.moveTo(key, (ByteIterable)(withDuplicates ? value : null))) {
            this.wasDelete = true;
            if (withDuplicates ? !this.traverser.moveToRange(key, value) && !this.traverser.moveToRange(key, null) : !this.traverser.moveToRange(key, null)) {
                return;
            }
            this.nextAfterRemovedKey = this.traverser.getKey();
            this.nextAfterRemovedValue = this.traverser.getValue();
        } else {
            this.inited = true;
        }
    }

    @Override
    public void close() {
        this.tree.cursorClosed(this);
    }

    @Override
    @Nullable
    protected ByteIterable moveTo(@NotNull ByteIterable key, @Nullable ByteIterable value, boolean rangeSearch) {
        ByteIterable result = super.moveTo(key, value, rangeSearch);
        if (result != null) {
            this.wasDelete = false;
        }
        return result;
    }

    public static void notifyCursors(ITreeMutable tree) {
        Iterable<ITreeCursorMutable> openCursors = tree.getOpenCursors();
        if (openCursors != null) {
            for (ITreeCursorMutable cursor : openCursors) {
                cursor.treeChanged();
            }
        }
    }

    public static void notifyCursors(ITreeMutable tree, ITreeCursorMutable cursorToSkip) {
        Iterable<ITreeCursorMutable> openCursors = tree.getOpenCursors();
        if (openCursors != null) {
            for (ITreeCursorMutable cursor : openCursors) {
                if (cursor == cursorToSkip) continue;
                cursor.treeChanged();
            }
        }
    }
}

