/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.btree;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.tree.ITreeMutable;
import jetbrains.exodus.tree.MutableTreeRoot;
import jetbrains.exodus.tree.TreeCursorMutable;
import jetbrains.exodus.tree.btree.BTreeTraverserDup;
import jetbrains.exodus.tree.btree.BasePage;
import jetbrains.exodus.tree.btree.ILeafNode;
import org.jetbrains.annotations.NotNull;

public class BTreeCursorDupMutable
extends TreeCursorMutable {
    @NotNull
    protected final BTreeTraverserDup traverser;

    public BTreeCursorDupMutable(ITreeMutable tree, BTreeTraverserDup traverser) {
        super(tree, traverser);
        this.traverser = traverser;
    }

    @Override
    public boolean getNextDup() {
        if (this.traverser.node == ILeafNode.EMPTY) {
            if (this.wasDelete) {
                BasePage root = this.traverser.currentNode;
                ByteIterable key = this.nextAfterRemovedKey;
                ByteIterable value = this.nextAfterRemovedValue;
                if (this.getNext()) {
                    if (this.traverser.inDupTree) {
                        return true;
                    }
                    this.reset((MutableTreeRoot)((Object)root));
                    this.wasDelete = true;
                    this.nextAfterRemovedKey = key;
                    this.nextAfterRemovedValue = value;
                }
                return false;
            }
            return this.getNext();
        }
        return this.hasNext() && this.traverser.inDupTree && this.getNext() && this.traverser.inDupTree;
    }

    @Override
    public boolean getNextNoDup() {
        if (this.wasDelete) {
            if (this.getNext()) {
                if (!this.traverser.inDupTree) {
                    return true;
                }
            } else {
                return false;
            }
        }
        if (this.traverser.inDupTree) {
            this.traverser.popUntilDupRight();
            this.canGoDown = false;
        }
        return this.getNext();
    }

    @Override
    public boolean getPrevDup() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getPrevNoDup() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int count() {
        return this.traverser.inDupTree ? (int)this.traverser.currentNode.getTree().size : super.count();
    }
}

