/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.btree;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.CompoundByteIterable;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.Loggable;
import jetbrains.exodus.log.NullLoggable;
import jetbrains.exodus.log.RandomAccessLoggable;
import jetbrains.exodus.log.TooBigLoggableException;
import jetbrains.exodus.tree.btree.BTreeBase;
import jetbrains.exodus.tree.btree.BTreeMutable;
import jetbrains.exodus.tree.btree.BaseLeafNodeMutable;
import jetbrains.exodus.tree.btree.BasePageMutable;
import jetbrains.exodus.tree.btree.DupLeafNodeMutable;
import jetbrains.exodus.tree.btree.LeafNode;
import org.jetbrains.annotations.NotNull;

final class BTreeDupMutable
extends BTreeMutable {
    BTreeMutable mainTree;
    @NotNull
    ByteIterable key;
    long address = -1L;

    BTreeDupMutable(@NotNull BTreeBase dupTree, @NotNull ByteIterable key) {
        super(dupTree);
        this.size = dupTree.size;
        this.key = key;
    }

    @Override
    protected void addExpiredLoggable(@NotNull Loggable loggable) {
        this.mainTree.addExpiredLoggable(loggable);
    }

    @Override
    protected void addExpiredLoggable(long address) {
        this.mainTree.addExpiredLoggable(address);
    }

    @Override
    protected void decrementSize(long delta) {
        super.decrementSize(delta);
        this.mainTree.decrementSize(delta);
    }

    @Override
    protected void incrementSize() {
        super.incrementSize();
        this.mainTree.incrementSize();
    }

    @Override
    public long save() {
        boolean canRetry;
        long result;
        ByteIterable[] iterables;
        ByteIterable sizeIterable;
        if (this.address != -1L) {
            throw new IllegalStateException("Duplicates sub-tree already saved");
        }
        BasePageMutable rootPage = this.getRoot();
        byte type = rootPage.isBottom() ? (byte)7 : 8;
        ByteIterable keyIterable = CompressedUnsignedLongByteIterable.getIterable(this.key.getLength());
        long startAddress = this.log.getHighAddress();
        ByteIterable rootDataIterable = rootPage.getData();
        if (this.log.isLastFileAddress(startAddress)) {
            sizeIterable = CompressedUnsignedLongByteIterable.getIterable(this.size << 1);
            iterables = new ByteIterable[]{keyIterable, this.key, sizeIterable, rootDataIterable};
            result = this.log.tryWrite(type, this.structureId, (ByteIterable)new CompoundByteIterable(iterables));
            if (result >= 0L) {
                this.address = result;
                return result;
            }
            canRetry = false;
        } else {
            canRetry = true;
        }
        if (NullLoggable.isNullLoggable(this.log.read(startAddress))) {
            long lengthBound = this.log.getFileLengthBound();
            startAddress += lengthBound - startAddress % lengthBound;
        }
        sizeIterable = CompressedUnsignedLongByteIterable.getIterable((this.size << 1) + 1L);
        ByteIterable offsetIterable = CompressedUnsignedLongByteIterable.getIterable(this.log.getHighAddress() - startAddress);
        iterables = new ByteIterable[]{keyIterable, this.key, sizeIterable, offsetIterable, rootDataIterable};
        CompoundByteIterable data = new CompoundByteIterable(iterables);
        long l = result = canRetry ? this.log.tryWrite(type, this.structureId, (ByteIterable)data) : this.log.writeContinuously(type, this.structureId, (ByteIterable)data);
        if (result < 0L) {
            if (canRetry) {
                iterables[3] = CompressedUnsignedLongByteIterable.getIterable(this.log.getHighAddress() - startAddress);
                result = this.log.writeContinuously(type, this.structureId, (ByteIterable)new CompoundByteIterable(iterables));
                if (result < 0L) {
                    throw new TooBigLoggableException();
                }
            } else {
                throw new TooBigLoggableException();
            }
        }
        this.address = result;
        return result;
    }

    @Override
    protected byte getBottomPageType() {
        return 9;
    }

    @Override
    protected byte getInternalPageType() {
        return 10;
    }

    @Override
    protected byte getLeafType() {
        return 11;
    }

    @Override
    @NotNull
    protected LeafNode loadLeaf(long address) {
        RandomAccessLoggable loggable = this.getLoggable(address);
        if (loggable.getType() == 11) {
            return new LeafNode(loggable){

                @Override
                @NotNull
                public ByteIterable getValue() {
                    return BTreeDupMutable.this.key;
                }

                @Override
                public boolean isDupLeaf() {
                    return true;
                }

                @Override
                public String toString() {
                    return "DLN {key:" + this.getKey().toString() + "} @ " + this.getAddress();
                }
            };
        }
        throw new IllegalArgumentException("Unexpected loggable type " + loggable.getType() + " at address " + loggable.getAddress());
    }

    @Override
    @NotNull
    protected BaseLeafNodeMutable createMutableLeaf(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        return new DupLeafNodeMutable(key, this);
    }
}

