/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.btree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.CompoundByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.log.ByteIterableWithAddress;
import jetbrains.exodus.log.ByteIteratorWithAddress;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.ExpiredLoggableInfo;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.Loggable;
import jetbrains.exodus.log.RandomAccessLoggable;
import jetbrains.exodus.tree.INode;
import jetbrains.exodus.tree.ITreeCursorMutable;
import jetbrains.exodus.tree.ITreeMutable;
import jetbrains.exodus.tree.TreeCursor;
import jetbrains.exodus.tree.TreeCursorMutable;
import jetbrains.exodus.tree.btree.AddressIterator;
import jetbrains.exodus.tree.btree.BTreeBase;
import jetbrains.exodus.tree.btree.BTreeCursorDupMutable;
import jetbrains.exodus.tree.btree.BTreeReclaimTraverser;
import jetbrains.exodus.tree.btree.BTreeTraverser;
import jetbrains.exodus.tree.btree.BTreeTraverserDup;
import jetbrains.exodus.tree.btree.BaseLeafNodeMutable;
import jetbrains.exodus.tree.btree.BasePageMutable;
import jetbrains.exodus.tree.btree.BottomPage;
import jetbrains.exodus.tree.btree.InternalPage;
import jetbrains.exodus.tree.btree.InternalPageMutable;
import jetbrains.exodus.tree.btree.LeafNode;
import jetbrains.exodus.tree.btree.LeafNodeDup;
import jetbrains.exodus.tree.btree.LeafNodeMutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BTreeMutable
extends BTreeBase
implements ITreeMutable {
    private static final int MAX_EXPIRED_LOGGABLES_TO_CONTINUE_RECLAIM_ON_A_NEW_FILE = 100000;
    @NotNull
    private BasePageMutable root;
    private Collection<ExpiredLoggableInfo> expiredLoggables = null;
    @Nullable
    private List<ITreeCursorMutable> openCursors = null;
    @NotNull
    private final BTreeBase immutableTree;

    BTreeMutable(@NotNull BTreeBase tree) {
        super(tree.log, tree.balancePolicy, tree.allowsDuplicates, tree.structureId);
        this.immutableTree = tree;
        this.root = tree.getRoot().getMutableCopy(this);
        this.size = tree.getSize();
    }

    @Override
    public long getRootAddress() {
        return -1L;
    }

    @Override
    @NotNull
    public BasePageMutable getRoot() {
        return this.root;
    }

    @Override
    public boolean isAllowingDuplicates() {
        return this.allowsDuplicates;
    }

    @Override
    @Nullable
    public Iterable<ITreeCursorMutable> getOpenCursors() {
        return this.openCursors;
    }

    @Override
    public AddressIterator addressIterator() {
        return this.immutableTree.addressIterator();
    }

    @Override
    @NotNull
    public BTreeMutable getMutableCopy() {
        return this;
    }

    @Override
    public void put(@NotNull INode ln) {
        ByteIterable value = ln.getValue();
        if (value == null) {
            throw new ExodusException("Value can't be null");
        }
        this.put(ln.getKey(), value);
    }

    @Override
    public void putRight(@NotNull INode ln) {
        ByteIterable value = ln.getValue();
        if (value == null) {
            throw new ExodusException("Value can't be null");
        }
        this.putRight(ln.getKey(), value);
    }

    @Override
    public boolean add(@NotNull INode ln) {
        ByteIterable value = ln.getValue();
        if (value == null) {
            throw new ExodusException("Value can't be null");
        }
        return this.add(ln.getKey(), value);
    }

    @Override
    public boolean put(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        return this.put(key, value, true);
    }

    @Override
    public void putRight(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        BasePageMutable newSibling = this.root.putRight(key, value);
        if (newSibling != null) {
            this.root = new InternalPageMutable(this, this.root, newSibling);
        }
        TreeCursorMutable.notifyCursors(this);
    }

    @Override
    public boolean add(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        return this.put(key, value, false);
    }

    private boolean put(@NotNull ByteIterable key, @NotNull ByteIterable value, boolean overwrite) {
        boolean[] result = new boolean[]{false};
        BasePageMutable newSibling = this.root.put(key, value, overwrite, result);
        if (newSibling != null) {
            this.root = new InternalPageMutable(this, this.root, newSibling);
        }
        if (result[0]) {
            TreeCursorMutable.notifyCursors(this);
        }
        return result[0];
    }

    @Override
    public boolean delete(@NotNull ByteIterable key) {
        if (this.deleteImpl(key, null)) {
            TreeCursorMutable.notifyCursors(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean delete(@NotNull ByteIterable key, @Nullable ByteIterable value, @Nullable ITreeCursorMutable cursorToSkip) {
        if (this.deleteImpl(key, value)) {
            TreeCursorMutable.notifyCursors(this, cursorToSkip);
            return true;
        }
        return false;
    }

    protected boolean delete(@NotNull ByteIterable key, @Nullable ByteIterable value) {
        if (this.deleteImpl(key, value)) {
            TreeCursorMutable.notifyCursors(this);
            return true;
        }
        return false;
    }

    private boolean deleteImpl(ByteIterable key, @Nullable ByteIterable value) {
        boolean[] res = new boolean[1];
        this.root = BTreeMutable.delete(this.root, key, value, res);
        return res[0];
    }

    protected void decrementSize(long delta) {
        this.size -= delta;
    }

    protected void incrementSize() {
        ++this.size;
    }

    static BasePageMutable delete(BasePageMutable root, ByteIterable key, @Nullable ByteIterable value, boolean[] res) {
        if (root.delete(key, value)) {
            root = root.mergeWithChildren();
            res[0] = true;
            return root;
        }
        res[0] = false;
        return root;
    }

    @Override
    public long save() {
        byte type = this.root.isBottom() ? (byte)2 : 3;
        Log log = this.getLog();
        ByteIterable savedData = this.root.getData();
        ByteIterable[] iterables = new ByteIterable[]{CompressedUnsignedLongByteIterable.getIterable(this.size), savedData};
        return log.write(type, this.structureId, (ByteIterable)new CompoundByteIterable(iterables));
    }

    protected void addExpiredLoggable(@NotNull Loggable loggable) {
        this.getExpiredLoggables().add(new ExpiredLoggableInfo(loggable));
    }

    protected void addExpiredLoggable(long address) {
        if (address != -1L) {
            this.addExpiredLoggable(this.getLoggable(address));
        }
    }

    @Override
    @NotNull
    public Collection<ExpiredLoggableInfo> getExpiredLoggables() {
        if (this.expiredLoggables == null) {
            this.expiredLoggables = new ArrayList<ExpiredLoggableInfo>(16);
        }
        return this.expiredLoggables;
    }

    @Override
    public TreeCursor openCursor() {
        List<ITreeCursorMutable> cursors;
        if (this.openCursors == null) {
            this.openCursors = cursors = new ArrayList<ITreeCursorMutable>(4);
        } else {
            cursors = this.openCursors;
        }
        TreeCursorMutable result = this.allowsDuplicates ? new BTreeCursorDupMutable((ITreeMutable)this, new BTreeTraverserDup(this.root)) : new TreeCursorMutable(this, new BTreeTraverser(this.root));
        cursors.add(result);
        return result;
    }

    @Override
    public void cursorClosed(@NotNull ITreeCursorMutable cursor) {
        this.openCursors.remove(cursor);
    }

    protected byte getBottomPageType() {
        return 4;
    }

    protected byte getInternalPageType() {
        return 5;
    }

    protected byte getLeafType() {
        return 6;
    }

    @NotNull
    protected BaseLeafNodeMutable createMutableLeaf(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        return new LeafNodeMutable(key, value);
    }

    @Override
    public boolean reclaim(@NotNull RandomAccessLoggable loggable, @NotNull Iterator<RandomAccessLoggable> loggables) {
        BTreeReclaimTraverser context = new BTreeReclaimTraverser(this);
        block9: while (true) {
            byte type = loggable.getType();
            switch (type) {
                case 0: {
                    break;
                }
                case 7: 
                case 8: {
                    context.dupLeafsLo.clear();
                    context.dupLeafsHi.clear();
                    new LeafNodeDup(this, loggable).reclaim(context);
                    break;
                }
                case 6: {
                    new LeafNode(loggable).reclaim(context);
                    break;
                }
                case 2: 
                case 3: {
                    if (loggable.getAddress() != this.immutableTree.getRootAddress()) break block9;
                    context.wasReclaim = true;
                    break block9;
                }
                case 4: {
                    this.reclaimBottom(loggable, context);
                    break;
                }
                case 5: {
                    this.reclaimInternal(loggable, context);
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    context.dupLeafsLo.clear();
                    context.dupLeafsHi.clear();
                    RandomAccessLoggable leaf = LeafNodeDup.collect(context.dupLeafsHi, loggable, loggables);
                    if (leaf == null) break block9;
                    new LeafNodeDup(this, leaf).reclaim(context);
                    break;
                }
                default: {
                    throw new ExodusException("Unexpected loggable type " + type);
                }
            }
            if (!loggables.hasNext() || type == 0 && this.expiredLoggables != null && this.expiredLoggables.size() > 100000) break;
            loggable = loggables.next();
        }
        while (context.canMoveUp()) {
            context.popAndMutate();
        }
        return context.wasReclaim;
    }

    void reclaimInternal(RandomAccessLoggable loggable, BTreeReclaimTraverser context) {
        LeafNode minKey;
        ByteIterableWithAddress data = loggable.getData();
        ByteIteratorWithAddress it = data.iterator();
        int i = CompressedUnsignedLongByteIterable.getInt(it);
        if ((i & 1) == 1 && i > 1 && (minKey = this.loadMinKey(data.iterator(CompressedUnsignedLongByteIterable.getCompressedSize(i)))) != null) {
            InternalPage page = new InternalPage(this, data.clone((int)(it.getAddress() - data.getDataAddress())), i >> 1);
            page.reclaim(minKey.getKey(), context);
        }
    }

    void reclaimBottom(RandomAccessLoggable loggable, BTreeReclaimTraverser context) {
        LeafNode minKey;
        ByteIterableWithAddress data = loggable.getData();
        ByteIteratorWithAddress it = data.iterator();
        int i = CompressedUnsignedLongByteIterable.getInt(it);
        if ((i & 1) == 1 && i > 1 && (minKey = this.loadMinKey(data.iterator(CompressedUnsignedLongByteIterable.getCompressedSize(i)))) != null) {
            BottomPage page = new BottomPage(this, data.clone((int)(it.getAddress() - data.getDataAddress())), i >> 1);
            page.reclaim(minKey.getKey(), context);
        }
    }

    @Nullable
    private LeafNode loadMinKey(ByteIterator it) {
        byte addressLen = it.next();
        long keyAddress = it.nextLong((int)addressLen);
        return this.log.hasAddress(keyAddress) ? this.loadLeaf(keyAddress) : null;
    }
}

