/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.btree;

import java.util.Iterator;
import java.util.NoSuchElementException;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.tree.INode;
import jetbrains.exodus.tree.MutableTreeRoot;
import jetbrains.exodus.tree.TreeTraverser;
import jetbrains.exodus.tree.btree.AddressIterator;
import jetbrains.exodus.tree.btree.BTreeBase;
import jetbrains.exodus.tree.btree.BTreeTraverserDup;
import jetbrains.exodus.tree.btree.BaseLeafNode;
import jetbrains.exodus.tree.btree.BasePage;
import jetbrains.exodus.tree.btree.ILeafNode;
import jetbrains.exodus.tree.btree.LeafNodeKV;
import jetbrains.exodus.tree.btree.SearchRes;
import jetbrains.exodus.tree.btree.TreePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BTreeTraverser
implements TreeTraverser {
    @NotNull
    protected TreePos[] stack = new TreePos[8];
    protected int top = 0;
    protected BasePage currentNode;
    protected ILeafNode node = ILeafNode.EMPTY;
    protected int currentPos;

    BTreeTraverser(@NotNull BasePage currentNode) {
        this.currentNode = currentNode;
    }

    private BTreeTraverser(@NotNull BTreeTraverser source) {
        this.stack = source.stack;
        this.currentNode = source.currentNode;
        this.currentPos = source.currentPos;
    }

    @Override
    public void init(boolean left) {
        int size = this.currentNode.size;
        int n = this.currentPos = left ? 0 : size - 1;
        if (!this.canMoveDown()) {
            this.currentPos = left ? -1 : size;
        }
    }

    @Override
    public boolean isNotEmpty() {
        return this.currentNode.size > 0;
    }

    @Override
    @NotNull
    public ByteIterable getKey() {
        return this.node.getKey();
    }

    @Override
    @NotNull
    public ByteIterable getValue() {
        ByteIterable result = this.node.getValue();
        if (result == null) {
            throw new NullPointerException();
        }
        return result;
    }

    @Override
    public boolean hasValue() {
        return this.node.hasValue();
    }

    @Override
    @NotNull
    public INode moveDown() {
        this.node = this.pushChild(new TreePos(this.currentNode, this.currentPos), this.getChildForMoveDown(), 0);
        return this.node;
    }

    @Override
    @NotNull
    public INode moveDownToLast() {
        BasePage child = this.getChildForMoveDown();
        this.node = this.pushChild(new TreePos(this.currentNode, this.currentPos), child, child.size - 1);
        return this.node;
    }

    protected BasePage getChildForMoveDown() {
        return this.currentNode.getChild(this.currentPos);
    }

    protected ILeafNode pushChild(@NotNull TreePos topPos, @NotNull BasePage child, int pos) {
        this.setAt(this.top, topPos);
        this.currentNode = child;
        this.currentPos = pos;
        ++this.top;
        if (child.isBottom()) {
            return this.handleLeaf(child.getKey(pos));
        }
        return ILeafNode.EMPTY;
    }

    protected ILeafNode handleLeaf(BaseLeafNode leaf) {
        return leaf;
    }

    protected void setAt(int pos, @NotNull TreePos treePos) {
        int length = this.stack.length;
        if (pos >= length) {
            int newCapacity = length << 1;
            TreePos[] newStack = new TreePos[newCapacity];
            System.arraycopy(this.stack, 0, newStack, 0, length);
            this.stack = newStack;
        }
        this.stack[pos] = treePos;
    }

    @Override
    public void moveUp() {
        --this.top;
        TreePos topPos = this.stack[this.top];
        this.currentNode = topPos.node;
        this.currentPos = topPos.pos;
        this.node = ILeafNode.EMPTY;
        this.stack[this.top] = null;
    }

    SearchRes getNextSibling(ByteIterable key) {
        return this.currentNode.binarySearch(key, this.currentPos);
    }

    @Override
    public int compareCurrent(@NotNull ByteIterable key) {
        return this.currentNode.getKey(this.currentPos).compareKeyTo(key);
    }

    public void moveTo(int index) {
        this.currentPos = index;
    }

    public boolean canMoveTo(int index) {
        return index < this.currentNode.size;
    }

    @Override
    public boolean canMoveRight() {
        return this.currentPos + 1 < this.currentNode.size;
    }

    @Override
    @NotNull
    public INode moveRight() {
        ++this.currentPos;
        if (this.currentNode.isBottom()) {
            this.node = this.handleLeafR(this.currentNode.getKey(this.currentPos));
            return this.node;
        }
        this.node = ILeafNode.EMPTY;
        return this.node;
    }

    protected ILeafNode handleLeafR(BaseLeafNode leaf) {
        return leaf;
    }

    protected ILeafNode handleLeafL(BaseLeafNode leaf) {
        return leaf;
    }

    @Override
    public boolean canMoveLeft() {
        return this.currentPos > 0;
    }

    @Override
    @NotNull
    public INode moveLeft() {
        --this.currentPos;
        if (this.currentNode.isBottom()) {
            this.node = this.handleLeafL(this.currentNode.getKey(this.currentPos));
            return this.node;
        }
        this.node = ILeafNode.EMPTY;
        return this.node;
    }

    @Override
    public long getCurrentAddress() {
        return this.currentNode.getChildAddress(this.currentPos);
    }

    @Override
    public boolean canMoveUp() {
        return this.top != 0;
    }

    @Override
    public boolean canMoveDown() {
        return !this.currentNode.isBottom();
    }

    @Override
    public void reset(@NotNull MutableTreeRoot root) {
        this.top = 0;
        this.node = ILeafNode.EMPTY;
        this.currentNode = (BasePage)((Object)root);
        this.currentPos = 0;
    }

    @Override
    public boolean moveTo(ByteIterable key, @Nullable ByteIterable value) {
        return this.doMoveTo(key, value, false);
    }

    @Override
    public boolean moveToRange(ByteIterable key, @Nullable ByteIterable value) {
        return this.doMoveTo(key, value, true);
    }

    private boolean doMoveTo(@NotNull ByteIterable key, @Nullable ByteIterable value, boolean rangeSearch) {
        BasePage bottomNode = this.top == 0 ? this.currentNode : this.stack[0].node;
        ILeafNode result = bottomNode.find(this, 0, key, value, rangeSearch);
        if (result == null) {
            return false;
        }
        this.node = result.isDupLeaf() ? new LeafNodeKV(result.getValue(), result.getKey()) : result;
        return true;
    }

    @Override
    @NotNull
    public BTreeBase getTree() {
        return (this.top == 0 ? this.currentNode : this.stack[0].node).getTree();
    }

    protected boolean isDup() {
        return false;
    }

    PageIterator iterator() {
        return new PageIterator(){
            int index = 0;
            int currentIteratorPos = 0;
            BasePage currentIteratorNode = null;

            @Override
            public int getPos() {
                return this.currentIteratorPos;
            }

            @Override
            public boolean hasNext() {
                return this.index <= BTreeTraverser.this.top;
            }

            @Override
            public BasePage next() {
                BasePage next;
                if (this.index < BTreeTraverser.this.top) {
                    TreePos treePos = BTreeTraverser.this.stack[this.index];
                    next = treePos.node;
                    this.currentIteratorPos = treePos.pos;
                } else {
                    if (this.index > BTreeTraverser.this.top) {
                        throw new NoSuchElementException("No more pages in stack");
                    }
                    next = BTreeTraverser.this.currentNode;
                    this.currentIteratorPos = BTreeTraverser.this.currentPos;
                }
                this.currentIteratorNode = next;
                ++this.index;
                return next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static boolean isInDupMode(@NotNull AddressIterator addressIterator) {
        return addressIterator.hasNext() && ((BTreeTraverserDup)addressIterator.getTraverser()).inDupTree;
    }

    static BTreeTraverser getTraverserNoDup(@NotNull AddressIterator addressIterator) {
        return new BTreeTraverser((BTreeTraverser)addressIterator.getTraverser());
    }

    static interface PageIterator
    extends Iterator<BasePage> {
        public int getPos();
    }
}

