/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.btree;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.core.dataStructures.LongObjectCacheBase;
import jetbrains.exodus.log.ByteIterableWithAddress;
import jetbrains.exodus.log.ByteIteratorWithAddress;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.IByteIterableComparator;
import jetbrains.exodus.tree.btree.BTreeBase;
import jetbrains.exodus.tree.btree.BTreeReclaimTraverser;
import jetbrains.exodus.tree.btree.BaseLeafNode;
import jetbrains.exodus.tree.btree.BasePage;
import jetbrains.exodus.tree.btree.BasePageMutable;
import jetbrains.exodus.tree.btree.SearchRes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BasePageImmutable
extends BasePage {
    @NotNull
    protected final ByteIterableWithAddress data;
    private long dataAddress;
    byte keyAddressLen;

    BasePageImmutable(@NotNull BTreeBase tree) {
        super(tree);
        this.data = ByteIterableWithAddress.EMPTY;
        this.size = 0;
        this.dataAddress = -1L;
    }

    BasePageImmutable(@NotNull BTreeBase tree, @NotNull ByteIterableWithAddress data) {
        super(tree);
        this.data = data;
        ByteIteratorWithAddress it = data.iterator();
        this.size = CompressedUnsignedLongByteIterable.getInt(it) >> 1;
        this.init(it);
    }

    BasePageImmutable(@NotNull BTreeBase tree, @NotNull ByteIterableWithAddress data, int size) {
        super(tree);
        this.data = data;
        this.size = size;
        this.init(data.iterator());
    }

    private void init(@NotNull ByteIteratorWithAddress itr) {
        if (this.size > 0) {
            byte next = itr.next();
            this.dataAddress = itr.getAddress();
            this.loadAddressLengths(next);
        } else {
            this.dataAddress = itr.getAddress();
        }
    }

    @Override
    protected long getDataAddress() {
        return this.dataAddress;
    }

    ByteIterator getDataIterator(int offset) {
        return this.dataAddress == -1L ? ByteIterable.EMPTY_ITERATOR : this.data.iterator((int)(this.dataAddress - this.data.getDataAddress() + (long)offset));
    }

    protected void loadAddressLengths(int length) {
        this.keyAddressLen = (byte)length;
        BasePageImmutable.checkAddressLength(this.keyAddressLen);
    }

    static void checkAddressLength(byte addressLen) {
        if (addressLen < 0 || addressLen > 8) {
            throw new ExodusException("Invalid length of address: " + addressLen);
        }
    }

    @Override
    protected long getKeyAddress(int index) {
        return this.getDataIterator(index * this.keyAddressLen).nextLong((int)this.keyAddressLen);
    }

    @Override
    @NotNull
    public BaseLeafNode getKey(int index) {
        return this.getTree().loadLeaf(this.getKeyAddress(index), this.getTreeNodesCache());
    }

    @Override
    protected boolean isMutable() {
        return false;
    }

    @Override
    protected SearchRes binarySearch(ByteIterable key) {
        return this.binarySearch(key, 0);
    }

    @Override
    protected SearchRes binarySearch(ByteIterable key, int low) {
        if (this.dataAddress == -1L) {
            return SearchRes.NOT_FOUND;
        }
        final LongObjectCacheBase treeNodesCache = this.getTreeNodesCache();
        final SearchRes result = new SearchRes();
        result.index = (short)ByteIterableWithAddress.binarySearch(new IByteIterableComparator(){

            @Override
            public int compare(long leftAddress, @NotNull ByteIterable right) {
                result.key = BasePageImmutable.this.getTree().loadLeaf(leftAddress, treeNodesCache);
                return result.key.compareKeyTo(right);
            }
        }, key, low, this.size - 1, this.keyAddressLen, this.getTree().log, this.dataAddress);
        if (result.index < 0) {
            result.key = null;
        }
        return result;
    }

    @Nullable
    protected LongObjectCacheBase getTreeNodesCache() {
        return null;
    }

    static void doReclaim(BTreeReclaimTraverser context) {
        BasePageMutable node = context.currentNode.getMutableCopy(context.mainTree);
        context.wasReclaim = true;
        context.setPage(node);
        context.popAndMutate();
    }
}

