/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.btree;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.log.ByteIterableWithAddress;
import jetbrains.exodus.log.ByteIteratorWithAddress;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.RandomAccessLoggable;
import jetbrains.exodus.tree.btree.BTreeMutable;
import jetbrains.exodus.tree.btree.BTreeReclaimTraverser;
import jetbrains.exodus.tree.btree.BaseLeafNode;
import jetbrains.exodus.tree.btree.BasePageMutable;
import org.jetbrains.annotations.NotNull;

class LeafNode
extends BaseLeafNode {
    @NotNull
    private final RandomAccessLoggable loggable;
    private final int keyLength;
    private final int valueLength;

    LeafNode(@NotNull RandomAccessLoggable loggable) {
        this.loggable = loggable;
        ByteIterableWithAddress data = loggable.getData();
        ByteIteratorWithAddress iterator = data.iterator();
        int keyLength = CompressedUnsignedLongByteIterable.getInt(iterator);
        long dataAddress = iterator.getAddress();
        byte keyRecordSize = (byte)(dataAddress - data.getDataAddress());
        this.valueLength = loggable.getDataLength() - keyRecordSize - keyLength;
        this.keyLength = (keyLength << 3) + keyRecordSize;
    }

    @Override
    public long getAddress() {
        return this.loggable.getAddress();
    }

    public int getType() {
        return this.loggable.getType();
    }

    @Override
    public int compareKeyTo(@NotNull ByteIterable iterable) {
        return this.loggable.getData().compareTo(this.getKeyRecordSize(), this.getKeyLength(), iterable);
    }

    @Override
    public int compareValueTo(@NotNull ByteIterable iterable) {
        return this.loggable.getData().compareTo(this.getKeyRecordSize() + this.getKeyLength(), this.valueLength, iterable);
    }

    @Override
    @NotNull
    public ByteIterable getKey() {
        return this.loggable.getData().subIterable(this.getKeyRecordSize(), this.getKeyLength());
    }

    @Override
    @NotNull
    public ByteIterable getValue() {
        return this.getRawValue().subIterable(0, this.valueLength);
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @NotNull
    ByteIterableWithAddress getRawValue() {
        return this.loggable.getData().clone(this.getKeyRecordSize() + this.getKeyLength());
    }

    private int getKeyLength() {
        return this.keyLength >>> 3;
    }

    private int getKeyRecordSize() {
        return this.keyLength & 7;
    }

    protected void doReclaim(@NotNull BTreeReclaimTraverser context, int leafIndex) {
        long keyAddress = context.currentNode.getKeyAddress(leafIndex);
        if (keyAddress == this.loggable.getAddress()) {
            BTreeMutable tree = context.mainTree;
            tree.addExpiredLoggable(keyAddress);
            BasePageMutable node = context.currentNode.getMutableCopy(tree);
            node.set(leafIndex, tree.createMutableLeaf(this.getKey(), this.getValue()), null);
            context.wasReclaim = true;
            context.setPage(node);
        }
    }

    protected void reclaim(@NotNull BTreeReclaimTraverser context) {
        int index;
        int leafIndex;
        ByteIterable keyIterable;
        block13: {
            keyIterable = this.getKey();
            if (!context.canMoveDown() && context.canMoveRight()) {
                int cmp = context.compareCurrent(keyIterable);
                if (cmp > 0) {
                    return;
                }
                if (cmp == 0) {
                    leafIndex = context.currentPos;
                } else {
                    context.moveRight();
                    leafIndex = context.getNextSibling((ByteIterable)keyIterable).index;
                }
                if (leafIndex >= 0) {
                    this.doReclaim(context, leafIndex);
                    context.moveTo(leafIndex + 1);
                    return;
                }
                if (context.canMoveTo(-leafIndex - 1)) {
                    return;
                }
            }
            if (context.canMoveUp()) {
                block12: {
                    do {
                        context.popAndMutate();
                        context.moveRight();
                        index = context.getNextSibling((ByteIterable)keyIterable).index;
                        if (index >= 0) break block12;
                    } while (!context.canMoveTo(-index - 1) && context.canMoveUp());
                    context.moveTo(Math.max(-index - 2, 0));
                    break block13;
                }
                context.pushChild(index);
            }
        }
        while (context.canMoveDown()) {
            index = context.getNextSibling((ByteIterable)keyIterable).index;
            if (index < 0) {
                index = Math.max(-index - 2, 0);
            }
            context.pushChild(index);
        }
        leafIndex = context.getNextSibling((ByteIterable)keyIterable).index;
        if (leafIndex >= 0) {
            this.doReclaim(context, leafIndex);
            context.moveTo(leafIndex + 1);
        } else {
            context.moveTo(-leafIndex - 1);
        }
    }
}

