/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.patricia;

import java.util.Iterator;
import jetbrains.exodus.tree.patricia.ChildReference;
import jetbrains.exodus.tree.patricia.ChildReferenceMutable;
import org.jetbrains.annotations.NotNull;

final class ChildReferenceSet
implements Iterable<ChildReference> {
    private static final int CAPACITY_THRESHOLD = 2;
    private ChildReference[] refs;
    private int size;

    ChildReferenceSet() {
        this.clear(0);
    }

    void clear(int capacity) {
        this.refs = capacity == 0 ? null : new ChildReference[Math.max(capacity, 2)];
        this.size = 0;
    }

    int size() {
        return this.size;
    }

    void setSize(int size) {
        this.size = size;
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    ChildReference get(byte b) {
        int index = this.searchFor(b);
        return index < 0 ? null : this.refs[index];
    }

    ChildReference getRight() {
        int size = this.size;
        return size > 0 ? this.refs[size - 1] : null;
    }

    int searchFor(byte b) {
        ChildReference[] refs = this.refs;
        int key = b & 0xFF;
        int low = 0;
        int high = this.size - 1;
        while (low <= high) {
            int cmp;
            int mid = low + high + 1 >>> 1;
            ChildReference midRef = refs[mid];
            int n = cmp = midRef == null ? 1 : (midRef.firstByte & 0xFF) - key;
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low - 1;
    }

    ChildReference referenceAt(int index) {
        return this.refs[index];
    }

    void putRight(@NotNull ChildReference ref) {
        int size = this.size;
        this.ensureCapacity(size + 1, size);
        this.refs[size] = ref;
        this.size = size + 1;
    }

    void insertAt(int index, @NotNull ChildReferenceMutable ref) {
        int size = this.size + 1;
        this.ensureCapacity(size, index);
        this.refs[index] = ref;
        this.size = size;
    }

    void setAt(int index, @NotNull ChildReference ref) {
        this.refs[index] = ref;
    }

    boolean remove(byte b) {
        int index = this.searchFor(b);
        if (index < 0) {
            return false;
        }
        int size = this.size;
        if (size == 1) {
            this.refs = null;
        } else {
            ChildReference[] refs = this.refs;
            int refsToCopy = size - index - 1;
            if (refsToCopy > 0) {
                System.arraycopy(refs, index + 1, refs, index, refsToCopy);
            }
            refs[index + refsToCopy] = null;
        }
        this.size = size - 1;
        return true;
    }

    public ChildReferenceIterator iterator() {
        return this.iterator(0);
    }

    ChildReferenceIterator iterator(int index) {
        return new ChildReferenceIterator(this, index);
    }

    private void ensureCapacity(int capacity, int insertPos) {
        ChildReference[] refs = this.refs;
        if (refs == null) {
            this.refs = new ChildReference[Math.max(capacity, 2)];
        } else {
            int length = refs.length;
            if (length >= capacity) {
                if (insertPos < length - 1) {
                    System.arraycopy(refs, insertPos, refs, insertPos + 1, length - insertPos - 1);
                }
            } else {
                this.refs = new ChildReference[Math.max(length + 2, capacity)];
                System.arraycopy(refs, 0, this.refs, 0, insertPos);
                System.arraycopy(refs, insertPos, this.refs, insertPos + 1, length - insertPos);
            }
        }
    }

    static final class ChildReferenceIterator
    implements Iterator<ChildReference> {
        private final ChildReference[] refs;
        private final int size;
        private int index;

        ChildReferenceIterator(ChildReferenceSet set, int index) {
            this.refs = set.refs;
            this.size = set.size;
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public ChildReference next() {
            ChildReference ref;
            do {
                if (this.index >= this.size) {
                    return null;
                }
                ref = this.refs[this.index];
                ++this.index;
            } while (ref == null);
            return ref;
        }

        public boolean hasPrev() {
            return this.index > 0;
        }

        public ChildReference prev() {
            ChildReference ref;
            do {
                if (this.index <= 0) {
                    return null;
                }
                --this.index;
            } while ((ref = this.refs[this.index]) == null);
            return ref;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        int getIndex() {
            return this.index;
        }
    }
}

