/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.patricia;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.log.ByteIterableWithAddress;
import jetbrains.exodus.log.ByteIteratorWithAddress;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.tree.patricia.ChildReference;
import jetbrains.exodus.tree.patricia.MutableNode;
import jetbrains.exodus.tree.patricia.NodeBase;
import jetbrains.exodus.tree.patricia.NodeChildren;
import jetbrains.exodus.tree.patricia.NodeChildrenIterator;
import jetbrains.exodus.tree.patricia.PatriciaTreeBase;
import jetbrains.exodus.tree.patricia.PatriciaTreeMutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ImmutableNode
extends NodeBase {
    private static final int CHILDREN_COUNT_TO_TRIGGER_BINARY_SEARCH = 8;
    private static final int LAZY_KEY_VALUE_ITERABLE_MIN_LENGTH = 16;
    private final long address;
    private final byte type;
    @NotNull
    private final ByteIterableWithAddress data;
    private final int dataOffset;
    private final short childrenCount;
    private final byte childAddressLength;

    ImmutableNode(long address, byte type, @NotNull ByteIterableWithAddress data) {
        this(address, type, data, data.iterator());
    }

    private ImmutableNode(long address, byte type, @NotNull ByteIterableWithAddress data, @NotNull ByteIteratorWithAddress it) {
        super(ImmutableNode.extractKey(type, data, it), ImmutableNode.extractValue(type, data, it));
        this.address = address;
        this.type = type;
        this.data = data;
        if (PatriciaTreeBase.nodeHasChildren(type)) {
            int i = CompressedUnsignedLongByteIterable.getInt(it);
            this.childrenCount = (short)(i >> 3);
            this.childAddressLength = (byte)((i & 7) + 1);
            ImmutableNode.checkAddressLength(this.childAddressLength);
        } else {
            this.childrenCount = 0;
            this.childAddressLength = 0;
        }
        this.dataOffset = (int)(it.getAddress() - data.getDataAddress());
    }

    ImmutableNode() {
        super(ByteIterable.EMPTY, null);
        this.address = -1L;
        this.type = (byte)12;
        this.data = ByteIterableWithAddress.EMPTY;
        this.dataOffset = 0;
        this.childrenCount = 0;
        this.childAddressLength = 0;
    }

    @Override
    long getAddress() {
        return this.address;
    }

    @Override
    boolean isMutable() {
        return false;
    }

    @Override
    MutableNode getMutableCopy(@NotNull PatriciaTreeMutable mutableTree) {
        return mutableTree.mutateNode(this);
    }

    @Override
    @Nullable
    NodeBase getChild(@NotNull PatriciaTreeBase tree, byte b) {
        int key = b & 0xFF;
        if (this.childrenCount < 8) {
            int cmp;
            ByteIterator it = this.getDataIterator(0);
            for (int i = 0; i < this.childrenCount && (cmp = (it.next() & 0xFF) - key) <= 0; ++i) {
                if (cmp == 0) {
                    long nodeAddress = it.nextLong((int)this.childAddressLength);
                    return PatriciaTreeBase.nodeIsRoot(this.type) ? tree.loadNode(nodeAddress) : tree.loadNonCachedNode(nodeAddress);
                }
                it.skip((long)this.childAddressLength);
            }
        } else {
            int childRecordLength = this.childAddressLength + 1;
            int low = 0;
            int high = this.childrenCount - 1;
            while (low <= high) {
                int mid = low + high + 1 >>> 1;
                ByteIterator it = this.getDataIterator(mid * childRecordLength);
                int cmp = (it.next() & 0xFF) - key;
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                long nodeAddress = it.nextLong((int)this.childAddressLength);
                return PatriciaTreeBase.nodeIsRoot(this.type) ? tree.loadNode(nodeAddress) : tree.loadNonCachedNode(nodeAddress);
            }
        }
        return null;
    }

    @Override
    @NotNull
    NodeChildren getChildren() {
        return new NodeChildren(){

            @Override
            public NodeChildrenIterator iterator() {
                return ImmutableNode.this.childrenCount == 0 ? new NodeBase.EmptyNodeChildrenIterator(ImmutableNode.this) : new ImmutableNodeChildrenIterator(ImmutableNode.this.getDataIterator(0), 0, null);
            }
        };
    }

    @Override
    @NotNull
    NodeChildrenIterator getChildren(byte b) {
        int key = b & 0xFF;
        if (this.childrenCount < 8) {
            int cmp;
            ByteIterator it = this.getDataIterator(0);
            for (int i = 0; i < this.childrenCount && (cmp = (it.next() & 0xFF) - key) <= 0; ++i) {
                if (cmp == 0) {
                    long suffixAddress = it.nextLong((int)this.childAddressLength);
                    return new ImmutableNodeChildrenIterator(it, i + 1, new ChildReference(b, suffixAddress));
                }
                it.skip((long)this.childAddressLength);
            }
        } else {
            int childRecordLength = this.childAddressLength + 1;
            int low = 0;
            int high = this.childrenCount - 1;
            while (low <= high) {
                int mid = low + high + 1 >>> 1;
                ByteIterator it = this.getDataIterator(mid * childRecordLength);
                int cmp = (it.next() & 0xFF) - key;
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                long suffixAddress = it.nextLong((int)this.childAddressLength);
                return new ImmutableNodeChildrenIterator(it, mid + 1, new ChildReference(b, suffixAddress));
            }
        }
        return new NodeBase.EmptyNodeChildrenIterator(this);
    }

    @Override
    @NotNull
    NodeChildrenIterator getChildrenRange(byte b) {
        int key = b & 0xFF;
        if (this.childrenCount < 8) {
            ByteIterator it = this.getDataIterator(0);
            for (int i = 0; i < this.childrenCount; ++i) {
                byte actual = it.next();
                int cmp = (actual & 0xFF) - key;
                if (cmp > 0) {
                    long suffixAddress = it.nextLong((int)this.childAddressLength);
                    return new ImmutableNodeChildrenIterator(it, i + 1, new ChildReference(actual, suffixAddress));
                }
                it.skip((long)this.childAddressLength);
            }
        } else {
            int childRecordLength = this.childAddressLength + 1;
            int low = -1;
            int high = this.childrenCount;
            ByteIterator result = null;
            byte resultByte = 0;
            while (high - low > 1) {
                int mid = low + high + 1 >>> 1;
                ByteIterator it = this.getDataIterator(mid * childRecordLength);
                byte actual = it.next();
                int cmp = (actual & 0xFF) - key;
                if (cmp > 0) {
                    result = it;
                    resultByte = actual;
                    high = mid;
                    continue;
                }
                low = mid;
            }
            if (result != null) {
                long suffixAddress = result.nextLong((int)this.childAddressLength);
                return new ImmutableNodeChildrenIterator(result, high + 1, new ChildReference(resultByte, suffixAddress));
            }
        }
        return new NodeBase.EmptyNodeChildrenIterator(this);
    }

    @Override
    int getChildrenCount() {
        return this.childrenCount;
    }

    @Override
    @NotNull
    NodeChildrenIterator getChildrenLast() {
        return new ImmutableNodeChildrenIterator(null, this.childrenCount, null);
    }

    private ByteIterator getDataIterator(int offset) {
        return this.address == -1L ? ByteIterable.EMPTY_ITERATOR : this.data.iterator(this.dataOffset + offset);
    }

    @NotNull
    private static ByteIterable extractKey(byte type, @NotNull ByteIterableWithAddress data, @NotNull ByteIteratorWithAddress it) {
        if (!PatriciaTreeBase.nodeHasKey(type)) {
            return ByteIterable.EMPTY;
        }
        return ImmutableNode.extractLazyIterable(data, it);
    }

    @Nullable
    private static ByteIterable extractValue(byte type, @NotNull ByteIterableWithAddress data, @NotNull ByteIteratorWithAddress it) {
        if (!PatriciaTreeBase.nodeHasValue(type)) {
            return null;
        }
        return ImmutableNode.extractLazyIterable(data, it);
    }

    private static ByteIterable extractLazyIterable(@NotNull ByteIterableWithAddress data, @NotNull ByteIteratorWithAddress it) {
        int length = CompressedUnsignedLongByteIterable.getInt(it);
        if (length == 1) {
            return ArrayByteIterable.fromByte((byte)it.next());
        }
        if (length < 16) {
            return new ArrayByteIterable((ByteIterator)it, length);
        }
        ByteIterable result = data.clone((int)(it.getAddress() - data.getDataAddress())).subIterable(0, length);
        it.skip(length);
        return result;
    }

    private static void checkAddressLength(long addressLen) {
        if (addressLen < 0L || addressLen > 8L) {
            throw new ExodusException("Invalid length of address: " + addressLen);
        }
    }

    private final class ImmutableNodeChildrenIterator
    implements NodeChildrenIterator {
        private ByteIterator itr;
        private int index = 0;
        private ChildReference node;

        private ImmutableNodeChildrenIterator(ByteIterator itr, int index, ChildReference node) {
            this.itr = itr;
            this.index = index;
            this.node = node;
        }

        @Override
        public boolean hasNext() {
            return this.index < ImmutableNode.this.childrenCount;
        }

        @Override
        public ChildReference next() {
            ++this.index;
            this.node = new ChildReference(this.itr.next(), this.itr.nextLong((int)ImmutableNode.this.childAddressLength));
            return this.node;
        }

        @Override
        public boolean hasPrev() {
            return this.index > 0;
        }

        @Override
        public ChildReference prev() {
            --this.index;
            this.itr = ImmutableNode.this.getDataIterator(this.index * (ImmutableNode.this.childAddressLength + 1));
            this.node = new ChildReference(this.itr.next(), this.itr.nextLong((int)ImmutableNode.this.childAddressLength));
            return this.node;
        }

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public void nextInPlace() {
            ++this.index;
            ChildReference node = this.node;
            node.firstByte = this.itr.next();
            node.suffixAddress = this.itr.nextLong((int)ImmutableNode.this.childAddressLength);
        }

        @Override
        public void prevInPlace() {
            --this.index;
            ChildReference node = this.node;
            this.itr = ImmutableNode.this.getDataIterator(this.index * (ImmutableNode.this.childAddressLength + 1));
            node.firstByte = this.itr.next();
            node.suffixAddress = this.itr.nextLong((int)ImmutableNode.this.childAddressLength);
        }

        @Override
        public ChildReference getNode() {
            return this.node;
        }

        @Override
        public void remove() {
            throw new ExodusException("Can't remove manually Patricia node child, use Store.delete() instead");
        }

        @Override
        public NodeBase getParentNode() {
            return ImmutableNode.this;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public ByteIterable getKey() {
            return ImmutableNode.this.keySequence;
        }
    }
}

