/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.patricia;

import java.io.PrintStream;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.tree.Dumpable;
import jetbrains.exodus.tree.INode;
import jetbrains.exodus.tree.patricia.ChildReference;
import jetbrains.exodus.tree.patricia.MutableNode;
import jetbrains.exodus.tree.patricia.NodeChildren;
import jetbrains.exodus.tree.patricia.NodeChildrenIterator;
import jetbrains.exodus.tree.patricia.PatriciaTreeBase;
import jetbrains.exodus.tree.patricia.PatriciaTreeMutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class NodeBase
implements INode {
    @NotNull
    protected ByteIterable keySequence;
    @Nullable
    protected ByteIterable value;

    NodeBase(@NotNull ByteIterable keySequence, @Nullable ByteIterable value) {
        this.keySequence = keySequence;
        this.value = value;
    }

    MatchResult matchesKeySequence(@NotNull ByteIterator it) {
        int matchingLength = 0;
        for (byte keyByte : this.keySequence) {
            if (!it.hasNext()) {
                return new MatchResult(-matchingLength - 1, keyByte, false, 0);
            }
            byte nextByte = it.next();
            if (nextByte != keyByte) {
                return new MatchResult(-matchingLength - 1, keyByte, true, nextByte);
            }
            ++matchingLength;
        }
        return new MatchResult(matchingLength);
    }

    boolean hasKey() {
        return this.keySequence != ByteIterable.EMPTY && this.keySequence.getLength() > 0;
    }

    @Override
    @NotNull
    public ByteIterable getKey() {
        return this.keySequence;
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    @Nullable
    public ByteIterable getValue() {
        return this.value;
    }

    @Override
    public void dump(PrintStream out, int level, @Nullable Dumpable.ToString renderer) {
        throw new UnsupportedOperationException();
    }

    abstract long getAddress();

    abstract boolean isMutable();

    abstract MutableNode getMutableCopy(@NotNull PatriciaTreeMutable var1);

    abstract NodeBase getChild(@NotNull PatriciaTreeBase var1, byte var2);

    @NotNull
    abstract NodeChildrenIterator getChildren(byte var1);

    @NotNull
    abstract NodeChildrenIterator getChildrenRange(byte var1);

    @NotNull
    abstract NodeChildrenIterator getChildrenLast();

    @NotNull
    abstract NodeChildren getChildren();

    abstract int getChildrenCount();

    public String toString() {
        return String.format("%s} %s %s", this.keySequence.iterator().hasNext() ? "{key:" + this.keySequence.toString() : Character.valueOf('{'), this.value == null ? "@" : this.value.toString() + " @", this.getAddress());
    }

    static void indent(PrintStream out, int level) {
        for (int i = 0; i < level; ++i) {
            out.print(' ');
        }
    }

    final class EmptyNodeChildrenIterator
    implements NodeChildrenIterator {
        EmptyNodeChildrenIterator() {
        }

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public void nextInPlace() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void prevInPlace() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChildReference getNode() {
            return null;
        }

        @Override
        public NodeBase getParentNode() {
            return NodeBase.this;
        }

        @Override
        public int getIndex() {
            return 0;
        }

        @Override
        public ByteIterable getKey() {
            return ByteIterable.EMPTY;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public ChildReference next() {
            return null;
        }

        @Override
        public boolean hasPrev() {
            return false;
        }

        @Override
        public ChildReference prev() {
            return null;
        }

        @Override
        public void remove() {
        }
    }

    static class MatchResult {
        final int matchingLength;
        final byte keyByte;
        final boolean hasNext;
        final byte nextByte;

        MatchResult(int matchingLength) {
            this(matchingLength, 0, false, 0);
        }

        private MatchResult(int matchingLength, byte keyByte, boolean hasNext, byte nextByte) {
            this.matchingLength = matchingLength;
            this.keyByte = keyByte;
            this.hasNext = hasNext;
            this.nextByte = nextByte;
        }
    }
}

