/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.clientcert.dnq.rest;

import com.fasterxml.jackson.databind.JsonNode;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.auth.module.clientcert.api.ClientCertificateUserDetailsImpl;
import jetbrains.jetpass.auth.module.clientcert.dnq.CertificateValidationKt;
import jetbrains.jetpass.auth.module.clientcert.dnq.rest.ClientCertificateAuthModuleRestPlugin;
import jetbrains.jetpass.auth.module.clientcert.dnq.rest.ClientCertificateTestResult;
import jetbrains.jetpass.auth.module.clientcert.dnq.rest.client.api.ClientCertificateAuthModule;
import jetbrains.jetpass.auth.module.clientcert.dnq.ui.ClientCertificateAuthenticationException;
import jetbrains.jetpass.auth.module.clientcert.dnq.ui.ClientCertificateAuthenticationHandler;
import jetbrains.jetpass.auth.module.clientcert.dnq.xd.XdClientCertificateAuthModule;
import jetbrains.jetpass.auth.module.dnq.authentication.certificate.ClientCertificate;
import jetbrains.jetpass.auth.module.dnq.authentication.certificate.X509ClientCertificate;
import jetbrains.jetpass.auth.module.dnq.rest.AuthModuleRestPlugin;
import jetbrains.jetpass.dao.api.DataAccessException;
import jetbrains.jetpass.dao.api.ItemNotFoundException;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import jetbrains.jetpass.dao.dnq.api.JetPassReadOnlyDAO;
import jetbrains.jetpass.dnq.TransactionKt;
import jetbrains.jetpass.rest.api.resource.ResourceUtilKt;
import jetbrains.jetpass.rest.common.ExceptionExtKt;
import jetbrains.jetpass.rest.common.certificates.CertificateUtilsKt;
import jetbrains.jetpass.rest.common.certificates.ClientCertificateInvalidRequestException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J,\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Ljetbrains/jetpass/auth/module/clientcert/dnq/rest/ClientCertificateAuthModuleRestPlugin;", "Ljetbrains/jetpass/auth/module/dnq/rest/AuthModuleRestPlugin;", "Ljetbrains/jetpass/auth/module/clientcert/dnq/rest/client/api/ClientCertificateAuthModule;", "daoContainer", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "(Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;)V", "getDaoContainer", "()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "invoke", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "authModule", "operation", "", "parameter", "Lcom/fasterxml/jackson/databind/JsonNode;", "test", "Ljetbrains/jetpass/auth/module/clientcert/dnq/rest/ClientCertificateTestResult;", "jetbrains.jetpass.auth.module.clientcert.dnq"})
public final class ClientCertificateAuthModuleRestPlugin
extends AuthModuleRestPlugin<ClientCertificateAuthModule> {
    @NotNull
    private final JetPassDAOContainer daoContainer;

    private final ClientCertificateTestResult test(ClientCertificateAuthModule authModule, HttpServletRequest request) {
        return (ClientCertificateTestResult)ResourceUtilKt.daoAction((Function0)((Function0)new Function0<ClientCertificateTestResult>(this, authModule, request){
            final /* synthetic */ ClientCertificateAuthModuleRestPlugin this$0;
            final /* synthetic */ ClientCertificateAuthModule $authModule;
            final /* synthetic */ HttpServletRequest $request;

            @NotNull
            public final ClientCertificateTestResult invoke() {
                Boolean bl = this.$authModule.isDisabled();
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"authModule.isDisabled");
                if (bl.booleanValue()) {
                    throw (Throwable)ClientCertificateInvalidRequestException.Companion.authDisabled();
                }
                List certificateChain = CertificateUtilsKt.extractClientCertificates((HttpServletRequest)this.$request);
                X509Certificate x509Certificate = (X509Certificate)CollectionsKt.firstOrNull((List)certificateChain);
                if (x509Certificate == null) {
                    throw (Throwable)((Object)ClientCertificateAuthenticationException.Companion.certificateMissing());
                }
                X509Certificate certificate = x509Certificate;
                ClientCertificate clientCertificate = (ClientCertificate)new X509ClientCertificate(certificate);
                String string = this.$authModule.getEmailRdn();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"authModule.emailRdn");
                ClientCertificateUserDetailsImpl details = ClientCertificateAuthenticationHandler.Companion.collectDetails(clientCertificate, string);
                return (ClientCertificateTestResult)TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, ClientCertificateTestResult>(this, certificateChain, details){
                    final /* synthetic */ test.1 this$0;
                    final /* synthetic */ List $certificateChain;
                    final /* synthetic */ ClientCertificateUserDetailsImpl $details;

                    @NotNull
                    public final ClientCertificateTestResult invoke(@NotNull TransientStoreSession it) {
                        ClientCertificateTestResult clientCertificateTestResult;
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        XdEntity xdEntity = JetPassReadOnlyDAO.resolve$default((JetPassReadOnlyDAO)this.this$0.this$0.getDaoContainer().getAuthModuleDAO(), (IdItem)((IdItem)this.this$0.$authModule), (boolean)true, (boolean)false, (int)4, null);
                        if (!(xdEntity instanceof XdClientCertificateAuthModule)) {
                            xdEntity = null;
                        }
                        XdClientCertificateAuthModule xdClientCertificateAuthModule = (XdClientCertificateAuthModule)xdEntity;
                        if (xdClientCertificateAuthModule == null) {
                            IdItem item$iv = (IdItem)this.this$0.$authModule;
                            throw (Throwable)new ItemNotFoundException(ClientCertificateAuthModule.class.getSimpleName(), item$iv.getId());
                        }
                        XdClientCertificateAuthModule xdSettings = xdClientCertificateAuthModule;
                        try {
                            CertificateValidationKt.validateX509Chain(xdSettings, this.$certificateChain);
                            clientCertificateTestResult = new ClientCertificateTestResult(this.$details, null);
                        }
                        catch (ClientCertificateAuthenticationException ex) {
                            clientCertificateTestResult = new ClientCertificateTestResult(this.$details, ExceptionExtKt.toJSON((DataAccessException)((DataAccessException)ex)));
                        }
                        return clientCertificateTestResult;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$certificateChain = list;
                        this.$details = clientCertificateUserDetailsImpl;
                        super(1);
                    }
                }), (int)7, null);
            }
            {
                this.this$0 = clientCertificateAuthModuleRestPlugin;
                this.$authModule = clientCertificateAuthModule;
                this.$request = httpServletRequest;
                super(0);
            }
        }));
    }

    @Nullable
    public Object invoke(@NotNull HttpServletRequest request, @NotNull ClientCertificateAuthModule authModule, @NotNull String operation, @Nullable JsonNode parameter) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)authModule, (String)"authModule");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        String string = operation;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        String string3 = string2;
        string = "test";
        String string4 = string3;
        String string5 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
        String string6 = string5;
        if (!Intrinsics.areEqual((Object)string4, (Object)string6)) {
            Void void_ = this.throwOperationNotFound(operation);
            throw null;
        }
        return this.test(authModule, request);
    }

    @NotNull
    public final JetPassDAOContainer getDaoContainer() {
        return this.daoContainer;
    }

    public ClientCertificateAuthModuleRestPlugin(@NotNull JetPassDAOContainer daoContainer) {
        Intrinsics.checkParameterIsNotNull((Object)daoContainer, (String)"daoContainer");
        this.daoContainer = daoContainer;
    }
}

