/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.clientcert.dnq.ui;

import java.util.Map;
import jetbrains.jetpass.auth.module.dnq.authentication.AuthenticationException;
import jetbrains.jetpass.core.security.cert.CertificateValidationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bBA\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007\u0012\u0016\b\u0002\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\f"}, d2={"Ljetbrains/jetpass/auth/module/clientcert/dnq/ui/ClientCertificateAuthenticationException;", "Ljetbrains/jetpass/auth/module/dnq/authentication/AuthenticationException;", "code", "", "message", "cause", "Ljava/lang/Exception;", "Lkotlin/Exception;", "params", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Exception;Ljava/util/Map;)V", "Companion", "jetbrains.jetpass.auth.module.clientcert.dnq"})
public final class ClientCertificateAuthenticationException
extends AuthenticationException {
    @NotNull
    public static final String EMAIL_MISSING_CODE = "hub-auth-cert-email-missing";
    @NotNull
    public static final String DETAILS_DISABLED_CODE = "hub-auth-cert-details-disabled";
    @NotNull
    public static final String CERTIFICATE_MISSING = "hub-auth-cert-missing";
    public static final Companion Companion = new Companion(null);

    private ClientCertificateAuthenticationException(String code, String message, Exception cause, Map<String, String> params) {
        super(code, message, (Throwable)cause, params);
    }

    /* synthetic */ ClientCertificateAuthenticationException(String string, String string2, Exception exception, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            exception = null;
        }
        if ((n & 8) != 0) {
            map = null;
        }
        this(string, string2, exception, map);
    }

    public /* synthetic */ ClientCertificateAuthenticationException(@NotNull String code, @NotNull String message, @Nullable Exception cause, @Nullable Map params, DefaultConstructorMarker $constructor_marker) {
        this(code, message, cause, params);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0004J\u0006\u0010\u000e\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ljetbrains/jetpass/auth/module/clientcert/dnq/ui/ClientCertificateAuthenticationException$Companion;", "", "()V", "CERTIFICATE_MISSING", "", "DETAILS_DISABLED_CODE", "EMAIL_MISSING_CODE", "certificateInvalid", "Ljetbrains/jetpass/auth/module/clientcert/dnq/ui/ClientCertificateAuthenticationException;", "ex", "Ljetbrains/jetpass/core/security/cert/CertificateValidationException;", "certificateMissing", "detailsDisabled", "login", "emailMissing", "jetbrains.jetpass.auth.module.clientcert.dnq"})
    public static final class Companion {
        @NotNull
        public final ClientCertificateAuthenticationException emailMissing() {
            return new ClientCertificateAuthenticationException(ClientCertificateAuthenticationException.EMAIL_MISSING_CODE, "The subject DN in the client certificate does not contain an email address", null, null, 12, null);
        }

        @NotNull
        public final ClientCertificateAuthenticationException detailsDisabled(@NotNull String login) {
            Intrinsics.checkParameterIsNotNull((Object)login, (String)"login");
            return new ClientCertificateAuthenticationException(ClientCertificateAuthenticationException.DETAILS_DISABLED_CODE, "Login with client certificate is disabled for " + login, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"login", (Object)login)), null);
        }

        @NotNull
        public final ClientCertificateAuthenticationException certificateInvalid(@NotNull CertificateValidationException ex) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)ex), (String)"ex");
            String string = ex.getCode();
            String string2 = ex.getMessage();
            if (string2 == null) {
                string2 = "Certificate invalid";
            }
            return new ClientCertificateAuthenticationException(string, string2, (Exception)((Object)ex), ex.getParameters(), null);
        }

        @NotNull
        public final ClientCertificateAuthenticationException certificateMissing() {
            return new ClientCertificateAuthenticationException(ClientCertificateAuthenticationException.CERTIFICATE_MISSING, "Login credentials do not contain certificate data", null, null, 12, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

