/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.clientcert.dnq.ui;

import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.authority.details.UserDetails;
import jetbrains.jetpass.api.authority.profile.EmailContact;
import jetbrains.jetpass.auth.module.clientcert.api.ClientCertificateUserDetailsImpl;
import jetbrains.jetpass.auth.module.clientcert.dnq.CertificateValidationKt;
import jetbrains.jetpass.auth.module.clientcert.dnq.rest.client.api.ClientCertificateUserDetails;
import jetbrains.jetpass.auth.module.clientcert.dnq.ui.ClientCertificateAuthenticationException;
import jetbrains.jetpass.auth.module.clientcert.dnq.xd.XdClientCertificateAuthModule;
import jetbrains.jetpass.auth.module.clientcert.dnq.xd.XdClientCertificateUserDetails;
import jetbrains.jetpass.auth.module.dnq.authentication.AuthenticationHandler;
import jetbrains.jetpass.auth.module.dnq.authentication.CertificateCredentials;
import jetbrains.jetpass.auth.module.dnq.authentication.certificate.ClientCertificate;
import jetbrains.jetpass.auth.module.dnq.authentication.certificate.X509CertificateCredentials;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import jetbrains.jetpass.pojo.api.authority.profile.EmailContactImpl;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUserDetails;
import jetbrains.jetpass.userManagement.persistence.dnq.module.XdAuthModule;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00132\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\r\u001a\u0004\u0018\u00010\u00022\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Ljetbrains/jetpass/auth/module/clientcert/dnq/ui/ClientCertificateAuthenticationHandler;", "Ljetbrains/jetpass/auth/module/dnq/authentication/AuthenticationHandler;", "Ljetbrains/jetpass/api/authority/details/UserDetails;", "Ljetbrains/jetpass/auth/module/dnq/authentication/CertificateCredentials;", "settings", "Ljetbrains/jetpass/auth/module/clientcert/dnq/xd/XdClientCertificateAuthModule;", "daoContainer", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "(Ljetbrains/jetpass/auth/module/clientcert/dnq/xd/XdClientCertificateAuthModule;Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;)V", "getDaoContainer", "()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "getSettings", "()Ljetbrains/jetpass/auth/module/clientcert/dnq/xd/XdClientCertificateAuthModule;", "authenticate", "credentials", "searchByThumbprint", "Ljetbrains/jetpass/auth/module/clientcert/dnq/rest/client/api/ClientCertificateUserDetails;", "thumbprint", "", "Companion", "jetbrains.jetpass.auth.module.clientcert.dnq"})
public final class ClientCertificateAuthenticationHandler
implements AuthenticationHandler<UserDetails, CertificateCredentials<?>> {
    @NotNull
    private final XdClientCertificateAuthModule settings;
    @NotNull
    private final JetPassDAOContainer daoContainer;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public UserDetails authenticate(@NotNull CertificateCredentials<?> credentials) {
        ClientCertificateUserDetailsImpl clientCertificateUserDetailsImpl;
        ClientCertificateUserDetails found;
        Intrinsics.checkParameterIsNotNull(credentials, (String)"credentials");
        Companion.getLogger().info((Function0)new Function0<String>(credentials){
            final /* synthetic */ CertificateCredentials $credentials;

            @NotNull
            public final String invoke() {
                return "Authentication of " + this.$credentials;
            }
            {
                this.$credentials = certificateCredentials;
                super(0);
            }
        });
        ClientCertificate clientCertificate = credentials.getCertificate();
        if (clientCertificate == null) {
            throw (Throwable)((Object)ClientCertificateAuthenticationException.Companion.certificateMissing());
        }
        ClientCertificate certificate = clientCertificate;
        if (credentials instanceof X509CertificateCredentials) {
            CertificateValidationKt.validateX509Credentials(this.settings, (X509CertificateCredentials)credentials);
        }
        if ((found = this.searchByThumbprint(certificate.thumbprint())) != null) {
            Boolean bl = found.isDisabled();
            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"found.isDisabled");
            if (bl.booleanValue()) {
                User user = found.getUser();
                Intrinsics.checkExpressionValueIsNotNull((Object)user, (String)"found.user");
                String string = user.getLogin();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"found.user.login");
                throw (Throwable)((Object)ClientCertificateAuthenticationException.Companion.detailsDisabled(string));
            }
            return (UserDetails)found;
        }
        ClientCertificateUserDetailsImpl $receiver = clientCertificateUserDetailsImpl = Companion.collectDetails(certificate, this.settings.getEmailRdn());
        $receiver.setAuthModule(this.daoContainer.getAuthModuleDAO().wrapEntity((XdAuthModule)this.settings));
        return (UserDetails)clientCertificateUserDetailsImpl;
    }

    private final ClientCertificateUserDetails searchByThumbprint(String thumbprint2) {
        ClientCertificateUserDetails clientCertificateUserDetails;
        XdClientCertificateUserDetails xdClientCertificateUserDetails = (XdClientCertificateUserDetails)XdQueryKt.firstOrNull(XdClientCertificateUserDetails.Companion.find(thumbprint2, true, (XdAuthModule)this.settings));
        if (xdClientCertificateUserDetails != null) {
            XdClientCertificateUserDetails xdClientCertificateUserDetails2;
            XdClientCertificateUserDetails it = xdClientCertificateUserDetails2 = xdClientCertificateUserDetails;
            UserDetails userDetails = this.daoContainer.getUserDetailsDAO().wrapEntity((XdBaseUserDetails)it);
            if (userDetails == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.jetpass.auth.module.clientcert.dnq.rest.client.api.ClientCertificateUserDetails");
            }
            clientCertificateUserDetails = (ClientCertificateUserDetails)userDetails;
        } else {
            clientCertificateUserDetails = null;
        }
        return clientCertificateUserDetails;
    }

    @NotNull
    public final XdClientCertificateAuthModule getSettings() {
        return this.settings;
    }

    @NotNull
    public final JetPassDAOContainer getDaoContainer() {
        return this.daoContainer;
    }

    public ClientCertificateAuthenticationHandler(@NotNull XdClientCertificateAuthModule settings, @NotNull JetPassDAOContainer daoContainer) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)settings), (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)daoContainer, (String)"daoContainer");
        this.settings = settings;
        this.daoContainer = daoContainer;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Ljetbrains/jetpass/auth/module/clientcert/dnq/ui/ClientCertificateAuthenticationHandler$Companion;", "Lmu/KLogging;", "()V", "collectDetails", "Ljetbrains/jetpass/auth/module/clientcert/api/ClientCertificateUserDetailsImpl;", "certificate", "Ljetbrains/jetpass/auth/module/dnq/authentication/certificate/ClientCertificate;", "emailRdn", "", "jetbrains.jetpass.auth.module.clientcert.dnq"})
    public static final class Companion
    extends KLogging {
        @NotNull
        public final ClientCertificateUserDetailsImpl collectDetails(@NotNull ClientCertificate certificate, @NotNull String emailRdn) {
            ClientCertificateUserDetailsImpl clientCertificateUserDetailsImpl;
            Intrinsics.checkParameterIsNotNull((Object)certificate, (String)"certificate");
            Intrinsics.checkParameterIsNotNull((Object)emailRdn, (String)"emailRdn");
            ClientCertificateUserDetailsImpl $receiver = clientCertificateUserDetailsImpl = new ClientCertificateUserDetailsImpl();
            $receiver.setThumbprint(certificate.thumbprint());
            $receiver.setCommonName(CertificateValidationKt.extractCommonName(certificate));
            EmailContactImpl emailContactImpl = new EmailContactImpl();
            ClientCertificateUserDetailsImpl clientCertificateUserDetailsImpl2 = $receiver;
            EmailContactImpl $receiver2 = emailContactImpl;
            $receiver2.setEmail(CertificateValidationKt.extractEmailRequired(certificate, emailRdn));
            $receiver2.setVerified(Boolean.valueOf(true));
            EmailContactImpl emailContactImpl2 = emailContactImpl;
            clientCertificateUserDetailsImpl2.setEmail((EmailContact)emailContactImpl2);
            return clientCertificateUserDetailsImpl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

