/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.core.persistent;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import com.jetbrains.teamsys.dnq.database.IncomingLinkViolation;
import com.jetbrains.teamsys.dnq.database.MessageBuilder;
import java.util.Collection;
import java.util.Comparator;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.LinksEqualDecorator;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.PropertyRange;
import jetbrains.exodus.query.SortByLinkProperty;
import jetbrains.exodus.query.SortByProperty;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.runtime.converter.TypeConvertManager;
import jetbrains.mps.webr.runtime.uri.QueryParameter;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import jetbrains.youtrack.core.persistent.ProjectPinImpl;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.core.security.PermissionAux;
import jetbrains.youtrack.core.security.Security;
import jetbrains.youtrack.textindex.TextIndexOperationsCompat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import webr.framework.url.UrlUtil;

public class ProjectImpl
extends IssueFolderImpl {
    private static String __ENTITY_TYPE__ = "Project";
    public static final Comparator<Entity> COMPARATOR = new Comparator<Entity>(){

        @Override
        public int compare(Entity p1, Entity p2) {
            String p2Name;
            String p1Name = EntityOperations.hasChanges((TransientEntity)((TransientEntity)p1), (String)"name") ? (String)PrimitiveAssociationSemantics.getOldValue((TransientEntity)((TransientEntity)p1), (String)"name", String.class, (Object)IssueFolderImpl.getNullName()) : (String)PrimitiveAssociationSemantics.get((Entity)p1, (String)"name", String.class, (Object)IssueFolderImpl.getNullName());
            String string = p2Name = EntityOperations.hasChanges((TransientEntity)((TransientEntity)p2), (String)"name") ? (String)PrimitiveAssociationSemantics.getOldValue((TransientEntity)((TransientEntity)p2), (String)"name", String.class, (Object)IssueFolderImpl.getNullName()) : (String)PrimitiveAssociationSemantics.get((Entity)p2, (String)"name", String.class, (Object)IssueFolderImpl.getNullName());
            if (p1Name != null && p2Name != null) {
                return p1Name.compareTo(p2Name);
            }
            if (p1Name == null) {
                if (p2Name == null) {
                    return 0;
                }
                return -1;
            }
            return 1;
        }
    };
    private static final Log securityLog = LogFactory.getLog((String)"security");
    public static final String PROJECT_SHORT_NAME_REGEX = "[a-zA-Z0-9_]+";

    @Override
    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String name, String shortName, Entity createdBy, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"name", (Comparable)((Object)name), String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"shortName", (Comparable)((Object)shortName), String.class);
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)"createdBy", (Entity)createdBy);
        securityLog.info((Object)("project " + name + " created"));
        return entity;
    }

    public IncomingLinkViolation createIncomingLinkViolation(String name) {
        String linkName = name;
        if ("createdBy".equals(linkName)) {
            return new IncomingLinkViolation(linkName){

                public Collection<String> getDescription() {
                    return this.createPerInstanceErrorMessage(new MessageBuilder(){

                        public String build(Iterable<Entity> linkedEntities, Entity entity, boolean hasMore) {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ConstraintsErrorMessageUtil.creator_of_project_{project_name}_{project_short_name}", new Object[]{PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, null), PrimitiveAssociationSemantics.get((Entity)entity, (String)"shortName", String.class, null)});
                        }
                    });
                }
            };
        }
        if ("leader".equals(linkName)) {
            return new IncomingLinkViolation(linkName){

                public Collection<String> getDescription() {
                    return this.createPerInstanceErrorMessage(new MessageBuilder(){

                        public String build(Iterable<Entity> linkedEntities, Entity entity, boolean hasMore) {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ConstraintsErrorMessageUtil.leader_of_project_{project_name}_{project_short_name}", new Object[]{PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, null), PrimitiveAssociationSemantics.get((Entity)entity, (String)"shortName", String.class, null)});
                        }
                    });
                }
            };
        }
        return new IncomingLinkViolation(linkName);
    }

    public void destructor(final Entity entity) {
        Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"UserRole", (NodeBase)new LinkEqual("projects", entity))).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity it) {
                DirectedAssociationSemantics.removeToMany((Entity)it, (String)"projects", (Entity)entity);
                if (Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)it, (String)"projects")).isEmpty()) {
                    DirectedAssociationSemantics.setToOne((Entity)it, (String)"role", null);
                    EntityOperations.remove((Entity)it);
                }
            }
        });
        securityLog.info((Object)("project " + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, (Object)IssueFolderImpl.getNullName()) + " deleted"));
        super.destructor(entity);
    }

    public String getDisplayName(Entity entity) {
        super.getDisplayName(entity);
        return (String)PrimitiveAssociationSemantics.getOldValue((TransientEntity)((TransientEntity)entity), (String)"name", String.class, (Object)IssueFolderImpl.getNullName()) + " (" + (String)PrimitiveAssociationSemantics.getOldValue((TransientEntity)((TransientEntity)entity), (String)"shortName", String.class, null) + ")";
    }

    public void executeBeforeFlushTrigger(Entity entity) {
        super.executeBeforeFlushTrigger(entity);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"name", (Comparable)((Object)ProjectImpl.trim_60mee4_a2a1a5((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, (Object)IssueFolderImpl.getNullName()))), String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"shortName", (Comparable)((Object)ProjectImpl.trim_60mee4_a2a2a5((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"shortName", String.class, null))), String.class);
    }

    public long nextIssueNumber(Entity entity) {
        long result = PrimitiveAssociationSemantics.incSequenceValue((TransientStoreSession)DnqUtils.getCurrentTransientSession(), (Entity)entity, (String)"nextNumberGenerator");
        if (result == 0L) {
            result = PrimitiveAssociationSemantics.incSequenceValue((TransientStoreSession)DnqUtils.getCurrentTransientSession(), (Entity)entity, (String)"nextNumberGenerator");
        }
        return result;
    }

    public long currentIssueNumber(Entity entity) {
        return PrimitiveAssociationSemantics.getSequenceValue((TransientStoreSession)DnqUtils.getCurrentTransientSession(), (Entity)entity, (String)"nextNumberGenerator");
    }

    public void setNextIssueNumber(long next, Entity entity) {
        PrimitiveAssociationSemantics.setSequenceValue((TransientStoreSession)DnqUtils.getCurrentTransientSession(), (Entity)entity, (String)"nextNumberGenerator", (long)next);
    }

    public Iterable<Entity> getSortedFields(Entity entity) {
        return ((ProjectImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Project")).sortFields(AssociationSemantics.getToMany((Entity)entity, (String)"fields"), entity);
    }

    public Iterable<Entity> sortFields(Iterable<Entity> fields, Entity entity) {
        if (((Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"fieldsSorted", Boolean.class, null)).booleanValue()) {
            return QueryOperations.query(fields, (String)"ProjectCustomField", (NodeBase)new SortByProperty(null, "ordinal", true));
        }
        return QueryOperations.query(fields, (String)"ProjectCustomField", (NodeBase)new SortByLinkProperty(null, "CustomFieldPrototype", "ordinal", "prototype", true));
    }

    public Entity getProjectCustomField(String name, Entity entity) {
        return QueryOperations.getFirst((Iterable)QueryOperations.query((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"fields"), (String)"ProjectCustomField", (NodeBase)new LinksEqualDecorator("prototype", (NodeBase)new PropertyEqual("name", (Comparable)((Object)name)), "CustomFieldPrototype")));
    }

    public Entity getProjectCustomField(Entity prototype, Entity entity) {
        return QueryOperations.getFirst((Iterable)QueryOperations.query((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"fields"), (String)"ProjectCustomField", (NodeBase)new LinkEqual("prototype", prototype)));
    }

    public long getNextIssueNumber(Entity entity) {
        return PrimitiveAssociationSemantics.getSequenceValue((TransientStoreSession)DnqUtils.getCurrentTransientSession(), (Entity)entity, (String)"nextNumberGenerator");
    }

    @Override
    public String getUrlUnsafe(String query, Integer pageNum, Entity entity) {
        return UrlUtil.getHtmlTemplateUri((String)"Issues", (String)"folderId", (QueryParameter[])new QueryParameter[]{new QueryParameter("folderId", PrimitiveAssociationSemantics.get((Entity)entity, (String)"shortName", String.class, null), (TypeConvertManager)ServiceLocator.getBean((String)"typeConvertManager")), new QueryParameter("p", (Object)pageNum, (TypeConvertManager)ServiceLocator.getBean((String)"typeConvertManager")), new QueryParameter("q", (Object)query, (TypeConvertManager)ServiceLocator.getBean((String)"typeConvertManager"))});
    }

    public Entity getUser(String login, Entity entity) {
        return QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"User", (NodeBase)new PropertyEqual("login", (Comparable)((Object)login))));
    }

    public boolean isArchived(Entity entity) {
        return (Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"archived", Boolean.class, null);
    }

    @Override
    public boolean isAccessible(Operation operation, Entity user, Entity entity) {
        Permission permission;
        if (EntityOperations.isNew((Entity)entity)) {
            return true;
        }
        boolean result = operation == Operation.READ ? ((Security)ServiceLocator.getBean((String)"security")).hasPermission(user, Permission.READ_PROJECT_BASIC, entity) || ((Security)ServiceLocator.getBean((String)"security")).hasPermission(user, Permission.READ_PROJECT, entity) : (operation == Operation.SHARE ? false : ((permission = ((PermissionAux)ServiceLocator.getBean((String)"permissionAux")).findPermission("Project", operation)) != null ? ((Security)ServiceLocator.getBean((String)"security")).hasPermission(user, permission, entity) : false));
        return result;
    }

    public Iterable<Entity> getIssuesByNumberPrefix(long n, Entity entity) {
        Object result = QueryOperations.query((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"issues"), (String)"Issue", (NodeBase)new PropertyEqual("numberInProject", (Comparable)Long.valueOf(n)));
        long issueCount = PrimitiveAssociationSemantics.getSequenceValue((TransientStoreSession)DnqUtils.getCurrentTransientSession(), (Entity)entity, (String)"nextNumberGenerator");
        long addend = 1L;
        while (true) {
            addend *= 10L;
            if ((n *= 10L) >= issueCount) break;
            result = QueryOperations.concat((Iterable)result, (Iterable)QueryOperations.query((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"issues"), (String)"Issue", (NodeBase)new And((NodeBase)new PropertyRange("numberInProject", (Comparable)Long.valueOf(n), PrimitiveAssociationSemantics.positiveInfinity(Long.class)), (NodeBase)new PropertyRange("numberInProject", PrimitiveAssociationSemantics.negativeInfinity(Long.class), PrimitiveAssociationSemantics.previousLess((Comparable)Long.valueOf(n + addend), Long.class)))));
        }
        return result;
    }

    @Override
    public Iterable<Entity> getQueryProjects(Entity entity) {
        return QueryOperations.singleton((Entity)entity);
    }

    @Override
    public boolean isNotUnpinned(Entity user, Entity entity) {
        return ProjectPinImpl.isPinned(user, entity);
    }

    @Override
    public void setPinned(Entity user, Boolean value, Entity entity) {
        ProjectPinImpl.setPinned(user, entity, value);
    }

    @Override
    public String getTitle(Entity entity) {
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Project.Project", new Object[]{PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, (Object)IssueFolderImpl.getNullName())});
    }

    public String getKey(Entity entity) {
        return (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"shortName", String.class, null);
    }

    public static Entity constructor(String name, String shortName, Entity createdBy) {
        return ((ProjectImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(name, shortName, createdBy, __ENTITY_TYPE__);
    }

    public static Entity findProject(String shortName) {
        if (shortName == null) {
            return null;
        }
        return QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"Project", (NodeBase)new PropertyEqual("shortName", (Comparable)((Object)shortName))));
    }

    public static Entity findByName(String name) {
        if (name == null) {
            return null;
        }
        return QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"Project", (NodeBase)new PropertyEqual("name", (Comparable)((Object)name))));
    }

    public static Entity findByImportedId(String id) {
        return QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"Project", (NodeBase)new PropertyEqual("jiraId", (Comparable)((Object)id))));
    }

    @Nullable
    public static Entity findReadableProject(@Nullable String shortName, @NotNull Entity forUser) {
        if (shortName == null) {
            return null;
        }
        Entity project = ProjectImpl.findProject(shortName);
        if (EntityOperations.equals((Entity)project, null)) {
            return null;
        }
        if (!((Security)ServiceLocator.getBean((String)"security")).hasPermission(forUser, Permission.READ_PROJECT_BASIC, project)) {
            throw new SecurityException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Project.Project_with_key_{0}_is_not_found", new Object[]{shortName}));
        }
        return project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteProject(Entity p) {
        PersistentEntityStoreImpl store = (PersistentEntityStoreImpl)((PersistentEntityStore)ServiceLocator.getBean((String)"persistentEntityStore"));
        Environment env = store.getEnvironment();
        env.suspendGC();
        try {
            boolean shouldSuspendIndex;
            String name = (String)PrimitiveAssociationSemantics.get((Entity)p, (String)"name", String.class, (Object)IssueFolderImpl.getNullName());
            securityLog.info((Object)("project " + name + " scheduled for deletion"));
            boolean goon = true;
            boolean bl = shouldSuspendIndex = !TextIndexOperationsCompat.getTextIndexManager().isSuspended();
            if (shouldSuspendIndex) {
                TextIndexOperationsCompat.getTextIndexManager().suspendIndexing();
            }
            try {
                int deleted = 0;
                while (goon) {
                    goon = false;
                    for (Entity issue : Sequence.fromIterable((Iterable)QueryOperations.take((Iterable)QueryOperations.query(null, (String)"Issue", (NodeBase)new LinkEqual("project", p)), (int)500))) {
                        goon = true;
                        EntityOperations.remove((Entity)issue);
                        ++deleted;
                    }
                    DnqUtils.getCurrentTransientSession().flush();
                    if (deleted % 1000 != 0 && goon) continue;
                    securityLog.info((Object)(deleted + " issues deleted in project " + name));
                }
                deleted = 0;
                while (goon) {
                    goon = false;
                    for (Entity issueKey : Sequence.fromIterable((Iterable)QueryOperations.take((Iterable)QueryOperations.query(null, (String)"IssueKey", (NodeBase)new LinkEqual("project", p)), (int)1000))) {
                        goon = true;
                        EntityOperations.remove((Entity)issueKey);
                        ++deleted;
                    }
                    DnqUtils.getCurrentTransientSession().flush();
                    if (deleted % 1000 != 0 && goon) continue;
                    securityLog.info((Object)(deleted + " issue keys deleted in project " + name));
                }
                EntityOperations.remove((Entity)p);
                DnqUtils.getCurrentTransientSession().flush();
            }
            finally {
                if (shouldSuspendIndex) {
                    TextIndexOperationsCompat.getTextIndexManager().resumeIndexing();
                }
            }
        }
        finally {
            env.resumeGC();
        }
    }

    public static String trim_60mee4_a2a1a5(String str) {
        return str == null ? null : str.trim();
    }

    public static String trim_60mee4_a2a2a5(String str) {
        return str == null ? null : str.trim();
    }
}

