/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.core.persistent.order;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import jetbrains.exodus.core.dataStructures.hash.LinkedHashSet;
import jetbrains.youtrack.core.persistent.EntityContainer;
import jetbrains.youtrack.core.persistent.order.EntityIdsSerializer;
import jetbrains.youtrack.core.persistent.order.IssueByIdComparator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\u0004\u0018\u0000 \u001f*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u001fB\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010\u0019\u001a\u00020\u001aJ\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cH\u0096\u0002J\u000e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0005J\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR:\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000b2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010\u0012\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00112\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Ljetbrains/youtrack/core/persistent/order/OrderedEntityContainersIterable;", "T", "Ljetbrains/youtrack/core/persistent/EntityContainer;", "", "sortOrder", "", "(Ljava/lang/Iterable;)V", "isEmpty", "", "()Z", "<set-?>", "", "manuallySortedItems", "getManuallySortedItems", "()Ljava/util/Map;", "size", "", "Ljava/util/SortedSet;", "sortedByIdItems", "getSortedByIdItems", "()Ljava/util/SortedSet;", "add", "", "item", "(Ljetbrains/youtrack/core/persistent/EntityContainer;)V", "dump", "Ljava/io/InputStream;", "iterator", "", "removeFromOrder", "id", "Companion", "youtrack-core"})
public final class OrderedEntityContainersIterable<T extends EntityContainer<?>>
implements Iterable<T>,
KMappedMarker {
    private int size;
    @NotNull
    private Map<Long, T> manuallySortedItems;
    @Nullable
    private SortedSet<T> sortedByIdItems;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Map<Long, T> getManuallySortedItems() {
        return this.manuallySortedItems;
    }

    @Nullable
    public final SortedSet<T> getSortedByIdItems() {
        return this.sortedByIdItems;
    }

    public final boolean isEmpty() {
        return this.size <= 0;
    }

    public final void add(@NotNull T item) {
        Intrinsics.checkParameterIsNotNull(item, (String)"item");
        long issueLocalId = item.getEntityLocalId();
        if (this.manuallySortedItems.containsKey(issueLocalId)) {
            Map<Long, T> map = this.manuallySortedItems;
            Long l = issueLocalId;
            T t = item;
            map.put(l, t);
        } else {
            if (this.sortedByIdItems == null) {
                this.sortedByIdItems = new TreeSet(IssueByIdComparator.INSTANCE);
            }
            SortedSet<T> sortedSet = this.sortedByIdItems;
            if (sortedSet == null) {
                Intrinsics.throwNpe();
            }
            sortedSet.add(item);
        }
        int n = this.size;
        this.size = n + 1;
    }

    public final int size() {
        return this.size;
    }

    public final void removeFromOrder(long id) {
        this.manuallySortedItems.remove(id);
    }

    @NotNull
    public final InputStream dump() {
        ByteArrayOutputStream newWorldOrder = new ByteArrayOutputStream();
        byte[] buf = new byte[9];
        Iterable $receiver$iv = this.manuallySortedItems.keySet();
        for (Object element$iv : $receiver$iv) {
            long entityLocalId = ((Number)element$iv).longValue();
            boolean bl = false;
            try {
                EntityIdsSerializer.INSTANCE.serializeId(entityLocalId, newWorldOrder, buf);
            }
            catch (IOException e) {
                throw (Throwable)new RuntimeException(e);
            }
        }
        return new ByteArrayInputStream(newWorldOrder.toByteArray());
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(this){
            private Iterator<? extends T> manuallySortedItemsIterator;
            private final Iterator<T> sortedByUpdatedItemsIterator;
            private T item;
            final /* synthetic */ OrderedEntityContainersIterable this$0;

            public boolean hasNext() {
                this.item = null;
                Iterator<T> manualIterator = this.manuallySortedItemsIterator;
                if (manualIterator != null) {
                    while (manualIterator.hasNext() && this.item == null) {
                        this.item = (EntityContainer)manualIterator.next();
                    }
                    if (this.item == null) {
                        this.manuallySortedItemsIterator = null;
                    }
                }
                Iterator<T> updatedIterator = this.sortedByUpdatedItemsIterator;
                if (this.item == null && updatedIterator != null && updatedIterator.hasNext()) {
                    this.item = (EntityContainer)updatedIterator.next();
                }
                return this.item != null;
            }

            @NotNull
            public T next() {
                T t = this.item;
                if (t == null) {
                    Intrinsics.throwNpe();
                }
                return t;
            }
            {
                this.this$0 = $outer;
                this.manuallySortedItemsIterator = $outer.getManuallySortedItems().values().iterator();
                SortedSet<T> sortedSet = $outer.getSortedByIdItems();
                this.sortedByUpdatedItemsIterator = sortedSet != null ? sortedSet.iterator() : null;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    public OrderedEntityContainersIterable(@NotNull Iterable<Long> sortOrder) {
        Intrinsics.checkParameterIsNotNull(sortOrder, (String)"sortOrder");
        this.manuallySortedItems = new LinkedHashMap();
        Iterable<Long> $receiver$iv = sortOrder;
        for (Long element$iv : $receiver$iv) {
            long it = ((Number)element$iv).longValue();
            boolean bl = false;
            Map<Long, T> map = this.manuallySortedItems;
            Long l = it;
            Object v = null;
            map.put(l, v);
        }
    }

    public static final /* synthetic */ Map access$getManuallySortedItems$p(OrderedEntityContainersIterable $this) {
        return $this.manuallySortedItems;
    }

    public static final /* synthetic */ void access$setManuallySortedItems$p(OrderedEntityContainersIterable $this, Map map) {
        $this.manuallySortedItems = map;
    }

    public static final /* synthetic */ SortedSet access$getSortedByIdItems$p(OrderedEntityContainersIterable $this) {
        return $this.sortedByIdItems;
    }

    public static final /* synthetic */ void access$setSortedByIdItems$p(OrderedEntityContainersIterable $this, SortedSet sortedSet) {
        $this.sortedByIdItems = sortedSet;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JA\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Ljetbrains/youtrack/core/persistent/order/OrderedEntityContainersIterable$Companion;", "", "()V", "move", "Ljava/io/InputStream;", "issueLocalId", "", "prevIssueId", "existingOrder", "", "sortedById", "strict", "", "(JLjava/lang/Long;Ljava/lang/Iterable;Ljava/lang/Iterable;Z)Ljava/io/InputStream;", "youtrack-core"})
    public static final class Companion {
        @NotNull
        public final InputStream move(long issueLocalId, @Nullable Long prevIssueId, @NotNull Iterable<Long> existingOrder, @NotNull Iterable<Long> sortedById, boolean strict) {
            Intrinsics.checkParameterIsNotNull(existingOrder, (String)"existingOrder");
            Intrinsics.checkParameterIsNotNull(sortedById, (String)"sortedById");
            Long l = prevIssueId;
            long prevIssue = l != null ? l : -1L;
            LinkedHashSet issueIds = new LinkedHashSet();
            Iterable<Long> $receiver$iv = sortedById;
            for (Long element$iv : $receiver$iv) {
                long it = ((Number)element$iv).longValue();
                boolean bl = false;
                issueIds.add((Object)it);
            }
            ByteArrayOutputStream newWorldOrder = new ByteArrayOutputStream();
            byte[] buf = new byte[9];
            try {
                long prevIssueLocalId = -1L;
                boolean saved = false;
                Iterator<Long> iterator2 = existingOrder.iterator();
                while (iterator2.hasNext()) {
                    long id = ((Number)iterator2.next()).longValue();
                    if (!issueIds.remove((Object)id) && strict || issueLocalId == id) continue;
                    if (prevIssueLocalId == prevIssue) {
                        EntityIdsSerializer.INSTANCE.serializeId(issueLocalId, newWorldOrder, buf);
                        saved = true;
                    }
                    EntityIdsSerializer.INSTANCE.serializeId(id, newWorldOrder, buf);
                    prevIssueLocalId = id;
                }
                if (!saved) {
                    for (Long id : issueIds) {
                        Long l2 = id;
                        if (l2 != null && issueLocalId == l2) continue;
                        if (prevIssueLocalId == prevIssue) {
                            EntityIdsSerializer.INSTANCE.serializeId(issueLocalId, newWorldOrder, buf);
                            saved = true;
                            break;
                        }
                        Long l3 = id;
                        Intrinsics.checkExpressionValueIsNotNull((Object)l3, (String)"id");
                        EntityIdsSerializer.INSTANCE.serializeId(l3, newWorldOrder, buf);
                        prevIssueLocalId = id;
                    }
                }
                if (!saved) {
                    EntityIdsSerializer.INSTANCE.serializeId(issueLocalId, newWorldOrder, buf);
                }
            }
            catch (IOException e) {
                throw (Throwable)new RuntimeException(e);
            }
            return new ByteArrayInputStream(newWorldOrder.toByteArray());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

