/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.core.security;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;

public class PermissionAux {
    private final Map<String, Map<Operation, Permission>> pcAndOperationToPermission = new HashMap<String, Map<Operation, Permission>>();

    public void init() {
        for (Permission p : Permission.values()) {
            Map<Operation, Permission> m = this.pcAndOperationToPermission.get(p.getPersistentClass());
            if (m == null) {
                m = new HashMap<Operation, Permission>();
                this.pcAndOperationToPermission.put(p.getPersistentClass(), m);
            }
            m.put(p.getOperation(), p);
        }
    }

    public Iterable<String> getPossiblePersistentClasses() {
        return this.pcAndOperationToPermission.keySet();
    }

    public Iterable<Operation> getPossibleOperations(String pc) {
        Map<Operation, Permission> operations = this.pcAndOperationToPermission.get(pc);
        return operations == null ? Collections.emptySet() : operations.keySet();
    }

    public Permission findPermission(String persistentClass, Operation operation) {
        return this.pcAndOperationToPermission.get(persistentClass).get((Object)operation);
    }
}

