/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.core.watchFolder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jetbrains.exodus.util.ByteUtil;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;

public enum RuleType {
    NOTIFY_ON_NEW_ISSUE(1, "rule_type.on_issue_created", "Rule.Notify_me_on_new_issue_creation", true),
    NOTIFY_ON_ISSUE_UPDATE(2, "rule_type.on_issue_updated", "Rule.Notify_me_on_issue_update_includes_issue_resolution", true),
    NOTIFY_ON_ISSUE_RESOLVE(3, "rule_type.on_issue_resolved", "Rule.Notify_me_on_issue_resolve", true),
    NOTIFY_ON_COMMENT_POST(4, "rule_type.on_comment_posted", "Rule.Notify_me_on_comment_post", true),
    NOTIFY_ON_VOTE(5, "rule_type.on_issue_voted", "Rule.Notify_me_on_issue_vote_unvote", true),
    UNTAG_ON_RESOLVE(6, "rule_type.Untag_on_resolve", "Rule.Remove_tag_from_the_issue_when_issue_is_resolved", false),
    NOTIFY_ON_TAG(7, "rule_type.on_issue_tagged", "Rule.Notify_me_on_issue_tagged_with_this_tag", true),
    NOTIFY_ON_UNTAG(8, "rule_type.on_issue_untagged", "Rule.Notify_me_on_issue_untagged_with_this_tag", true),
    PINNED(9, "rule_type.Pinned", "Rule.Show_tag_saved_search", false),
    UNPINNED(10, "rule_type.Unpinned", "Rule.Show_tag_saved_search", false),
    NOTIFY_ON_TIME_TRACKING(11, "rule_type.on_time_tracking_activity", "Rule.Notify_me_on_time_tracking_changes", true);

    private static int TAGS_RULE_MASK;
    public final int mask;
    private String nameLocalizationId;
    private String descriptionLocalizationId;
    private boolean notify;

    private RuleType(int mask, String nameLocalizationId, boolean notify, String descriptionLocalizaionId) {
        this.mask = mask;
        this.nameLocalizationId = nameLocalizationId;
        this.descriptionLocalizationId = descriptionLocalizaionId;
        this.notify = notify;
    }

    private RuleType(int bit, String name, String descriptionLocalizaionId, boolean notify) {
        this(ByteUtil.shiftLeft((int)1, (int)bit), name, notify, descriptionLocalizaionId);
    }

    public int set(int mask, boolean value) {
        int result = value ? ByteUtil.or((int)mask, (int)this.mask) : ByteUtil.and((int)mask, (int)ByteUtil.xor((int)this.mask, (int)-1));
        return result;
    }

    public int toggle(int mask) {
        return ByteUtil.xor((int)mask, (int)this.mask);
    }

    public boolean is(int mask) {
        return RuleType.is(mask, this.mask);
    }

    public String getName() {
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg(this.nameLocalizationId, new Object[0]);
    }

    public String getDescription() {
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg(this.descriptionLocalizationId, new Object[0]);
    }

    public boolean isNotify() {
        return this.notify;
    }

    public static Iterable<RuleType> getRuleTypes() {
        return Arrays.asList(RuleType.values());
    }

    public static Iterable<RuleType> getSavedSearchesRuleTypes() {
        return Sequence.fromIterable(RuleType.getRuleTypes()).where((_FunctionTypes._return_P1_E0)new IWhereFilter<RuleType>(){

            public boolean accept(RuleType it) {
                return it.isNotify();
            }
        }).subtract((ISequence)ListSequence.fromList((List)ListSequence.fromListAndArray(new ArrayList(), (Object[])new RuleType[]{NOTIFY_ON_TAG, NOTIFY_ON_UNTAG})));
    }

    public static Iterable<RuleType> getTagsRuleTypes() {
        return Sequence.fromIterable(RuleType.getRuleTypes()).where((_FunctionTypes._return_P1_E0)new IWhereFilter<RuleType>(){

            public boolean accept(RuleType it) {
                return it.isNotify();
            }
        }).subtract(Sequence.fromIterable((Iterable)Sequence.singleton((Object)((Object)NOTIFY_ON_NEW_ISSUE))));
    }

    public static int getTagsRuleMask() {
        int mask = TAGS_RULE_MASK;
        if (mask == -1) {
            mask = 0;
            for (RuleType ruleType : Sequence.fromIterable(RuleType.getTagsRuleTypes())) {
                mask |= ruleType.mask;
            }
            TAGS_RULE_MASK = mask;
        }
        return mask;
    }

    public static int getTagsRuleMaskWithPin() {
        return PINNED.set(RuleType.getTagsRuleMask(), true);
    }

    public static int getMaskWithPin() {
        return RuleType.PINNED.mask;
    }

    public static boolean is(int mask, int matchingMask) {
        return ByteUtil.and((int)mask, (int)matchingMask) != 0;
    }

    static {
        TAGS_RULE_MASK = -1;
    }
}

