/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.wrappers;

import com.jetbrains.launcher.AppExitCode;
import com.jetbrains.launcher.ApplicationFacadeAdapter2;
import com.jetbrains.launcher.ConfiguringService;
import com.jetbrains.launcher.RunningService;
import com.jetbrains.launcher.Status;
import com.jetbrains.launcher.StatusDescriptor;
import com.jetbrains.launcher.contexts.ApplicationContext;
import com.jetbrains.launcher.contexts.ShutdownContext;
import com.jetbrains.launcher.contexts.StartupContext;
import com.jetbrains.launcher.contexts.StatusContext;
import com.jetbrains.launcher.exceptions.ShutdownException;
import com.jetbrains.launcher.exceptions.StartupException;
import com.jetbrains.launcher.exceptions.StatusException;
import com.jetbrains.launcher.wrappers.MockConfiguringService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SimpleApplication
extends ApplicationFacadeAdapter2
implements RunningService {
    @NotNull
    private volatile Status myStatus = Status.STARTING;

    @Override
    @NotNull
    public ConfiguringService createConfiguringService(@NotNull ApplicationContext context) {
        if (context == null) {
            SimpleApplication.$$$reportNull$$$0(0);
        }
        MockConfiguringService mockConfiguringService = new MockConfiguringService();
        if (mockConfiguringService == null) {
            SimpleApplication.$$$reportNull$$$0(1);
        }
        return mockConfiguringService;
    }

    @Override
    @NotNull
    public RunningService createRunningService(@NotNull ApplicationContext context) {
        if (context == null) {
            SimpleApplication.$$$reportNull$$$0(2);
        }
        SimpleApplication simpleApplication = this;
        if (simpleApplication == null) {
            SimpleApplication.$$$reportNull$$$0(3);
        }
        return simpleApplication;
    }

    @Override
    public void start(@NotNull StartupContext context) throws StartupException {
        List<String> args;
        if (context == null) {
            SimpleApplication.$$$reportNull$$$0(4);
        }
        if ((args = context.getCommandLine().getApplicationArguments()).isEmpty()) {
            throw new StartupException("Application main class is not specified in arguments");
        }
        Class<?> mainClass = SimpleApplication.loadMainClass(args.get(0));
        Method mainMethod = SimpleApplication.findMainMethod(mainClass);
        String[] programArgs = args.subList(1, args.size()).toArray(new String[args.size() - 1]);
        this.myStatus = Status.RUNNING;
        try {
            mainMethod.invoke(null, new Object[]{programArgs});
        }
        catch (IllegalAccessException e) {
            throw new StartupException("Failed to access main method in class: " + mainClass.getName() + ", modifiers: " + mainMethod.getModifiers(), e);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            throw new StartupException("Failed to invoke main method in class " + mainClass.getName() + ": " + target.getMessage(), target);
        }
    }

    @NotNull
    private static Class<?> loadMainClass(@NotNull String className) throws StartupException {
        Class<?> clazz;
        if (className == null) {
            SimpleApplication.$$$reportNull$$$0(5);
        }
        try {
            clazz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new StartupException("Failed to find main class: " + className, e);
        }
        if (clazz == null) {
            SimpleApplication.$$$reportNull$$$0(6);
        }
        return clazz;
    }

    @NotNull
    private static Method findMainMethod(@NotNull Class<?> mainClass) throws StartupException {
        Method method;
        if (mainClass == null) {
            SimpleApplication.$$$reportNull$$$0(7);
        }
        try {
            method = mainClass.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException e) {
            throw new StartupException("Failed to find main method in class: " + mainClass.getName(), e);
        }
        if (method == null) {
            SimpleApplication.$$$reportNull$$$0(8);
        }
        return method;
    }

    @Override
    @NotNull
    public StatusDescriptor getStatus(@NotNull StatusContext context) throws StatusException {
        if (context == null) {
            SimpleApplication.$$$reportNull$$$0(9);
        }
        StatusDescriptor statusDescriptor = new StatusDescriptor(this.myStatus, null);
        if (statusDescriptor == null) {
            SimpleApplication.$$$reportNull$$$0(10);
        }
        return statusDescriptor;
    }

    @Override
    @NotNull
    public AppExitCode shutdown(@NotNull ShutdownContext context) throws ShutdownException {
        if (context == null) {
            SimpleApplication.$$$reportNull$$$0(11);
        }
        this.myStatus = Status.SHUTTING_DOWN;
        AppExitCode appExitCode = context.getSuggestedExitCode();
        if (appExitCode == null) {
            SimpleApplication.$$$reportNull$$$0(12);
        }
        return appExitCode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/wrappers/SimpleApplication";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/wrappers/SimpleApplication";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfiguringService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createRunningService";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "loadMainClass";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findMainMethod";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "shutdown";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createConfiguringService";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createRunningService";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadMainClass";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findMainMethod";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "shutdown";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

